/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.optimizer.impl.lj;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.node.BinaryNonCommutativeOperatorNode;
import it.unibz.inf.ontop.iq.node.LeftJoinNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBStrictEqFunctionSymbol;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;

@Singleton
public class ComplexStrictEqualityLeftJoinExpliciter {
    private final TermFactory termFactory;
    private final SubstitutionFactory substitutionFactory;
    private final IntermediateQueryFactory iqFactory;

    @Inject
    protected ComplexStrictEqualityLeftJoinExpliciter(TermFactory termFactory, SubstitutionFactory substitutionFactory, IntermediateQueryFactory iqFactory) {
        this.termFactory = termFactory;
        this.substitutionFactory = substitutionFactory;
        this.iqFactory = iqFactory;
    }

    public LeftJoinNormalization makeComplexEqualitiesImplicit(IQTree leftChild, IQTree rightChild, Optional<ImmutableExpression> ljCondition, VariableGenerator variableGenerator) {
        if (ljCondition.isPresent()) {
            return this.makeComplexEqualitiesImplicit(leftChild, rightChild, ljCondition.get(), (Substitution<ImmutableTerm>)this.substitutionFactory.getSubstitution(), variableGenerator);
        }
        return new LeftJoinNormalization(leftChild, rightChild, ljCondition, false);
    }

    protected LeftJoinNormalization makeComplexEqualitiesImplicit(IQTree leftChild, IQTree rightChild, ImmutableExpression ljCondition, Substitution<ImmutableTerm> downSubstitution, VariableGenerator variableGenerator) {
        IQTree newLeft;
        ImmutableSet leftVariables = leftChild.getVariables();
        ImmutableSet rightSpecificVariables = Sets.difference((Set)rightChild.getVariables(), (Set)leftVariables).immutableCopy();
        ImmutableMap conditionMap = (ImmutableMap)ljCondition.flattenAND().collect(ImmutableCollectors.partitioningBy(e -> this.isDecomposibleStrictEquality((ImmutableExpression)e, (ImmutableSet<Variable>)leftVariables, (ImmutableSet<Variable>)rightSpecificVariables)));
        ImmutableList strictEqualities = (ImmutableList)conditionMap.get((Object)true);
        if (strictEqualities == null || strictEqualities.isEmpty()) {
            return new LeftJoinNormalization(leftChild, rightChild, Optional.of(ljCondition), false);
        }
        Optional<ImmutableExpression> newLJCondition = Optional.ofNullable((ImmutableList)conditionMap.get((Object)false)).filter(cs -> !cs.isEmpty()).map(arg_0 -> ((TermFactory)this.termFactory).getConjunction(arg_0));
        SubstitutionPair substitutionPair = this.computeSubstitutionPair((ImmutableSet<ImmutableExpression>)ImmutableSet.copyOf((Collection)strictEqualities), (ImmutableSet<Variable>)rightSpecificVariables, downSubstitution, variableGenerator);
        UnaryIQTree newRight = this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createConstructionNode(Sets.union((Set)substitutionPair.rightSubstitution.getDomain(), (Set)rightChild.getVariables()).immutableCopy(), substitutionPair.rightSubstitution), rightChild);
        return new LeftJoinNormalization(newLeft, (IQTree)newRight, newLJCondition, (newLeft = this.normalizeLeft(leftChild, substitutionPair.leftSubstitution, variableGenerator)).getVariables().size() != leftVariables.size());
    }

    private SubstitutionPair computeSubstitutionPair(ImmutableSet<ImmutableExpression> strictEqualities, ImmutableSet<Variable> rightSpecificVariables, Substitution<ImmutableTerm> downSubstitution, VariableGenerator variableGenerator) {
        HashMap<Variable, ImmutableTerm> leftSubstitutionMap = new HashMap<Variable, ImmutableTerm>();
        HashMap<Variable, ImmutableTerm> rightSubstitutionMap = new HashMap<Variable, ImmutableTerm>();
        for (ImmutableExpression strictEquality : strictEqualities) {
            ImmutableTerm leftArgument;
            ImmutableTerm rightArgument = strictEquality.getTerms().stream().filter(t -> t.getVariableStream().anyMatch(arg_0 -> ((ImmutableSet)rightSpecificVariables).contains(arg_0))).findAny().orElseThrow(() -> new MinorOntopInternalBugException("Was expecting a right argument"));
            ImmutableTerm immutableTerm = leftArgument = strictEquality.getTerm(0).equals(rightArgument) ? strictEquality.getTerm(1) : strictEquality.getTerm(0);
            if (leftArgument instanceof Variable) {
                rightSubstitutionMap.put((Variable)leftArgument, rightArgument);
                continue;
            }
            Optional<Variable> leftVariableFromDownSubstitution = downSubstitution.getPreImage(t -> t.equals(leftArgument)).stream().findAny();
            Variable leftVariable = leftVariableFromDownSubstitution.orElseGet(() -> ((VariableGenerator)variableGenerator).generateNewVariable());
            if (leftVariableFromDownSubstitution.isEmpty()) {
                leftSubstitutionMap.put(leftVariable, leftArgument);
            }
            rightSubstitutionMap.put(leftVariable, rightArgument);
        }
        return new SubstitutionPair((Substitution<ImmutableTerm>)downSubstitution.compose((Substitution)leftSubstitutionMap.entrySet().stream().collect(this.substitutionFactory.toSubstitution())), (Substitution<ImmutableTerm>)((Substitution)rightSubstitutionMap.entrySet().stream().collect(this.substitutionFactory.toSubstitution())));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isDecomposibleStrictEquality(ImmutableExpression expression, ImmutableSet<Variable> leftVariables, ImmutableSet<Variable> rightSpecificVariables) {
        if (!(expression.getFunctionSymbol() instanceof DBStrictEqFunctionSymbol)) {
            return false;
        }
        if (expression.getArity() != 2) {
            return false;
        }
        ImmutableList subTermVariables = (ImmutableList)expression.getTerms().stream().map(t -> (ImmutableSet)t.getVariableStream().collect(ImmutableCollectors.toSet())).collect(ImmutableCollectors.toList());
        if (!subTermVariables.stream().noneMatch(AbstractCollection::isEmpty)) return false;
        if (!subTermVariables.stream().anyMatch(arg_0 -> leftVariables.containsAll(arg_0))) return false;
        if (!subTermVariables.stream().anyMatch(arg_0 -> rightSpecificVariables.containsAll(arg_0))) return false;
        return true;
    }

    private IQTree normalizeLeft(IQTree tree, Substitution<ImmutableTerm> downSubstitution, VariableGenerator variableGenerator) {
        if (!(tree.getRootNode() instanceof LeftJoinNode) || !((IQTree)tree.getChildren().get(0)).getVariables().containsAll((Collection)downSubstitution.getRangeVariables())) {
            return downSubstitution.isEmpty() ? tree : this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createConstructionNode(Sets.union((Set)downSubstitution.getDomain(), (Set)tree.getVariables()).immutableCopy(), downSubstitution), tree);
        }
        IQTree leftChild = (IQTree)tree.getChildren().get(0);
        IQTree rightChild = (IQTree)tree.getChildren().get(1);
        LeftJoinNode leftJoinNode = (LeftJoinNode)tree.getRootNode();
        Optional leftJoinCondition = leftJoinNode.getOptionalFilterCondition();
        if (leftJoinCondition.isEmpty()) {
            IQTree newLeft = this.normalizeLeft(leftChild, downSubstitution, variableGenerator);
            return this.iqFactory.createBinaryNonCommutativeIQTree((BinaryNonCommutativeOperatorNode)leftJoinNode, newLeft, rightChild);
        }
        LeftJoinNormalization localNormalization = this.makeComplexEqualitiesImplicit(leftChild, rightChild, (ImmutableExpression)leftJoinCondition.get(), downSubstitution, variableGenerator);
        return this.iqFactory.createBinaryNonCommutativeIQTree((BinaryNonCommutativeOperatorNode)this.iqFactory.createLeftJoinNode(localNormalization.ljCondition), localNormalization.leftChild, localNormalization.rightChild);
    }

    public static class SubstitutionPair {
        public final Substitution<ImmutableTerm> leftSubstitution;
        public final Substitution<ImmutableTerm> rightSubstitution;

        public SubstitutionPair(Substitution<ImmutableTerm> leftSubstitution, Substitution<ImmutableTerm> rightSubstitution) {
            this.leftSubstitution = leftSubstitution;
            this.rightSubstitution = rightSubstitution;
        }
    }

    public static class LeftJoinNormalization {
        public final IQTree leftChild;
        public final IQTree rightChild;
        public final Optional<ImmutableExpression> ljCondition;
        public boolean isIntroducingNewVariables;

        public LeftJoinNormalization(IQTree leftChild, IQTree rightChild, Optional<ImmutableExpression> ljCondition, boolean isIntroducingNewVariables) {
            this.leftChild = leftChild;
            this.rightChild = rightChild;
            this.ljCondition = ljCondition;
            this.isIntroducingNewVariables = isIntroducingNewVariables;
        }
    }
}

