/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.optimizer.impl.lj;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.BinaryNonCommutativeOperatorNode;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.FilterNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.LeftJoinNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.OrderByNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.node.UnionNode;
import it.unibz.inf.ontop.iq.optimizer.LeftJoinIQOptimizer;
import it.unibz.inf.ontop.iq.optimizer.impl.LookForDistinctOrLimit1TransformerImpl;
import it.unibz.inf.ontop.iq.transform.IQTreeTransformer;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.transform.impl.DefaultNonRecursiveIQTreeTransformer;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Collection;
import java.util.Set;

@Singleton
public class CardinalityInsensitiveLJPruningOptimizer
implements LeftJoinIQOptimizer {
    private final CoreSingletons coreSingletons;
    private final IntermediateQueryFactory iqFactory;

    @Inject
    protected CardinalityInsensitiveLJPruningOptimizer(CoreSingletons coreSingletons) {
        this.coreSingletons = coreSingletons;
        this.iqFactory = coreSingletons.getIQFactory();
    }

    @Override
    public IQ optimize(IQ query) {
        LookForDistinctOrLimit1TransformerImpl transformer;
        IQTree initialTree = query.getTree();
        IQTree newTree = initialTree.acceptTransformer((IQTreeVisitingTransformer)(transformer = new LookForDistinctOrLimit1TransformerImpl((childTree, parentTransformer) -> new CardinalityInsensitiveLJPruningTransformer(parentTransformer, this.coreSingletons, (ImmutableSet<Variable>)childTree.getVariables()), this.coreSingletons)));
        return newTree.equals(initialTree) ? query : this.iqFactory.createIQ(query.getProjectionAtom(), newTree);
    }

    protected static class CardinalityInsensitiveLJPruningTransformer
    extends DefaultNonRecursiveIQTreeTransformer {
        private final IQTreeTransformer lookForDistinctTransformer;
        private final CoreSingletons coreSingletons;
        private final ImmutableSet<Variable> variablesUsedByAncestors;
        private final IntermediateQueryFactory iqFactory;

        protected CardinalityInsensitiveLJPruningTransformer(IQTreeTransformer lookForDistinctTransformer, CoreSingletons coreSingletons, ImmutableSet<Variable> variablesUsedByAncestors) {
            this.lookForDistinctTransformer = lookForDistinctTransformer;
            this.coreSingletons = coreSingletons;
            this.variablesUsedByAncestors = variablesUsedByAncestors;
            this.iqFactory = coreSingletons.getIQFactory();
        }

        public IQTree transformConstruction(IQTree tree, ConstructionNode rootNode, IQTree child) {
            Sets.SetView newVariablesUsed = Sets.union(this.variablesUsedByAncestors, (Set)rootNode.getLocallyRequiredVariables());
            CardinalityInsensitiveLJPruningTransformer newTransformer = newVariablesUsed.equals(this.variablesUsedByAncestors) ? this : this.computeNewTransformer((ImmutableSet<Variable>)newVariablesUsed.immutableCopy());
            IQTree newChild = child.acceptTransformer((IQTreeVisitingTransformer)newTransformer);
            return newChild.equals(child) && rootNode.equals(tree.getRootNode()) ? tree : this.iqFactory.createUnaryIQTree((UnaryOperatorNode)rootNode, newChild);
        }

        public IQTree transformFilter(IQTree tree, FilterNode rootNode, IQTree child) {
            CardinalityInsensitiveLJPruningTransformer newTransformer = rootNode.getOptionalFilterCondition().map(ImmutableFunctionalTerm::getVariables).filter(vs -> !vs.isEmpty()).map(vs -> Sets.union(this.variablesUsedByAncestors, (Set)vs).immutableCopy()).map(this::computeNewTransformer).orElse(this);
            IQTree newChild = child.acceptTransformer((IQTreeVisitingTransformer)newTransformer);
            return newChild.equals(child) && rootNode.equals(tree.getRootNode()) ? tree : this.iqFactory.createUnaryIQTree((UnaryOperatorNode)rootNode, newChild);
        }

        public IQTree transformOrderBy(IQTree tree, OrderByNode rootNode, IQTree child) {
            return this.applyRecursivelyToUnaryNode(tree, (UnaryOperatorNode)rootNode, child);
        }

        protected IQTree applyRecursivelyToUnaryNode(IQTree tree, UnaryOperatorNode rootNode, IQTree child) {
            IQTree newChild = child.acceptTransformer((IQTreeVisitingTransformer)this);
            return newChild.equals(child) && rootNode.equals(tree.getRootNode()) ? tree : this.iqFactory.createUnaryIQTree(rootNode, newChild);
        }

        public IQTree transformLeftJoin(IQTree tree, LeftJoinNode rootNode, IQTree leftChild, IQTree rightChild) {
            ImmutableSet treeVariables = tree.getVariables();
            ImmutableSet leftVariables = leftChild.getVariables();
            if (treeVariables.isEmpty() || leftVariables.containsAll((Collection)Sets.intersection(this.variablesUsedByAncestors, (Set)treeVariables))) {
                return leftChild.acceptTransformer((IQTreeVisitingTransformer)this);
            }
            Sets.SetView commonVariables = Sets.intersection((Set)leftVariables, (Set)rightChild.getVariables());
            ImmutableSet newVariablesUsed = rootNode.getOptionalFilterCondition().map(ImmutableFunctionalTerm::getVariables).filter(vs -> !vs.isEmpty()).map(vs -> Sets.union(this.variablesUsedByAncestors, (Set)Sets.union((Set)vs, (Set)commonVariables)).immutableCopy()).orElse(Sets.union(this.variablesUsedByAncestors, (Set)commonVariables).immutableCopy());
            CardinalityInsensitiveLJPruningTransformer newTransformer = newVariablesUsed.equals(this.variablesUsedByAncestors) ? this : this.computeNewTransformer((ImmutableSet<Variable>)newVariablesUsed);
            IQTree newLeft = leftChild.acceptTransformer((IQTreeVisitingTransformer)newTransformer);
            IQTree newRight = rightChild.acceptTransformer((IQTreeVisitingTransformer)newTransformer);
            return newLeft.equals(leftChild) && newRight.equals(rightChild) ? tree : this.iqFactory.createBinaryNonCommutativeIQTree((BinaryNonCommutativeOperatorNode)rootNode, newLeft, newRight);
        }

        public IQTree transformUnion(IQTree tree, UnionNode rootNode, ImmutableList<IQTree> children) {
            return this.applyRecursivelyToNaryNode(tree, (NaryOperatorNode)rootNode, children);
        }

        public IQTree transformInnerJoin(IQTree tree, InnerJoinNode rootNode, ImmutableList<IQTree> children) {
            CardinalityInsensitiveLJPruningTransformer newTransformer = rootNode.getOptionalFilterCondition().map(ImmutableFunctionalTerm::getVariables).filter(vs -> !vs.isEmpty()).map(vs -> Sets.union(this.variablesUsedByAncestors, (Set)vs).immutableCopy()).map(this::computeNewTransformer).orElse(this);
            ImmutableList newChildren = (ImmutableList)children.stream().map(t -> t.acceptTransformer((IQTreeVisitingTransformer)newTransformer)).collect(ImmutableCollectors.toList());
            return newChildren.equals(children) && rootNode.equals(tree.getRootNode()) ? tree : this.iqFactory.createNaryIQTree((NaryOperatorNode)rootNode, newChildren);
        }

        protected IQTree applyRecursivelyToNaryNode(IQTree tree, NaryOperatorNode rootNode, ImmutableList<IQTree> children) {
            ImmutableList newChildren = (ImmutableList)children.stream().map(t -> t.acceptTransformer((IQTreeVisitingTransformer)this)).collect(ImmutableCollectors.toList());
            return newChildren.equals(children) && rootNode.equals(tree.getRootNode()) ? tree : this.iqFactory.createNaryIQTree(rootNode, newChildren);
        }

        protected IQTree transformUnaryNode(IQTree tree, UnaryOperatorNode rootNode, IQTree child) {
            return this.lookForDistinctTransformer.transform(tree);
        }

        protected IQTree transformNaryCommutativeNode(IQTree tree, NaryOperatorNode rootNode, ImmutableList<IQTree> children) {
            return this.lookForDistinctTransformer.transform(tree);
        }

        protected IQTree transformBinaryNonCommutativeNode(IQTree tree, BinaryNonCommutativeOperatorNode rootNode, IQTree leftChild, IQTree rightChild) {
            return this.lookForDistinctTransformer.transform(tree);
        }

        private CardinalityInsensitiveLJPruningTransformer computeNewTransformer(ImmutableSet<Variable> newVariablesUsedByAncestors) {
            return new CardinalityInsensitiveLJPruningTransformer(this.lookForDistinctTransformer, this.coreSingletons, newVariablesUsedByAncestors);
        }
    }
}

