/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.optimizer.impl.lj;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import it.unibz.inf.ontop.dbschema.ForeignKeyConstraint;
import it.unibz.inf.ontop.dbschema.FunctionalDependency;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.dbschema.UniqueConstraint;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.BinaryNonCommutativeIQTree;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.NaryIQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.node.BinaryNonCommutativeOperatorNode;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.LeftJoinNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.iq.node.impl.JoinOrFilterVariableNullabilityTools;
import it.unibz.inf.ontop.iq.node.normalization.impl.RightProvenanceNormalizer;
import it.unibz.inf.ontop.iq.optimizer.impl.lj.AbstractLJTransformer;
import it.unibz.inf.ontop.iq.optimizer.impl.lj.RequiredExtensionalDataNodeExtractor;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.transform.impl.DefaultRecursiveIQTreeVisitingTransformer;
import it.unibz.inf.ontop.model.term.GroundTerm;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.substitution.ArgumentSubstitution;
import it.unibz.inf.ontop.substitution.InjectiveSubstitution;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public abstract class AbstractJoinTransferLJTransformer
extends AbstractLJTransformer {
    protected final RequiredExtensionalDataNodeExtractor requiredDataNodeExtractor;

    protected AbstractJoinTransferLJTransformer(Supplier<VariableNullability> variableNullabilitySupplier, VariableGenerator variableGenerator, RequiredExtensionalDataNodeExtractor requiredDataNodeExtractor, RightProvenanceNormalizer rightProvenanceNormalizer, JoinOrFilterVariableNullabilityTools variableNullabilityTools, CoreSingletons coreSingletons) {
        super(variableNullabilitySupplier, variableGenerator, rightProvenanceNormalizer, variableNullabilityTools, coreSingletons);
        this.requiredDataNodeExtractor = requiredDataNodeExtractor;
    }

    @Override
    protected Optional<IQTree> furtherTransformLeftJoin(LeftJoinNode rootNode, IQTree leftChild, IQTree rightChild) {
        ImmutableSet leftDataNodes = (ImmutableSet)this.requiredDataNodeExtractor.extractSomeRequiredNodes(leftChild, true).collect(ImmutableCollectors.toSet());
        if (leftDataNodes.isEmpty()) {
            return Optional.empty();
        }
        ImmutableSet<ExtensionalDataNode> rightDataNodes = this.extractRightUniqueDataNodes(rightChild);
        if (rightDataNodes.isEmpty()) {
            return Optional.empty();
        }
        ImmutableSet<SelectedNode> selectedRightDataNodes = this.selectRightDataNodesToTransfer((ImmutableSet<ExtensionalDataNode>)leftDataNodes, rightDataNodes);
        if (selectedRightDataNodes.isEmpty()) {
            return Optional.empty();
        }
        Optional<IQTree> rightChildWithConstructionNodeMovedAside = this.moveTopConstructionNodeAside(rightChild);
        return rightChildWithConstructionNodeMovedAside.map(newRightChild -> this.transfer(rootNode, leftChild, (IQTree)newRightChild, selectedRightDataNodes, (ImmutableSet<Variable>)rightChild.getVariables()).normalizeForOptimization(this.variableGenerator));
    }

    protected ImmutableSet<SelectedNode> selectRightDataNodesToTransfer(ImmutableSet<ExtensionalDataNode> leftDataNodes, ImmutableSet<ExtensionalDataNode> rightDataNodes) {
        ImmutableMultimap leftDataNodeMultimap = (ImmutableMultimap)leftDataNodes.stream().collect(ImmutableCollectors.toMultimap(ExtensionalDataNode::getRelationDefinition, n -> n));
        return (ImmutableSet)rightDataNodes.stream().map(r -> this.selectForTransfer((ExtensionalDataNode)r, (ImmutableMultimap<RelationDefinition, ExtensionalDataNode>)leftDataNodeMultimap)).flatMap(Optional::stream).collect(ImmutableCollectors.toSet());
    }

    protected abstract Optional<SelectedNode> selectForTransfer(ExtensionalDataNode var1, ImmutableMultimap<RelationDefinition, ExtensionalDataNode> var2);

    private ImmutableSet<ExtensionalDataNode> extractRightUniqueDataNodes(IQTree rightChild) {
        ImmutableMultiset multiset = (ImmutableMultiset)this.extractRightDataNodes(rightChild).collect(ImmutableCollectors.toMultiset());
        return (ImmutableSet)multiset.entrySet().stream().filter(e -> e.getCount() == 1).map(Multiset.Entry::getElement).collect(ImmutableCollectors.toSet());
    }

    protected Optional<ImmutableList<Integer>> matchUniqueConstraint(UniqueConstraint uniqueConstraint, ImmutableSet<ExtensionalDataNode> sameRelationLeftNodes, ImmutableMap<Integer, ? extends VariableOrGroundTerm> rightArgumentMap) {
        ImmutableList indexes = (ImmutableList)uniqueConstraint.getDeterminants().stream().map(a -> a.getIndex() - 1).collect(ImmutableCollectors.toList());
        if (!rightArgumentMap.keySet().containsAll((Collection)indexes)) {
            return Optional.empty();
        }
        return this.matchIndexes(sameRelationLeftNodes, rightArgumentMap, (ImmutableList<Integer>)indexes);
    }

    protected Optional<ImmutableList<Integer>> matchForeignKey(ForeignKeyConstraint fk, ImmutableCollection<ExtensionalDataNode> leftNodes, ImmutableMap<Integer, ? extends VariableOrGroundTerm> rightArgumentMap) {
        ImmutableList leftIndexes = (ImmutableList)fk.getComponents().stream().map(c -> c.getAttribute().getIndex() - 1).collect(ImmutableCollectors.toList());
        ImmutableList rightIndexes = (ImmutableList)fk.getComponents().stream().map(c -> c.getReferencedAttribute().getIndex() - 1).collect(ImmutableCollectors.toList());
        return leftNodes.stream().map(ExtensionalDataNode::getArgumentMap).filter(lMap -> IntStream.range(0, leftIndexes.size()).allMatch(i -> Optional.ofNullable((VariableOrGroundTerm)lMap.get(leftIndexes.get(i))).filter(t -> !(t instanceof Variable) || !this.getInheritedVariableNullability().isPossiblyNullable((Variable)t)).filter(l -> Optional.ofNullable((VariableOrGroundTerm)rightArgumentMap.get(rightIndexes.get(i))).filter(l::equals).isPresent()).isPresent())).findAny().map(l -> rightIndexes);
    }

    protected Optional<ImmutableList<Integer>> matchFunctionalDependency(FunctionalDependency functionalDependency, ImmutableSet<ExtensionalDataNode> sameRelationLeftNodes, ImmutableMap<Integer, ? extends VariableOrGroundTerm> rightArgumentMap) {
        ImmutableSet determinantIndexes = (ImmutableSet)functionalDependency.getDeterminants().stream().map(a -> a.getIndex() - 1).collect(ImmutableCollectors.toSet());
        if (!rightArgumentMap.keySet().containsAll((Collection)determinantIndexes)) {
            return Optional.empty();
        }
        ImmutableSet dependentIndexes = (ImmutableSet)functionalDependency.getDependents().stream().map(a -> a.getIndex() - 1).collect(ImmutableCollectors.toSet());
        ImmutableList indexes = (ImmutableList)rightArgumentMap.keySet().stream().filter(i -> !dependentIndexes.contains(i)).collect(ImmutableCollectors.toList());
        return this.matchIndexes(sameRelationLeftNodes, rightArgumentMap, (ImmutableList<Integer>)indexes);
    }

    protected Optional<ImmutableList<Integer>> matchIndexes(ImmutableSet<ExtensionalDataNode> sameRelationLeftNodes, ImmutableMap<Integer, ? extends VariableOrGroundTerm> rightArgumentMap, ImmutableList<Integer> indexes) {
        VariableNullability variableNullability = this.getInheritedVariableNullability();
        if (indexes.stream().anyMatch(i -> Optional.of((VariableOrGroundTerm)rightArgumentMap.get(i)).filter(t -> t instanceof Variable && variableNullability.isPossiblyNullable((Variable)t)).isPresent())) {
            return Optional.empty();
        }
        return sameRelationLeftNodes.stream().map(ExtensionalDataNode::getArgumentMap).filter(leftArgumentMap -> leftArgumentMap.keySet().containsAll((Collection)indexes) && indexes.stream().allMatch(i -> ((VariableOrGroundTerm)leftArgumentMap.get(i)).equals(rightArgumentMap.get(i)))).findAny().map(n -> indexes);
    }

    protected Stream<ExtensionalDataNode> extractRightDataNodes(IQTree rightChild) {
        return this.requiredDataNodeExtractor.extractSomeRequiredNodes(rightChild, false);
    }

    private Optional<IQTree> moveTopConstructionNodeAside(IQTree rightTree) {
        QueryNode rootNode = rightTree.getRootNode();
        if (rootNode instanceof ConstructionNode) {
            Substitution substitution = ((ConstructionNode)rootNode).getSubstitution();
            if (substitution.rangeAllMatch(ImmutableTerm::isGround)) {
                ConstructionNode newConstructionNode = this.iqFactory.createConstructionNode(substitution.getDomain(), substitution);
                IQTree initialChild = ((UnaryIQTree)rightTree).getChild();
                NaryIQTree newTree = this.iqFactory.createNaryIQTree((NaryOperatorNode)this.iqFactory.createInnerJoinNode(), ImmutableList.of((Object)initialChild, (Object)this.iqFactory.createUnaryIQTree((UnaryOperatorNode)newConstructionNode, (IQTree)this.iqFactory.createTrueNode())));
                return Optional.of(newTree);
            }
            return Optional.empty();
        }
        return Optional.of(rightTree);
    }

    private IQTree transfer(LeftJoinNode rootNode, IQTree leftChild, IQTree transformedRightChild, ImmutableSet<SelectedNode> selectedNodes, ImmutableSet<Variable> initialRightVariables) {
        if (selectedNodes.isEmpty()) {
            throw new IllegalArgumentException("selectedNodes must not be empty");
        }
        ImmutableList nodesToTransferAndReplacements = (ImmutableList)selectedNodes.stream().map(n -> n.transformForTransfer(this.variableGenerator)).collect(ImmutableCollectors.toList());
        NaryIQTree newLeftChild = this.iqFactory.createNaryIQTree((NaryOperatorNode)this.iqFactory.createInnerJoinNode(), (ImmutableList)Stream.concat(Stream.of(leftChild), nodesToTransferAndReplacements.stream().map(n -> n.getExtensionalDataNode(this.iqFactory))).collect(ImmutableCollectors.toList()));
        Substitution replacementSubstitution = nodesToTransferAndReplacements.stream().map(n -> n.getSubstitution(this.substitutionFactory)).reduce(this.substitutionFactory.getSubstitution(), (arg_0, arg_1) -> ((SubstitutionFactory)this.substitutionFactory).union(arg_0, arg_1));
        InjectiveSubstitution<Variable> renamingSubstitution = this.extractRenamingSubstitution((Substitution<VariableOrGroundTerm>)replacementSubstitution, (ImmutableSet<Variable>)leftChild.getVariables());
        ImmutableSet<ImmutableExpression> equalities = this.extractEqualities((Substitution<VariableOrGroundTerm>)replacementSubstitution, (ImmutableSet<Variable>)leftChild.getVariables());
        Optional newLeftJoinCondition = this.termFactory.getConjunction(rootNode.getOptionalFilterCondition().map(arg_0 -> renamingSubstitution.apply(arg_0)), equalities.stream());
        IQTree simplifiedRightChild = this.replaceSelectedNodesAndRename(selectedNodes, transformedRightChild, renamingSubstitution);
        RightProvenanceNormalizer.RightProvenance rightProvenance = this.rightProvenanceNormalizer.normalizeRightProvenance(simplifiedRightChild, newLeftChild.getVariables(), newLeftJoinCondition, this.variableGenerator);
        BinaryNonCommutativeIQTree newLeftJoinTree = this.iqFactory.createBinaryNonCommutativeIQTree((BinaryNonCommutativeOperatorNode)this.iqFactory.createLeftJoinNode(newLeftJoinCondition), (IQTree)newLeftChild, rightProvenance.getRightTree());
        Variable provenanceVariable = rightProvenance.getProvenanceVariable();
        ImmutableSet projectedVariables = Sets.union((Set)leftChild.getVariables(), initialRightVariables).immutableCopy();
        ImmutableExpression condition = this.termFactory.getDBIsNotNull((ImmutableTerm)provenanceVariable);
        Substitution substitution = ((InjectiveSubstitution.Builder)renamingSubstitution.builder().restrictDomainTo((Set)projectedVariables)).transform(t -> this.termFactory.getIfElseNull(condition, (ImmutableTerm)t)).build();
        ConstructionNode constructionNode = this.iqFactory.createConstructionNode(projectedVariables, substitution);
        return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)constructionNode, (IQTree)newLeftJoinTree);
    }

    private InjectiveSubstitution<Variable> extractRenamingSubstitution(Substitution<VariableOrGroundTerm> replacementSub, ImmutableSet<Variable> leftVariables) {
        return this.substitutionFactory.extractAnInjectiveVar2VarSubstitutionFromInverseOf(replacementSub.builder().restrictRangeTo(Variable.class).restrictRange(t -> !leftVariables.contains(t)).build());
    }

    private ImmutableSet<ImmutableExpression> extractEqualities(Substitution<VariableOrGroundTerm> replacementSub, ImmutableSet<Variable> leftVariables) {
        ImmutableMap replacement = replacementSub.inverseMap();
        Stream<ImmutableExpression> newVarEqualities = replacement.values().stream().filter(variables -> variables.size() > 1).map(variables -> this.termFactory.getStrictEquality(ImmutableList.copyOf((Collection)variables)));
        Stream<ImmutableExpression> equalitiesWithLeftVariable = replacement.entrySet().stream().filter(e -> e.getKey() instanceof Variable).filter(e -> leftVariables.contains(e.getKey())).map(e -> this.termFactory.getStrictEquality((ImmutableTerm)e.getKey(), (ImmutableTerm)((Collection)e.getValue()).iterator().next(), new ImmutableTerm[0]));
        Stream<ImmutableExpression> groundTermEqualities = replacement.entrySet().stream().filter(e -> e.getKey() instanceof GroundTerm).map(e -> this.termFactory.getStrictEquality((ImmutableTerm)e.getKey(), (ImmutableTerm)((Collection)e.getValue()).iterator().next(), new ImmutableTerm[0]));
        return (ImmutableSet)Stream.concat(Stream.concat(newVarEqualities, equalitiesWithLeftVariable), groundTermEqualities).collect(ImmutableCollectors.toSet());
    }

    private IQTree replaceSelectedNodesAndRename(ImmutableSet<SelectedNode> selectedNodes, IQTree rightChild, InjectiveSubstitution<Variable> renamingSubstitution) {
        ReplaceNodeByTrueTransformer transformer = new ReplaceNodeByTrueTransformer((ImmutableSet<ExtensionalDataNode>)((ImmutableSet)selectedNodes.stream().map(n -> n.extensionalDataNode).collect(ImmutableCollectors.toSet())), this.iqFactory);
        return rightChild.acceptTransformer((IQTreeVisitingTransformer)transformer).applyFreshRenaming(renamingSubstitution);
    }

    protected static class ReplaceNodeByTrueTransformer
    extends DefaultRecursiveIQTreeVisitingTransformer {
        private final ImmutableSet<ExtensionalDataNode> dataNodesToReplace;

        protected ReplaceNodeByTrueTransformer(ImmutableSet<ExtensionalDataNode> dataNodesToReplace, IntermediateQueryFactory iqFactory) {
            super(iqFactory);
            this.dataNodesToReplace = dataNodesToReplace;
        }

        public IQTree transformExtensionalData(ExtensionalDataNode dataNode) {
            return this.dataNodesToReplace.contains((Object)dataNode) ? this.iqFactory.createTrueNode() : dataNode;
        }
    }

    protected static class DataNodeAndReplacement {
        private final ExtensionalDataNode extensionalDataNode;
        private final ArgumentSubstitution<VariableOrGroundTerm> replacement;

        public DataNodeAndReplacement(ExtensionalDataNode extensionalDataNode, ArgumentSubstitution<VariableOrGroundTerm> replacement) {
            this.extensionalDataNode = extensionalDataNode;
            this.replacement = replacement;
        }

        public Substitution<VariableOrGroundTerm> getSubstitution(SubstitutionFactory substitutionFactory) {
            return this.replacement.getSubstitution(substitutionFactory, this.extensionalDataNode.getArgumentMap());
        }

        public ExtensionalDataNode getExtensionalDataNode(IntermediateQueryFactory iqFactory) {
            return iqFactory.createExtensionalDataNode(this.extensionalDataNode.getRelationDefinition(), this.replacement.replaceTerms(this.extensionalDataNode.getArgumentMap()));
        }
    }

    protected static class SelectedNode {
        public final ImmutableList<Integer> determinantIndexes;
        public final ExtensionalDataNode extensionalDataNode;

        public SelectedNode(ImmutableList<Integer> determinantIndexes, ExtensionalDataNode extensionalDataNode) {
            this.determinantIndexes = determinantIndexes;
            this.extensionalDataNode = extensionalDataNode;
        }

        public DataNodeAndReplacement transformForTransfer(VariableGenerator variableGenerator) {
            ImmutableMap replacement = (ImmutableMap)this.extensionalDataNode.getArgumentMap().entrySet().stream().filter(e -> !this.determinantIndexes.contains(e.getKey())).collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> this.generateFreshVariable((VariableOrGroundTerm)e.getValue(), variableGenerator)));
            return new DataNodeAndReplacement(this.extensionalDataNode, (ArgumentSubstitution<VariableOrGroundTerm>)new ArgumentSubstitution(replacement, Optional::ofNullable));
        }

        Variable generateFreshVariable(VariableOrGroundTerm term, VariableGenerator variableGenerator) {
            return Optional.of(term).filter(t -> t instanceof Variable).map(v -> (Variable)v).map(Variable::getName).map(arg_0 -> ((VariableGenerator)variableGenerator).generateNewVariable(arg_0)).orElseGet(() -> ((VariableGenerator)variableGenerator).generateNewVariable());
        }
    }
}

