/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.optimizer.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.injection.OptimizationSingletons;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.DistinctNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.SliceNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.optimizer.PreventDistinctOptimizer;
import it.unibz.inf.ontop.iq.optimizer.splitter.PreventDistinctProjectionSplitter;
import it.unibz.inf.ontop.iq.optimizer.splitter.ProjectionSplitter;
import it.unibz.inf.ontop.iq.request.FunctionalDependencies;
import it.unibz.inf.ontop.iq.transform.IQTreeTransformer;
import it.unibz.inf.ontop.iq.transform.impl.DefaultRecursiveIQTreeVisitingTransformer;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;

public class PreventDistinctOptimizerImpl
implements PreventDistinctOptimizer {
    private final IntermediateQueryFactory iqFactory;
    private final OptimizationSingletons optimizationSingletons;
    private final PreventDistinctProjectionSplitter preventDistinctProjectionSplitter;

    @Inject
    private PreventDistinctOptimizerImpl(IntermediateQueryFactory iqFactory, OptimizationSingletons optimizationSingletons, PreventDistinctProjectionSplitter preventDistinctProjectionSplitter) {
        this.iqFactory = iqFactory;
        this.optimizationSingletons = optimizationSingletons;
        this.preventDistinctProjectionSplitter = preventDistinctProjectionSplitter;
    }

    @Override
    public IQ optimize(IQ query) {
        VariableGenerator variableGenerator = query.getVariableGenerator();
        IQTreeTransformer transformer = this.createTransformer(variableGenerator);
        IQTree newTree = transformer.transform(query.getTree());
        if (newTree.equals(query.getTree())) {
            return query;
        }
        return this.iqFactory.createIQ(query.getProjectionAtom(), newTree);
    }

    protected IQTreeTransformer createTransformer(VariableGenerator variableGenerator) {
        return new PreventDistinctTransformer(variableGenerator, this.optimizationSingletons, this.preventDistinctProjectionSplitter);
    }

    protected static class Decomposition {
        final Optional<SliceNode> sliceNode;
        final Optional<DistinctNode> distinctNode;
        final IQTree descendantTree;

        private Decomposition(Optional<SliceNode> sliceNode, Optional<DistinctNode> distinctNode, IQTree descendantTree) {
            this.sliceNode = sliceNode;
            this.distinctNode = distinctNode;
            this.descendantTree = descendantTree;
        }

        static Decomposition decomposeTree(IQTree tree) {
            QueryNode rootNode = tree.getRootNode();
            Optional<SliceNode> sliceNode = Optional.of(rootNode).filter(n -> n instanceof SliceNode).map(n -> (SliceNode)n);
            IQTree firstNonSliceTree = sliceNode.map(n -> ((UnaryIQTree)tree).getChild()).orElse(tree);
            Optional<DistinctNode> distinctNode = Optional.of(firstNonSliceTree).map(IQTree::getRootNode).filter(n -> n instanceof DistinctNode).map(n -> (DistinctNode)n);
            IQTree descendantTree = distinctNode.map(n -> ((UnaryIQTree)firstNonSliceTree).getChild()).orElse(firstNonSliceTree);
            return new Decomposition(sliceNode, distinctNode, descendantTree);
        }
    }

    private static class PreventDistinctTransformer
    extends DefaultRecursiveIQTreeVisitingTransformer {
        private final VariableGenerator variableGenerator;
        private final PreventDistinctProjectionSplitter preventDistinctProjectionSplitter;

        public PreventDistinctTransformer(VariableGenerator variableGenerator, OptimizationSingletons optimizationSingletons, PreventDistinctProjectionSplitter preventDistinctProjectionSplitter) {
            super(optimizationSingletons.getCoreSingletons());
            this.variableGenerator = variableGenerator;
            this.preventDistinctProjectionSplitter = preventDistinctProjectionSplitter;
        }

        public IQTree transformConstruction(IQTree tree, ConstructionNode rootNode, IQTree child) {
            Decomposition decomposition = Decomposition.decomposeTree(child);
            if (decomposition.distinctNode.isPresent()) {
                ProjectionSplitter.ProjectionSplit split = this.preventDistinctProjectionSplitter.split(tree, this.variableGenerator);
                UnaryIQTree newTree = this.iqFactory.createUnaryIQTree((UnaryOperatorNode)split.getConstructionNode(), split.getSubTree());
                if (newTree.equals(tree)) {
                    return tree;
                }
                if (!this.validatePushedVariables(split.getPushedVariables(), (ImmutableSet<Variable>)Sets.difference((Set)rootNode.getChildVariables(), split.getPushedVariables()).immutableCopy(), decomposition.descendantTree)) {
                    throw new MinorOntopInternalBugException("Unable to push down substitution terms that are not supported with DISTINCT without a functional dependency.");
                }
                if (!this.validatePushedTerms(split.getPushedTerms())) {
                    throw new MinorOntopInternalBugException("Unable to push down substitution terms that are not supported with DISTINCT if the functional terms are not deterministic.");
                }
                return newTree;
            }
            return super.transformConstruction(tree, rootNode, child);
        }

        private boolean validatePushedVariables(ImmutableSet<Variable> pushedVariables, ImmutableSet<Variable> keptVariables, IQTree child) {
            FunctionalDependencies functionalDependencies = child.inferFunctionalDependencies();
            return pushedVariables.stream().allMatch(v -> functionalDependencies.getDeterminantsOf(v).stream().anyMatch(determinants -> keptVariables.containsAll((Collection)determinants) && Sets.intersection((Set)determinants, (Set)pushedVariables).isEmpty()));
        }

        private boolean validatePushedTerms(ImmutableSet<ImmutableTerm> pushedTerms) {
            return pushedTerms.stream().filter(term -> term instanceof ImmutableFunctionalTerm).map(term -> (ImmutableFunctionalTerm)term).allMatch(this::isDeterministic);
        }

        private boolean isDeterministic(ImmutableTerm term) {
            if (!(term instanceof ImmutableFunctionalTerm)) {
                return true;
            }
            ImmutableFunctionalTerm f = (ImmutableFunctionalTerm)term;
            if (!f.getFunctionSymbol().isDeterministic()) {
                return false;
            }
            return f.getTerms().stream().allMatch(this::isDeterministic);
        }
    }
}

