/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.optimizer.impl;

import it.unibz.inf.ontop.evaluator.QueryContext;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.lens.LensUnfolder;
import it.unibz.inf.ontop.iq.optimizer.AggregationSimplifier;
import it.unibz.inf.ontop.iq.optimizer.AggregationSplitter;
import it.unibz.inf.ontop.iq.optimizer.AllQueryContextFunctionSymbolEvaluator;
import it.unibz.inf.ontop.iq.optimizer.AuthorizationFunctionEvaluator;
import it.unibz.inf.ontop.iq.optimizer.DisjunctionOfEqualitiesMergingSimplifier;
import it.unibz.inf.ontop.iq.optimizer.FlattenLifter;
import it.unibz.inf.ontop.iq.optimizer.GeneralStructuralAndSemanticIQOptimizer;
import it.unibz.inf.ontop.iq.optimizer.JoinLikeOptimizer;
import it.unibz.inf.ontop.iq.optimizer.OrderBySimplifier;
import it.unibz.inf.ontop.iq.optimizer.PreventDistinctOptimizer;
import it.unibz.inf.ontop.iq.optimizer.UnionAndBindingLiftOptimizer;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GeneralStructuralAndSemanticIQOptimizerImpl
implements GeneralStructuralAndSemanticIQOptimizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeneralStructuralAndSemanticIQOptimizerImpl.class);
    private final UnionAndBindingLiftOptimizer bindingLiftOptimizer;
    private final JoinLikeOptimizer joinLikeOptimizer;
    private final OrderBySimplifier orderBySimplifier;
    private final AggregationSimplifier aggregationSimplifier;
    private final LensUnfolder lensUnfolder;
    private final AggregationSplitter aggregationSplitter;
    private final FlattenLifter flattenLifter;
    private final PreventDistinctOptimizer preventDistinctOptimizer;
    private final DisjunctionOfEqualitiesMergingSimplifier disjunctionOfEqualitiesMergingSimplifier;
    private final AuthorizationFunctionEvaluator authorizationFunctionEvaluator;
    private final AllQueryContextFunctionSymbolEvaluator allQueryContextFunctionSymbolEvaluator;

    @Inject
    private GeneralStructuralAndSemanticIQOptimizerImpl(UnionAndBindingLiftOptimizer bindingLiftOptimizer, JoinLikeOptimizer joinLikeOptimizer, OrderBySimplifier orderBySimplifier, AggregationSimplifier aggregationSimplifier, LensUnfolder lensUnfolder, AggregationSplitter aggregationSplitter, FlattenLifter flattenLifter, PreventDistinctOptimizer preventDistinctOptimizer, DisjunctionOfEqualitiesMergingSimplifier disjunctionOfEqualitiesMergingSimplifier, AuthorizationFunctionEvaluator authorizationFunctionEvaluator, AllQueryContextFunctionSymbolEvaluator allQueryContextFunctionSymbolEvaluator) {
        this.bindingLiftOptimizer = bindingLiftOptimizer;
        this.joinLikeOptimizer = joinLikeOptimizer;
        this.orderBySimplifier = orderBySimplifier;
        this.aggregationSimplifier = aggregationSimplifier;
        this.lensUnfolder = lensUnfolder;
        this.aggregationSplitter = aggregationSplitter;
        this.flattenLifter = flattenLifter;
        this.preventDistinctOptimizer = preventDistinctOptimizer;
        this.disjunctionOfEqualitiesMergingSimplifier = disjunctionOfEqualitiesMergingSimplifier;
        this.authorizationFunctionEvaluator = authorizationFunctionEvaluator;
        this.allQueryContextFunctionSymbolEvaluator = allQueryContextFunctionSymbolEvaluator;
    }

    @Override
    public IQ optimize(IQ query) {
        return this.optimize(query, null);
    }

    @Override
    public IQ optimize(IQ query, @Nullable QueryContext queryContext) {
        IQ queryAfterContextualSimplification;
        IQ liftedQuery = this.bindingLiftOptimizer.optimize(query);
        LOGGER.debug("New lifted query:\n{}\n", (Object)liftedQuery);
        IQ pushedIntoDistinct = this.preventDistinctOptimizer.optimize(liftedQuery);
        LOGGER.debug("Query tree after preventing DISTINCT for non-supported data types:\n{}\n", (Object)pushedIntoDistinct);
        IQ current = pushedIntoDistinct;
        while (true) {
            long beginningAuthorizationEvaluation = System.currentTimeMillis();
            if (queryContext != null) {
                current = this.authorizationFunctionEvaluator.optimize(current, queryContext);
                LOGGER.debug("New query after evaluation authorization functions ({} ms):\n{}\n", (Object)(System.currentTimeMillis() - beginningAuthorizationEvaluation), (Object)current);
            }
            long beginningJoinLike = System.currentTimeMillis();
            current = this.joinLikeOptimizer.optimize(current);
            LOGGER.debug("New query after fixed point join optimization ({} ms):\n{}\n", (Object)(System.currentTimeMillis() - beginningJoinLike), (Object)current);
            IQ queryBeforeUnfolding = current;
            current = this.lensUnfolder.optimize(queryBeforeUnfolding);
            LOGGER.debug("New query after view unfolding:\n{}\n", (Object)current);
            if (queryBeforeUnfolding.equals(current)) break;
            current = this.flattenLifter.optimize(current);
            LOGGER.debug("New query after flatten lift:\n{}\n", (Object)current);
        }
        IQ iQ = queryAfterContextualSimplification = queryContext == null ? current : this.allQueryContextFunctionSymbolEvaluator.optimize(current, queryContext);
        if (queryContext != null) {
            LOGGER.debug("New query after simplifying using the context:\n{}\n", (Object)queryAfterContextualSimplification);
        }
        IQ queryAfterAggregationSimplification = this.aggregationSimplifier.optimize(queryAfterContextualSimplification);
        LOGGER.debug("New query after simplifying the aggregation node:\n{}\n", (Object)queryAfterAggregationSimplification);
        IQ queryAfterAggregationSplitting = this.aggregationSplitter.optimize(queryAfterAggregationSimplification);
        LOGGER.debug("New query after trying to split the aggregation node:\n{}\n", (Object)queryAfterAggregationSplitting);
        IQ optimizedQuery = this.orderBySimplifier.optimize(queryAfterAggregationSplitting);
        LOGGER.debug("New query after simplifying the order by node:\n{}\n", (Object)optimizedQuery);
        IQ mergedDisjunctionsQuery = this.disjunctionOfEqualitiesMergingSimplifier.optimize(optimizedQuery);
        LOGGER.debug("New query after simplifying disjunctions of equalities:\n{}\n", (Object)mergedDisjunctionsQuery);
        IQ resultingQuery = this.preventDistinctOptimizer.optimize(mergedDisjunctionsQuery);
        LOGGER.debug("Query tree after preventing DISTINCT for non-supported data types, second pass:\n{}\n", (Object)resultingQuery);
        return resultingQuery;
    }
}

