/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.optimizer.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.optimizer.InnerJoinIQOptimizer;
import it.unibz.inf.ontop.iq.optimizer.JoinLikeOptimizer;
import it.unibz.inf.ontop.iq.optimizer.LeftJoinIQOptimizer;

@Singleton
public class FixedPointJoinLikeOptimizer
implements JoinLikeOptimizer {
    private static final int MAX_LOOP = 100;
    private final InnerJoinIQOptimizer innerJoinIQOptimizer;
    private final LeftJoinIQOptimizer leftJoinIQOptimizer;

    @Inject
    private FixedPointJoinLikeOptimizer(InnerJoinIQOptimizer innerJoinIQOptimizer, LeftJoinIQOptimizer leftJoinIQOptimizer) {
        this.innerJoinIQOptimizer = innerJoinIQOptimizer;
        this.leftJoinIQOptimizer = leftJoinIQOptimizer;
    }

    @Override
    public IQ optimize(IQ initialIQ) {
        IQ currentIQ = initialIQ;
        for (int i = 0; i < 100; ++i) {
            IQ innerJoinOptimizedIQ = this.innerJoinIQOptimizer.optimize(currentIQ);
            IQ leftJoinOptimizedIQ = this.leftJoinIQOptimizer.optimize(innerJoinOptimizedIQ);
            IQ optimizedIQ = leftJoinOptimizedIQ.normalizeForOptimization();
            if (optimizedIQ.equals(currentIQ)) {
                return optimizedIQ;
            }
            currentIQ = optimizedIQ;
        }
        throw new MinorOntopInternalBugException("MAX_LOOP reached");
    }
}

