/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.optimizer.impl;

import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.FilterNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.UnionNode;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.iq.optimizer.BelowDistinctJoinWithClassUnionOptimizer;
import it.unibz.inf.ontop.iq.optimizer.impl.AbstractBelowDistinctInnerJoinTransformer;
import it.unibz.inf.ontop.iq.optimizer.impl.LookForDistinctOrLimit1TransformerImpl;
import it.unibz.inf.ontop.iq.transform.IQTreeTransformer;
import it.unibz.inf.ontop.iq.visit.IQVisitor;
import it.unibz.inf.ontop.iq.visitor.RequiredExtensionalDataNodeExtractor;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;

public class BelowDistinctJoinWithClassUnionOptimizerImpl
implements BelowDistinctJoinWithClassUnionOptimizer {
    private final IQTreeTransformer lookForDistinctTransformer;
    private final IntermediateQueryFactory iqFactory;

    @Inject
    protected BelowDistinctJoinWithClassUnionOptimizerImpl(CoreSingletons coreSingletons, IntermediateQueryFactory iqFactory, RequiredExtensionalDataNodeExtractor requiredExtensionalDataNodeExtractor) {
        this.iqFactory = iqFactory;
        this.lookForDistinctTransformer = new LookForDistinctOrLimit1TransformerImpl(t -> new JoinWithClassUnionTransformer(t, coreSingletons, requiredExtensionalDataNodeExtractor), coreSingletons);
    }

    @Override
    public IQ optimize(IQ query) {
        IQTree initialTree = query.getTree();
        IQTree newTree = this.lookForDistinctTransformer.transform(initialTree);
        return newTree.equals(initialTree) ? query : this.iqFactory.createIQ(query.getProjectionAtom(), newTree).normalizeForOptimization();
    }

    protected static class JoinWithClassUnionTransformer
    extends AbstractBelowDistinctInnerJoinTransformer {
        private final RequiredExtensionalDataNodeExtractor requiredExtensionalDataNodeExtractor;

        protected JoinWithClassUnionTransformer(IQTreeTransformer lookForDistinctTransformer, CoreSingletons coreSingletons, RequiredExtensionalDataNodeExtractor requiredExtensionalDataNodeExtractor) {
            super(lookForDistinctTransformer, coreSingletons);
            this.requiredExtensionalDataNodeExtractor = requiredExtensionalDataNodeExtractor;
        }

        @Override
        protected boolean isDetectedAsRedundant(IQTree child, Stream<IQTree> otherChildrenStream) {
            ImmutableSet otherChildren = (ImmutableSet)otherChildrenStream.collect(ImmutableCollectors.toSet());
            return Stream.of(child).filter(c -> c.getRootNode() instanceof UnionNode).flatMap(c -> c.getChildren().stream()).flatMap(c -> Optional.of(c).flatMap(this::extractExtensionalNode).stream()).anyMatch(c -> otherChildren.stream().flatMap(t -> (Stream)t.acceptVisitor((IQVisitor)this.requiredExtensionalDataNodeExtractor)).anyMatch(o -> this.isDetectedAsRedundant((ExtensionalDataNode)c, (ExtensionalDataNode)o)));
        }

        private Optional<ExtensionalDataNode> extractExtensionalNode(IQTree unionChild) {
            QueryNode rootNode = unionChild.getRootNode();
            if (rootNode instanceof FilterNode) {
                VariableNullability variableNullability = this.coreSingletons.getCoreUtilsFactory().createEmptyVariableNullability(unionChild.getVariables());
                ImmutableExpression filterCondition = ((FilterNode)rootNode).getFilterCondition();
                return filterCondition.evaluate2VL(variableNullability).getValue().filter(b -> b.equals((Object)ImmutableExpression.Evaluation.BooleanValue.TRUE)).flatMap(b -> this.extractExtensionalNode((IQTree)unionChild.getChildren().get(0)));
            }
            if (rootNode instanceof ExtensionalDataNode) {
                return Optional.of((ExtensionalDataNode)rootNode);
            }
            return Optional.empty();
        }
    }
}

