/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.optimizer.impl;

import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.injection.QueryTransformerFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.IntensionalDataNode;
import it.unibz.inf.ontop.iq.optimizer.IQOptimizer;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.transform.impl.DefaultRecursiveIQTreeVisitingTransformer;
import it.unibz.inf.ontop.model.atom.AtomFactory;
import it.unibz.inf.ontop.model.atom.AtomPredicate;
import it.unibz.inf.ontop.model.atom.DataAtom;
import it.unibz.inf.ontop.model.atom.DistinctVariableOnlyDataAtom;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.substitution.InjectiveSubstitution;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Optional;

public abstract class AbstractIntensionalQueryMerger
implements IQOptimizer {
    protected final IntermediateQueryFactory iqFactory;

    protected AbstractIntensionalQueryMerger(IntermediateQueryFactory iqFactory) {
        this.iqFactory = iqFactory;
    }

    @Override
    public IQ optimize(IQ query) {
        IQTree newTree = this.optimize(query.getTree());
        return this.iqFactory.createIQ(query.getProjectionAtom(), newTree);
    }

    private IQTree optimize(IQTree tree) {
        QueryMergingTransformer transformer = this.createTransformer((ImmutableSet<Variable>)tree.getKnownVariables());
        return tree.acceptTransformer((IQTreeVisitingTransformer)transformer);
    }

    protected abstract QueryMergingTransformer createTransformer(ImmutableSet<Variable> var1);

    protected static abstract class QueryMergingTransformer
    extends DefaultRecursiveIQTreeVisitingTransformer {
        private final VariableGenerator variableGenerator;
        private final SubstitutionFactory substitutionFactory;
        private final QueryTransformerFactory transformerFactory;
        private final AtomFactory atomFactory;

        protected QueryMergingTransformer(VariableGenerator variableGenerator, IntermediateQueryFactory iqFactory, SubstitutionFactory substitutionFactory, AtomFactory atomFactory, QueryTransformerFactory transformerFactory) {
            super(iqFactory);
            this.variableGenerator = variableGenerator;
            this.substitutionFactory = substitutionFactory;
            this.transformerFactory = transformerFactory;
            this.atomFactory = atomFactory;
        }

        public final IQTree transformIntensionalData(IntensionalDataNode dataNode) {
            Optional<IQ> definition = this.getDefinition(dataNode);
            return definition.map(d -> this.replaceIntensionalData(dataNode, (IQ)d)).orElseGet(() -> this.handleIntensionalWithoutDefinition(dataNode));
        }

        protected abstract Optional<IQ> getDefinition(IntensionalDataNode var1);

        protected abstract IQTree handleIntensionalWithoutDefinition(IntensionalDataNode var1);

        private IQTree replaceIntensionalData(IntensionalDataNode dataNode, IQ definition) {
            InjectiveSubstitution renamingSubstitution = this.substitutionFactory.generateNotConflictingRenaming(this.variableGenerator, definition.getTree().getKnownVariables());
            IQ renamedIQ = this.transformerFactory.createRenamer(renamingSubstitution).transform(definition);
            Substitution<? extends VariableOrGroundTerm> descendingSubstitution = this.extractSubstitution(this.atomFactory.getDistinctVariableOnlyDataAtom(renamedIQ.getProjectionAtom().getPredicate(), this.substitutionFactory.apply((Substitution)renamingSubstitution, renamedIQ.getProjectionAtom().getArguments())), (DataAtom<AtomPredicate>)dataNode.getProjectionAtom());
            return renamedIQ.getTree().applyDescendingSubstitution(descendingSubstitution, Optional.empty(), this.variableGenerator).normalizeForOptimization(this.variableGenerator);
        }

        private Substitution<? extends VariableOrGroundTerm> extractSubstitution(DistinctVariableOnlyDataAtom sourceAtom, DataAtom<AtomPredicate> targetAtom) {
            if (!sourceAtom.getPredicate().equals(targetAtom.getPredicate())) {
                throw new IllegalStateException("Incompatible predicates");
            }
            return this.substitutionFactory.getSubstitution(sourceAtom.getArguments(), targetAtom.getArguments());
        }
    }
}

