/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.injection.impl;

import com.google.inject.Injector;
import com.google.inject.Module;
import it.unibz.inf.ontop.injection.OntopModelSettings;
import it.unibz.inf.ontop.injection.OntopOptimizationConfiguration;
import it.unibz.inf.ontop.injection.OntopOptimizationSettings;
import it.unibz.inf.ontop.injection.impl.OntopModelConfigurationImpl;
import it.unibz.inf.ontop.injection.impl.OntopOptimizationModule;
import it.unibz.inf.ontop.injection.impl.OntopOptimizationSettingsImpl;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class OntopOptimizationConfigurationImpl
extends OntopModelConfigurationImpl
implements OntopOptimizationConfiguration {
    protected OntopOptimizationConfigurationImpl(OntopOptimizationSettings settings, OntopOptimizationOptions options) {
        super((OntopModelSettings)settings, options.getModelOptions());
    }

    protected OntopOptimizationConfigurationImpl(OntopOptimizationSettings settings, OntopOptimizationOptions options, Supplier<Injector> injectorSupplier) {
        super((OntopModelSettings)settings, options.getModelOptions(), injectorSupplier);
    }

    @Override
    public OntopOptimizationSettings getSettings() {
        return (OntopOptimizationSettings)super.getSettings();
    }

    protected Stream<Module> buildGuiceModules() {
        return Stream.concat(super.buildGuiceModules(), Stream.of(new OntopOptimizationModule(this)));
    }

    public static final class BuilderImpl
    extends AbstractOntopOptimizationBuilderMixin<BuilderImpl> {
        @Override
        public OntopOptimizationConfiguration build() {
            Properties properties = this.generateProperties();
            OntopOptimizationOptions options = this.generateOntopOptimizationConfigurationOptions();
            OntopOptimizationSettingsImpl settings = new OntopOptimizationSettingsImpl(properties);
            return new OntopOptimizationConfigurationImpl(settings, options);
        }

        @Override
        protected BuilderImpl self() {
            return this;
        }
    }

    protected static abstract class AbstractOntopOptimizationBuilderMixin<B extends OntopOptimizationConfiguration.Builder<B>>
    implements OntopOptimizationConfiguration.Builder<B> {
        private final DefaultOntopOptimizationBuilderFragment<B> optimizationBuilderFragment = new DefaultOntopOptimizationBuilderFragment();
        private final OntopModelConfigurationImpl.DefaultOntopModelBuilderFragment<B> modelBuilderFragment = new OntopModelConfigurationImpl.DefaultOntopModelBuilderFragment<B>(){

            protected B self() {
                return this.self();
            }
        };

        protected AbstractOntopOptimizationBuilderMixin() {
        }

        protected abstract B self();

        protected Properties generateProperties() {
            Properties properties = this.modelBuilderFragment.generateProperties();
            properties.putAll((Map<?, ?>)this.optimizationBuilderFragment.generateProperties());
            return properties;
        }

        protected OntopOptimizationOptions generateOntopOptimizationConfigurationOptions() {
            OntopModelConfigurationImpl.OntopModelConfigurationOptions modelOptions = this.modelBuilderFragment.generateModelOptions();
            return this.optimizationBuilderFragment.generateOptimizationOptions(modelOptions);
        }

        public B properties(@Nonnull Properties properties) {
            return (B)((OntopOptimizationConfiguration.Builder)this.modelBuilderFragment.properties(properties));
        }

        public B propertyFile(File propertyFile) {
            return (B)((OntopOptimizationConfiguration.Builder)this.modelBuilderFragment.propertyFile(propertyFile));
        }

        public B propertyFile(String propertyFilePath) {
            return (B)((OntopOptimizationConfiguration.Builder)this.modelBuilderFragment.propertyFile(propertyFilePath));
        }

        public B enableTestMode() {
            return (B)((OntopOptimizationConfiguration.Builder)this.modelBuilderFragment.enableTestMode());
        }
    }

    protected static class DefaultOntopOptimizationBuilderFragment<B extends OntopOptimizationConfiguration.Builder<B>>
    implements OntopOptimizationConfiguration.OntopOptimizationBuilderFragment<B> {
        protected DefaultOntopOptimizationBuilderFragment() {
        }

        protected Properties generateProperties() {
            return new Properties();
        }

        protected final OntopOptimizationOptions generateOptimizationOptions(OntopModelConfigurationImpl.OntopModelConfigurationOptions modelOptions) {
            return new OntopOptimizationOptions(modelOptions);
        }
    }

    public static class OntopOptimizationOptions {
        private final OntopModelConfigurationImpl.OntopModelConfigurationOptions modelOptions;

        OntopOptimizationOptions(OntopModelConfigurationImpl.OntopModelConfigurationOptions modelOptions) {
            this.modelOptions = modelOptions;
        }

        public OntopModelConfigurationImpl.OntopModelConfigurationOptions getModelOptions() {
            return this.modelOptions;
        }
    }
}

