/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.datalog.impl;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import it.unibz.inf.ontop.datalog.UnionFlattener;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.node.UnionNode;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.transform.impl.DefaultRecursiveIQTreeVisitingTransformer;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.stream.Stream;

public class UnionFlattenerImpl
implements UnionFlattener {
    private final IntermediateQueryFactory iqFactory;

    @Inject
    private UnionFlattenerImpl(IntermediateQueryFactory iqFactory) {
        this.iqFactory = iqFactory;
    }

    @Override
    public IQ optimize(IQ query) {
        return this.iqFactory.createIQ(query.getProjectionAtom(), this.optimize(query.getTree(), query.getVariableGenerator()));
    }

    @Override
    public IQTree optimize(IQTree tree, VariableGenerator variableGenerator) {
        IQTree prev;
        TreeTransformer treeTransformer = new TreeTransformer(variableGenerator);
        while (!(prev = tree).equals(tree = tree.acceptTransformer((IQTreeVisitingTransformer)treeTransformer))) {
        }
        return prev;
    }

    private class TreeTransformer
    extends DefaultRecursiveIQTreeVisitingTransformer {
        private final VariableGenerator variableGenerator;

        private TreeTransformer(VariableGenerator variableGenerator) {
            super(UnionFlattenerImpl.this.iqFactory);
            this.variableGenerator = variableGenerator;
        }

        public IQTree transformConstruction(IQTree tree, ConstructionNode rootCn, IQTree child) {
            IQTree transformedChild = child.acceptTransformer((IQTreeVisitingTransformer)this);
            QueryNode transformedChildRoot = transformedChild.getRootNode();
            if (transformedChildRoot instanceof UnionNode) {
                return this.iqFactory.createNaryIQTree((NaryOperatorNode)this.iqFactory.createUnionNode(rootCn.getVariables()), (ImmutableList)transformedChild.getChildren().stream().map(t -> this.iqFactory.createUnaryIQTree((UnaryOperatorNode)rootCn, t)).collect(ImmutableCollectors.toList()));
            }
            if (transformedChildRoot instanceof ConstructionNode) {
                return rootCn.normalizeForOptimization(transformedChild, this.variableGenerator, this.iqFactory.createIQTreeCache());
            }
            return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)rootCn, transformedChild);
        }

        public IQTree transformUnion(IQTree tree, UnionNode rootNode, ImmutableList<IQTree> children) {
            ImmutableList transformedChildren = (ImmutableList)children.stream().map(t -> t.acceptTransformer((IQTreeVisitingTransformer)this)).collect(ImmutableCollectors.toList());
            ImmutableList unionGrandChildren = (ImmutableList)transformedChildren.stream().filter(t -> t.getRootNode() instanceof UnionNode).flatMap(t -> t.getChildren().stream()).collect(ImmutableCollectors.toList());
            return this.iqFactory.createNaryIQTree((NaryOperatorNode)rootNode, (ImmutableList)Stream.concat(transformedChildren.stream().filter(t -> !(t.getRootNode() instanceof UnionNode)), unionGrandChildren.stream()).collect(ImmutableCollectors.toList()));
        }
    }
}

