/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.mongodb;

import com.mongodb.client.AggregateIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.bson.conversions.Bson;

public class RequestCache {
    final int MAX_ITEMS = 100;
    static final float FACTOR = 0.75f;
    protected Map<Integer, AggregateIterable<Document>> aggregateCache = RequestCache.boundCache(100);
    protected Map<Integer, FindIterable<Document>> findCache = RequestCache.boundCache(100);

    public static <K, V> Map<K, V> boundCache(final int maxSize) {
        return new LinkedHashMap<K, V>((int)((float)maxSize / 0.75f), 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                return this.size() > maxSize;
            }
        };
    }

    AggregateIterable<Document> getAggregation(MongoCollection coll, String database, String collection, List<Document> aggregation) {
        return this.aggregateCache.computeIfAbsent(database.hashCode() ^ collection.hashCode() ^ aggregation.hashCode(), s -> coll.aggregate(aggregation));
    }

    FindIterable<Document> getFind(MongoCollection coll, String database, String collection, Document find) {
        return this.findCache.computeIfAbsent(database.hashCode() ^ collection.hashCode() ^ find.hashCode(), s -> coll.find((Bson)find));
    }
}

