/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.mongodb;

import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.document.JsonDocument;
import com.apicatalog.jsonld.loader.DocumentLoaderOptions;
import com.mongodb.MongoSecurityException;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.CollationAlternate;
import com.mongodb.client.model.CollationCaseFirst;
import com.mongodb.client.model.CollationMaxVariable;
import com.mongodb.client.model.CollationStrength;
import com.ontotext.rio.jsonld.GraphDBJSONLD11ParserFactory;
import com.ontotext.rio.jsonld.settings.GraphDBJSONLDSettings;
import com.ontotext.trree.plugin.mongodb.BatchDocumentStore;
import com.ontotext.trree.plugin.mongodb.CachingDocumentLoader;
import com.ontotext.trree.plugin.mongodb.EncoderWrapper;
import com.ontotext.trree.plugin.mongodb.MongoDBPlugin;
import com.ontotext.trree.plugin.mongodb.RequestCache;
import com.ontotext.trree.sdk.Entities;
import com.ontotext.trree.sdk.PluginException;
import com.ontotext.trree.sdk.StatementIterator;
import jakarta.json.JsonString;
import jakarta.json.JsonStructure;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.bson.Document;
import org.bson.codecs.DocumentCodec;
import org.bson.codecs.Encoder;
import org.bson.conversions.Bson;
import org.bson.json.JsonMode;
import org.bson.json.JsonWriterSettings;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.rio.ParseErrorListener;
import org.eclipse.rdf4j.rio.ParserConfig;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParserRegistry;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.UnsupportedRDFormatException;
import org.eclipse.rdf4j.rio.helpers.ParseErrorLogger;

public class MongoResultIterator
extends StatementIterator {
    private static final String CUSTOM_NODE = "custom";
    private String query;
    private String projection;
    private String hint;
    private String database;
    private String collection;
    private Collation collation;
    private List<Document> aggregation = null;
    protected long searchSubject;
    private long graphId;
    private long indexId;
    protected boolean initialized = false;
    protected boolean initializedByEntityIterator = false;
    private boolean searchDone = false;
    private MongoClient client;
    private MongoDatabase db;
    private MongoCollection<Document> coll;
    protected MongoCursor<Document> iter;
    protected Model currentRDF;
    protected Entities entities;
    private MongoDBPlugin plugin;
    private RequestCache cache;
    private final ParserConfig jsonLdParserConfig;
    private final CachingDocumentLoader documentLoader;
    private boolean contextFirst = false;
    private boolean cloned = false;
    private boolean entityIteratorCreated = false;
    private boolean modelIteratorCreated = false;
    protected boolean interrupted = false;
    private boolean closed = false;
    private boolean closeable = true;
    private boolean batched = false;
    private boolean batchedLoading = false;
    private int documentsLimit;
    private BatchDocumentStore batchDocumentStore;
    private LongIterator storeIterator;

    public MongoResultIterator(MongoDBPlugin plugin, MongoClient client, String database, String collection, RequestCache cache, long searchsubject) {
        this.cache = cache;
        this.plugin = plugin;
        this.client = client;
        this.database = database;
        this.collection = collection;
        this.searchSubject = searchsubject;
        this.jsonLdParserConfig = new ParserConfig();
        this.documentLoader = new CachingDocumentLoader();
        this.jsonLdParserConfig.set(GraphDBJSONLDSettings.DOCUMENT_LOADER, (Object)this.documentLoader);
    }

    public boolean next() {
        boolean ret = false;
        if (!this.initialized) {
            this.subject = this.searchSubject;
            ret = true;
            this.initialized = true;
        } else if (this.initializedByEntityIterator && !this.searchDone) {
            this.subject = this.searchSubject;
            this.searchDone = true;
            ret = true;
        }
        return ret;
    }

    protected boolean initialize() {
        if (this.query == null && this.aggregation == null) {
            throw new PluginException("There is no search query for Mongo. Please use either of the predicates: " + String.valueOf(Arrays.asList(MongoDBPlugin.QUERY.toString(), MongoDBPlugin.AGGREGATION.toString())));
        }
        try {
            if (this.client != null) {
                this.db = this.client.getDatabase(this.database);
                this.coll = this.db.getCollection(this.collection);
                if (this.aggregation != null) {
                    AggregateIterable<Document> res = this.cache.getAggregation(this.coll, this.database, this.collection, this.aggregation);
                    if (this.hint != null) {
                        res.hint((Bson)Document.parse((String)this.hint));
                    }
                    if (this.collation != null) {
                        res.collation(this.collation);
                    }
                    this.iter = res.iterator();
                } else {
                    FindIterable res = this.cache.getFind(this.coll, this.database, this.collection, Document.parse((String)this.query));
                    if (this.projection != null) {
                        res = res.projection((Bson)Document.parse((String)this.projection));
                    }
                    if (this.hint != null) {
                        res.hint((Bson)Document.parse((String)this.hint));
                    }
                    if (this.collation != null) {
                        res.collation(this.collation);
                    }
                    this.iter = res.iterator();
                }
                this.initialized = true;
            }
        }
        catch (MongoSecurityException ex) {
            this.plugin.getLogger().error("Could not connect to mongo", (Throwable)ex);
            throw new PluginException("Could not connect to MongoDB. Please make sure you are using correct authentication. " + ex.getMessage());
        }
        if (this.batched) {
            if (this.iter != null && this.iter.hasNext()) {
                this.batchDocumentStore = new BatchDocumentStore();
                this.loadBatchedData();
                this.storeIterator = this.batchDocumentStore.getIterator();
                this.currentRDF = this.batchDocumentStore.getData();
            }
            return this.batchDocumentStore.size() > 0;
        }
        return this.iter != null && this.iter.hasNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBatchedData() {
        Model[] data = new Model[1];
        this.batchedLoading = true;
        try {
            while (this.hasSolution() && this.batchDocumentStore.size() < this.getDocumentsLimit()) {
                long docId = this.readNextDocument(current -> {
                    data[0] = current;
                });
                if (docId == 0L) continue;
                this.batchDocumentStore.addDocument(docId, data[0]);
            }
        }
        finally {
            this.batchedLoading = false;
        }
    }

    public void close() {
        if (!this.closeable) {
            this.closeable = true;
            return;
        }
        this.closed = true;
        if (this.iter != null) {
            this.iter.close();
        }
        this.iter = null;
        this.coll = null;
        this.db = null;
        this.client = null;
        this.interrupted = true;
        if (this.currentRDF != null) {
            this.currentRDF.clear();
            this.currentRDF = null;
        }
        this.initialized = false;
        this.initializedByEntityIterator = false;
        IOUtils.closeQuietly((Closeable)((Closeable)this.jsonLdParserConfig.get(GraphDBJSONLDSettings.DOCUMENT_LOADER)));
        if (this.batchDocumentStore != null) {
            this.batchDocumentStore.clear();
            this.batchDocumentStore = null;
        }
    }

    public void setQuery(String query) {
        this.query = query;
        this.closeable &= query != null;
    }

    public StatementIterator singletonIterator(long predicate, long object) {
        return StatementIterator.create((long)this.getSearchSubject(), (long)predicate, (long)object, (long)0L);
    }

    public void setProjection(String projectionString) {
        this.projection = projectionString;
        this.closeable &= this.projection != null;
    }

    public StatementIterator createEntityIter(final long pred) {
        this.setEntityIteratorCreated(true);
        return new StatementIterator(){
            boolean initializedE = false;

            public boolean next() {
                if (!this.initializedE) {
                    MongoResultIterator.this.initialize();
                    this.initializedE = true;
                }
                if (MongoResultIterator.this.hasSolution()) {
                    this.subject = MongoResultIterator.this.searchSubject;
                    this.predicate = pred;
                    MongoResultIterator.this.advance();
                    this.object = MongoResultIterator.this.object;
                    return true;
                }
                return false;
            }

            public void close() {
            }
        };
    }

    protected void advance() {
        this.object = this.batched ? this.storeIterator.next() : this.readNextDocument(doc -> {
            this.currentRDF = doc;
        });
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected long readNextDocument(Consumer<Model> dataAccumulator) {
        doc = (Document)this.iter.next();
        if (this.interrupted) {
            return 0L;
        }
        entity = null;
        if (doc.containsKey((Object)"@graph") && (item = doc.get((Object)"@graph")) != null) {
            if (item instanceof List) {
                listItem = (List)item;
                if (!listItem.isEmpty() && (var9_6 = listItem.getFirst()) instanceof Document) {
                    graphDoc = document = (Document)var9_6;
                    entity = graphDoc.getString((Object)"@id");
                    if (listItem.size() > 1) {
                        this.plugin.getLogger().warn("Multiple graphs in mongo document. Selecting the first one for entity:\t" + entity);
                    }
                } else {
                    this.plugin.getLogger().warn("Value of @graph must be a valid document in mongo document.");
                }
            } else if (item instanceof Document) {
                graphDoc = document = (Document)item;
                entity = graphDoc.getString((Object)"@id");
            } else {
                this.plugin.getLogger().warn("@graph must be a document or list of documents in mongo document.");
            }
        }
        if (entity == null) {
            entity = doc.getString((Object)"@id");
        }
        docBase = null;
        if (doc.containsKey((Object)"@base")) {
            baseValue = doc.get((Object)"@base");
            if (baseValue instanceof String) {
                docBase = baseValue.toString();
            } else if (baseValue != null) {
                this.plugin.getLogger().warn("@base must be a string but got: {}", baseValue);
            }
        } else if (doc.containsKey((Object)"@context")) {
            ctxValue = doc.get((Object)"@context");
            docBase = this.resolveDocumentBase(ctxValue);
        }
        docBase = Objects.toString(docBase, "http://base.org");
        try {
            jsonWriterSettings = JsonWriterSettings.builder().outputMode(JsonMode.RELAXED).build();
            encoderWrapper = new EncoderWrapper((Encoder<Document>)new DocumentCodec());
            json = doc.toJson(jsonWriterSettings, (Encoder)encoderWrapper);
            reader = new StringReader(json);
            this.currentRDF = Rio.parse((Reader)reader, (String)docBase, (RDFFormat)RDFFormat.JSONLD, (ParserConfig)this.jsonLdParserConfig, (ValueFactory)SimpleValueFactory.getInstance(), (ParseErrorListener)new ParseErrorLogger(), (Resource[])new Resource[0]);
            v /* !! */  = null;
            if (entity != null) {
                try {
                    v /* !! */  = this.plugin.vf.createIRI(entity);
                }
                catch (IllegalArgumentException e) {
                    contextValue = doc.get((Object)"@context");
                    base = this.resolveDocumentBase(contextValue);
                    if (base != null) {
                        try {
                            v /* !! */  = this.plugin.vf.createIRI(base, entity);
                        }
                        catch (IllegalArgumentException var13_15) {}
                    } else {
                        it = this.currentRDF.getStatements(null, null, null, new Resource[0]).iterator();
                        v /* !! */  = it.hasNext() != false ? ((Statement)it.next()).getSubject() : this.plugin.vf.createBNode();
                    }
                    if (v /* !! */  != null) ** GOTO lbl61
                    throw e;
                }
            } else {
                v /* !! */  = this.plugin.vf.createBNode();
            }
lbl61:
            // 3 sources

            id = this.entities.resolve((Value)v /* !! */ );
            if (id == 0L) {
                id = this.entities.put((Value)v /* !! */ , Entities.Scope.REQUEST);
            }
            if ((customNode = doc.get((Object)"custom")) instanceof Document) {
                document = (Document)customNode;
                for (Map.Entry val : document.entrySet()) {
                    this.currentRDF.add((Resource)v /* !! */ , this.plugin.vf.createIRI("http://www.ontotext.com/connectors/mongodb/instance#", (String)val.getKey()), (Value)this.plugin.vf.createLiteral(val.getValue().toString()), new Resource[0]);
                }
            }
            dataAccumulator.accept(this.currentRDF);
            return id;
        }
        catch (IOException | RDFParseException | UnsupportedRDFormatException e) {
            this.iter.close();
            this.plugin.getLogger().error("Could not parse mongo document", e);
            return 0L;
        }
    }

    private String resolveDocumentBase(Object context) {
        return this.resolveDocumentBase(context, true);
    }

    private String resolveDocumentBase(Object context, boolean allowRemoteContext) {
        if (context instanceof Map) {
            Map contextMap = (Map)context;
            return Objects.toString(contextMap.get("@base"), null);
        }
        if (context instanceof String) {
            if (!allowRemoteContext) {
                this.plugin.getLogger().error("Attempted to load the remote context '{}' from a remote context", context);
                return null;
            }
            try {
                SimpleValueFactory.getInstance().createIRI(context.toString());
            }
            catch (IllegalArgumentException e2) {
                this.plugin.getLogger().warn("Context value must be an absolute URI got: {}", context);
                return null;
            }
            try {
                JsonStructure jsonStructure = ((JsonDocument)this.documentLoader.loadDocument(URI.create(context.toString()), new DocumentLoaderOptions())).getJsonContent().orElse(null);
                if (jsonStructure instanceof Map) {
                    Map jsonMap = (Map)jsonStructure;
                    Object contextValue = this.removeExtraQuotes(jsonMap.get("@context"));
                    return this.resolveDocumentBase(contextValue, false);
                }
            }
            catch (JsonLdError je) {
                this.plugin.getLogger().warn("Could not load external context: {}", (Object)je.getMessage());
            }
        } else if (context instanceof Collection) {
            String baseFromRemoteContext = null;
            for (Object ctxItem : (Collection)context) {
                if (ctxItem instanceof Map) {
                    String base = this.resolveDocumentBase(ctxItem, allowRemoteContext);
                    if (base == null) continue;
                    return base;
                }
                if (ctxItem instanceof String) {
                    baseFromRemoteContext = this.resolveDocumentBase(ctxItem, allowRemoteContext);
                    continue;
                }
                if (ctxItem == null) continue;
                this.plugin.getLogger().warn("Unsupported @context type. Expected document or remote URI, got : {}", ctxItem);
            }
            if (baseFromRemoteContext != null) {
                return baseFromRemoteContext;
            }
        }
        if (context != null) {
            this.plugin.getLogger().warn("Unsupported @context type. Expected document or remote URI, got : {}", context);
        }
        return null;
    }

    protected boolean hasSolution() {
        if (this.batched && !this.batchedLoading) {
            return !this.interrupted && this.storeIterator != null && this.storeIterator.hasNext();
        }
        return !this.interrupted && this.iter != null && this.iter.hasNext();
    }

    private Object removeExtraQuotes(Object value) {
        if (value instanceof JsonString) {
            return value.toString().replaceAll("^\"+|\"+$", "");
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.removeExtraQuotes(e.getValue())));
        }
        if (value instanceof List) {
            List list = (List)value;
            return list.stream().map(this::removeExtraQuotes).collect(Collectors.toList());
        }
        return value;
    }

    public StatementIterator getModelIterator(long subject, long predicate, long object) {
        Value o;
        this.setModelIteratorCreated(true);
        Resource sub = subject == 0L ? null : (Resource)this.entities.get(subject);
        final IRI p = predicate == 0L ? null : (IRI)this.entities.get(predicate);
        Value value = o = object == 0L ? null : this.entities.get(object);
        if (sub == null && this.batched && (sub = (Resource)this.entities.get(this.object)) != null && sub.equals((Object)o)) {
            sub = null;
        }
        final Resource s = sub;
        return new StatementIterator(){
            Iterator<Statement> local = null;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean next() {
                boolean has;
                if (MongoResultIterator.this.currentRDF == null) {
                    if (!MongoResultIterator.this.initialized && !MongoResultIterator.this.initializedByEntityIterator) {
                        if (!MongoResultIterator.this.isQuerySet()) {
                            return false;
                        }
                        MongoResultIterator.this.initializedByEntityIterator = true;
                        if (!MongoResultIterator.this.initialize()) return false;
                        MongoResultIterator.this.advance();
                    } else {
                        if (!MongoResultIterator.this.hasSolution()) return false;
                        MongoResultIterator.this.advance();
                    }
                }
                if (this.local == null) {
                    Resource localSub = s;
                    if (localSub == null && MongoResultIterator.this.batched && (localSub = (Resource)MongoResultIterator.this.entities.get(MongoResultIterator.this.object)) != null && localSub.equals((Object)o)) {
                        localSub = null;
                    }
                    this.local = MongoResultIterator.this.currentRDF.filter(localSub, p, o, new Resource[0]).iterator();
                }
                if (!(has = this.local.hasNext())) return has;
                Statement st = this.local.next();
                this.subject = MongoResultIterator.this.entities.resolve((Value)st.getSubject());
                if (this.subject == 0L) {
                    this.subject = MongoResultIterator.this.entities.put((Value)st.getSubject(), Entities.Scope.REQUEST);
                }
                this.predicate = MongoResultIterator.this.entities.resolve((Value)st.getPredicate());
                if (this.predicate == 0L) {
                    this.predicate = MongoResultIterator.this.entities.put((Value)st.getPredicate(), Entities.Scope.REQUEST);
                }
                this.object = MongoResultIterator.this.entities.resolve(st.getObject());
                if (this.object != 0L) return has;
                this.object = MongoResultIterator.this.entities.put(st.getObject(), Entities.Scope.REQUEST);
                return has;
            }

            public void close() {
            }
        };
    }

    public void setAggregation(List<Document> aggregation) {
        this.aggregation = aggregation;
        this.closeable &= aggregation != null;
    }

    public void setGraphId(long graphId) {
        this.graphId = graphId;
    }

    public long getQueryIdentifier() {
        long gid = this.getGraphId();
        return gid != 0L ? gid : this.getIndexId();
    }

    public long getGraphId() {
        return this.graphId;
    }

    public long getIndexId() {
        return this.indexId;
    }

    public void setIndexId(long indexId) {
        this.indexId = indexId;
    }

    public void setDocumentsLimit(int documentsLimit) {
        if (documentsLimit > 0) {
            this.batched = true;
        }
        this.documentsLimit = documentsLimit;
    }

    public int getDocumentsLimit() {
        return this.documentsLimit;
    }

    public long getSearchSubject() {
        return this.searchSubject;
    }

    public void setEntities(Entities entities) {
        this.entities = entities;
    }

    public void setHint(String hintString) {
        this.hint = hintString;
        this.closeable &= this.hint != null;
    }

    public void setCollation(String collationString) {
        this.closeable &= collationString != null;
        if (collationString != null) {
            this.setCollation(this.createCollation(collationString));
        }
    }

    public Collation getCollation() {
        return this.collation;
    }

    private Collation createCollation(String collationString) {
        Document doc = Document.parse((String)collationString);
        Collation.Builder builder = Collation.builder();
        builder.locale(doc.getString((Object)"locale"));
        if (doc.containsKey((Object)"caseLevel")) {
            builder.caseLevel(doc.getBoolean((Object)"caseLevel"));
        }
        if (doc.containsKey((Object)"caseFirst")) {
            builder.collationCaseFirst(CollationCaseFirst.fromString((String)doc.getString((Object)"caseFirst")));
        }
        if (doc.containsKey((Object)"strength")) {
            builder.collationStrength(CollationStrength.fromInt((int)doc.getInteger((Object)"strength")));
        }
        if (doc.containsKey((Object)"numericOrdering")) {
            builder.numericOrdering(doc.getBoolean((Object)"numericOrdering"));
        }
        if (doc.containsKey((Object)"alternate")) {
            builder.collationAlternate(CollationAlternate.fromString((String)doc.getString((Object)"alternate")));
        }
        if (doc.containsKey((Object)"maxVariable")) {
            builder.collationMaxVariable(CollationMaxVariable.fromString((String)doc.getString((Object)"maxVariable")));
        }
        if (doc.containsKey((Object)"normalization")) {
            builder.normalization(doc.getBoolean((Object)"normalization"));
        }
        if (doc.containsKey((Object)"backwards")) {
            builder.backwards(doc.getBoolean((Object)"backwards"));
        }
        return builder.build();
    }

    public boolean isQuerySet() {
        return this.query != null || this.aggregation != null;
    }

    public boolean isContextFirst() {
        return this.contextFirst;
    }

    public void setContextFirst(boolean contextFirst) {
        this.contextFirst = contextFirst;
    }

    public void setModelIteratorCreated(boolean modelIteratorCreated) {
        this.modelIteratorCreated = modelIteratorCreated;
    }

    public void setEntityIteratorCreated(boolean entityIteratorCreated) {
        this.entityIteratorCreated = entityIteratorCreated;
    }

    public boolean isEntityIteratorCreated() {
        return this.entityIteratorCreated;
    }

    public boolean isModelIteratorCreated() {
        return this.modelIteratorCreated;
    }

    public String getQuery() {
        return this.query;
    }

    public String getProjection() {
        return this.projection;
    }

    public String getHint() {
        return this.hint;
    }

    public void setCollation(Collation collation) {
        this.collation = collation;
    }

    public List<Document> getAggregation() {
        return this.aggregation;
    }

    public boolean isClosed() {
        return this.closed;
    }

    protected void reset() {
        this.query = null;
        this.aggregation = null;
        this.projection = null;
        this.hint = null;
        this.modelIteratorCreated = false;
        this.entityIteratorCreated = false;
        if (this.batched) {
            this.batchDocumentStore.clear();
        }
    }

    public boolean isCloned() {
        return this.cloned;
    }

    public void setCloned(boolean cloned) {
        this.cloned = cloned;
    }

    static {
        GraphDBJSONLD11ParserFactory jsonldFactory = new GraphDBJSONLD11ParserFactory();
        RDFParserRegistry.getInstance().add((Object)jsonldFactory);
    }
}

