/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.mongodb;

import com.mongodb.MongoCredential;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Optional;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    private static final Logger LOGGER = LoggerFactory.getLogger(Configuration.class);
    protected static final String CONNECTION_STRING_PROPERTY = "connectionString";
    protected static final String DATABASE_PROPERTY = "database";
    protected static final String COLLECTION_PROPERTY = "collection";
    protected static final String USER_PROPERTY = "user";
    protected static final String PASSWORD_PROPERTY = "password";
    protected static final String AUTH_DB_PROPERTY = "authDb";
    protected static final String ENC_ALG = "AES";
    protected static final String KEY_HASH_ALG = "SHA-1";
    protected static final int KEY_LENGTH = 16;
    protected Base64 encoder;
    protected String connectionString;
    protected String database;
    protected String collection;
    protected String user;
    protected String password;
    protected String authDb;
    protected File propertiesFile;
    protected boolean dirty = false;

    public Configuration(File propertiesFile) {
        this.propertiesFile = propertiesFile;
        this.encoder = new Base64();
    }

    static Configuration fromFile(File propertiesFile) throws IOException {
        Configuration conf = new Configuration(propertiesFile);
        Properties props = new Properties();
        try (FileReader reader = new FileReader(propertiesFile);){
            props.load(reader);
        }
        conf.connectionString = props.getProperty(CONNECTION_STRING_PROPERTY);
        conf.database = props.getProperty(DATABASE_PROPERTY);
        conf.collection = props.getProperty(COLLECTION_PROPERTY);
        if (props.getProperty(USER_PROPERTY) != null) {
            conf.user = props.getProperty(USER_PROPERTY);
            conf.authDb = props.getProperty(AUTH_DB_PROPERTY);
            conf.password = conf.decrypt(props.getProperty(PASSWORD_PROPERTY), conf.user);
        }
        return conf;
    }

    void delete() {
        this.propertiesFile.delete();
    }

    void persist() throws IOException {
        this.validate();
        Properties props = new Properties();
        props.setProperty(CONNECTION_STRING_PROPERTY, this.connectionString);
        props.setProperty(DATABASE_PROPERTY, this.database);
        props.setProperty(COLLECTION_PROPERTY, this.collection);
        if (this.user != null) {
            props.setProperty(USER_PROPERTY, this.user);
            props.setProperty(AUTH_DB_PROPERTY, this.authDb);
            props.setProperty(PASSWORD_PROPERTY, this.encrypt(this.password, this.user));
        }
        try (FileWriter writer = new FileWriter(this.propertiesFile);){
            props.store(writer, "Mongo properties");
        }
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public void setConnectionString(String connectionString) {
        this.dirty = true;
        this.connectionString = connectionString;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.dirty = true;
        this.database = database;
    }

    public String getCollection() {
        return this.collection;
    }

    public void setCollection(String collection) {
        this.dirty = true;
        this.collection = collection;
    }

    public void setUser(String user) {
        this.dirty = true;
        this.user = user;
    }

    public void setPassword(String password) {
        this.dirty = true;
        this.password = password;
    }

    public void setAuthDb(String authDb) {
        this.dirty = true;
        this.authDb = authDb;
    }

    public String getPropertiesFilePath() {
        return this.propertiesFile.getAbsolutePath();
    }

    public Optional<MongoCredential> getMongoCredential() {
        if (this.user != null && this.password != null && this.authDb != null) {
            return Optional.of(MongoCredential.createCredential((String)this.user, (String)this.authDb, (char[])this.password.toCharArray()));
        }
        return Optional.empty();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void validate() throws InvalidObjectException {
        if (StringUtils.isEmpty((CharSequence)this.connectionString) || StringUtils.isEmpty((CharSequence)this.database) || StringUtils.isEmpty((CharSequence)this.collection)) {
            throw new InvalidObjectException("Invalid mongo configuration. Service, database and collection are mandatory fields");
        }
        if (!(StringUtils.isEmpty((CharSequence)this.user) && StringUtils.isEmpty((CharSequence)this.password) && StringUtils.isEmpty((CharSequence)this.authDb) || !StringUtils.isEmpty((CharSequence)this.user) && !StringUtils.isEmpty((CharSequence)this.password) && !StringUtils.isEmpty((CharSequence)this.authDb))) {
            throw new InvalidObjectException("Invalid mongo configuration. If setting credentials user, password and source are mandatory");
        }
    }

    private String encrypt(String text, String key) {
        if (text == null || key == null) {
            throw new RuntimeException("Text or key is null!");
        }
        try {
            byte[] hash = Arrays.copyOf(MessageDigest.getInstance(KEY_HASH_ALG).digest(key.getBytes()), 16);
            SecretKeySpec aesKey = new SecretKeySpec(hash, ENC_ALG);
            Cipher cipher = Cipher.getInstance(ENC_ALG);
            cipher.init(1, aesKey);
            return new String(this.encoder.encode(cipher.doFinal(text.getBytes())));
        }
        catch (Exception e) {
            LOGGER.error("Could not encrypt mongo password", (Throwable)e);
            throw new RuntimeException("Could not encrypt text", e);
        }
    }

    private String decrypt(String text, String key) {
        if (text == null || key == null) {
            throw new RuntimeException("Text or key is null!");
        }
        try {
            byte[] hash = Arrays.copyOf(MessageDigest.getInstance(KEY_HASH_ALG).digest(key.getBytes()), 16);
            SecretKeySpec aesKey = new SecretKeySpec(hash, ENC_ALG);
            Cipher cipher = Cipher.getInstance(ENC_ALG);
            cipher.init(2, aesKey);
            byte[] decrypted = cipher.doFinal(this.encoder.decode(text));
            return new String(decrypted);
        }
        catch (Exception e) {
            LOGGER.error("Could not decrypt mongo password", (Throwable)e);
            throw new RuntimeException("Could not decrypt text", e);
        }
    }
}

