/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.recovery;

import com.google.common.annotations.VisibleForTesting;
import com.ontotext.graphdb.recovery.SnapshotOptions;
import java.util.Set;

public class BackupOperationStatus {
    private static int idBackupRecoveryOperation = 0;
    private final BackupOperationInProgress operation;
    private static int idCreatingBackupOperation = 0;
    private static int idRestoringBackupOperation = 0;
    private final SnapshotOptions snapshotOptions;
    private final long createdTimestamp;
    private final String username;
    private String nodePerformingClusterBackup;
    private final Set<String> affectedRepositories;

    @VisibleForTesting
    public static void reset() {
        idBackupRecoveryOperation = 0;
        idCreatingBackupOperation = 0;
        idRestoringBackupOperation = 0;
    }

    public BackupOperationStatus(BackupOperationInProgress operation, SnapshotOptions snapshotOptions, long createdTimestamp, String username, Set<String> affectedRepositories) {
        ++idBackupRecoveryOperation;
        this.operation = operation;
        this.setIdCreatingBackupOperation();
        this.setIdRestoringBackupOperation();
        this.snapshotOptions = snapshotOptions;
        this.createdTimestamp = createdTimestamp;
        this.username = username;
        this.affectedRepositories = affectedRepositories;
    }

    public BackupOperationInProgress getOperation() {
        return this.operation;
    }

    public int getIdCreatingBackupOperation() {
        return idCreatingBackupOperation;
    }

    public int getIdRestoringBackupOperation() {
        return idRestoringBackupOperation;
    }

    public SnapshotOptions getSnapshotOptions() {
        return this.snapshotOptions;
    }

    public int getIdBackupRecoveryOperation() {
        return idBackupRecoveryOperation;
    }

    public long getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    public String getUsername() {
        return this.username;
    }

    public String getNodePerformingClusterBackup() {
        return this.nodePerformingClusterBackup;
    }

    public void setAdditionalClusterNodeBackUpInfo(String nodeAddress) {
        this.nodePerformingClusterBackup = nodeAddress;
    }

    public Set<String> getAffectedRepositories() {
        return this.affectedRepositories;
    }

    private synchronized void setIdCreatingBackupOperation() {
        if (this.operation.equals((Object)BackupOperationInProgress.CREATE_BACKUP_IN_PROGRESS) || this.operation.equals((Object)BackupOperationInProgress.CREATE_CLOUD_BACKUP_IN_PROGRESS)) {
            ++idCreatingBackupOperation;
        }
    }

    private synchronized void setIdRestoringBackupOperation() {
        if (this.operation.equals((Object)BackupOperationInProgress.RESTORE_BACKUP_IN_PROGRESS) || this.operation.equals((Object)BackupOperationInProgress.RESTORE_CLOUD_BACKUP_IN_PROGRESS)) {
            ++idRestoringBackupOperation;
        }
    }

    public static enum BackupOperationInProgress {
        CREATE_BACKUP_IN_PROGRESS,
        RESTORE_BACKUP_IN_PROGRESS,
        CREATE_CLOUD_BACKUP_IN_PROGRESS,
        RESTORE_CLOUD_BACKUP_IN_PROGRESS;

    }
}

