/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt.maps;

import com.carrotsearch.hppcrt.AbstractFloatCollection;
import com.carrotsearch.hppcrt.AbstractIterator;
import com.carrotsearch.hppcrt.AbstractObjectCollection;
import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.Containers;
import com.carrotsearch.hppcrt.HashContainers;
import com.carrotsearch.hppcrt.IteratorPool;
import com.carrotsearch.hppcrt.ObjectArrays;
import com.carrotsearch.hppcrt.ObjectContainer;
import com.carrotsearch.hppcrt.ObjectFactory;
import com.carrotsearch.hppcrt.ObjectFloatAssociativeContainer;
import com.carrotsearch.hppcrt.ObjectFloatMap;
import com.carrotsearch.hppcrt.ObjectLookupContainer;
import com.carrotsearch.hppcrt.cursors.FloatCursor;
import com.carrotsearch.hppcrt.cursors.ObjectCursor;
import com.carrotsearch.hppcrt.cursors.ObjectFloatCursor;
import com.carrotsearch.hppcrt.hash.BitMixer;
import com.carrotsearch.hppcrt.predicates.FloatPredicate;
import com.carrotsearch.hppcrt.predicates.ObjectFloatPredicate;
import com.carrotsearch.hppcrt.predicates.ObjectPredicate;
import com.carrotsearch.hppcrt.procedures.FloatProcedure;
import com.carrotsearch.hppcrt.procedures.ObjectFloatProcedure;
import com.carrotsearch.hppcrt.procedures.ObjectProcedure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectFloatHashMap<KType>
implements ObjectFloatMap<KType>,
Cloneable {
    protected float defaultValue = 0.0f;
    public Object[] keys;
    public float[] values;
    protected int[] hash_cache;
    public boolean allocatedDefaultKey = false;
    public float allocatedDefaultKeyValue;
    protected int assigned;
    protected final double loadFactor;
    private int resizeAt;
    private final int perturbation = Containers.randomSeed32();
    protected final IteratorPool<ObjectFloatCursor<KType>, EntryIterator> entryIteratorPool = new IteratorPool(new ObjectFactory<EntryIterator>(){

        @Override
        public EntryIterator create() {
            return new EntryIterator();
        }

        @Override
        public void initialize(EntryIterator obj) {
            obj.cursor.index = ObjectFloatHashMap.this.keys.length + 1;
        }

        @Override
        public void reset(EntryIterator obj) {
            obj.cursor.key = null;
        }
    });

    protected int hashKey(KType key) {
        return key.hashCode();
    }

    protected boolean equalKeys(KType a, KType b) {
        return a.equals(b);
    }

    public ObjectFloatHashMap() {
        this(8);
    }

    public ObjectFloatHashMap(int initialCapacity) {
        this(initialCapacity, 0.75);
    }

    public ObjectFloatHashMap(int initialCapacity, double loadFactor) {
        this.loadFactor = loadFactor;
        this.allocateBuffers(HashContainers.minBufferSize(initialCapacity, loadFactor));
    }

    public ObjectFloatHashMap(ObjectFloatAssociativeContainer<KType> container) {
        this(container.size());
        this.putAll(container);
    }

    @Override
    public float put(KType key, float value) {
        Object existing;
        if (key == null) {
            if (this.allocatedDefaultKey) {
                float previousValue = this.allocatedDefaultKeyValue;
                this.allocatedDefaultKeyValue = value;
                return previousValue;
            }
            this.allocatedDefaultKeyValue = value;
            this.allocatedDefaultKey = true;
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        Object[] keys = this.keys;
        int slot = BitMixer.mix(this.hashKey(key), this.perturbation) & mask;
        float[] values = this.values;
        int[] cached = this.hash_cache;
        int initial_slot = slot;
        int dist = 0;
        int existing_distance = 0;
        while ((existing = keys[slot]) != null) {
            existing_distance = this.probe_distance(slot, cached);
            if (dist <= existing_distance && this.equalKeys(key, existing)) {
                float oldValue = this.values[slot];
                this.values[slot] = value;
                return oldValue;
            }
            if (dist > existing_distance) {
                Object tmpKey = keys[slot];
                keys[slot] = key;
                key = tmpKey;
                int tmpAllocated = cached[slot];
                cached[slot] = initial_slot;
                initial_slot = tmpAllocated;
                float tmpValue = values[slot];
                values[slot] = value;
                value = tmpValue;
                dist = existing_distance;
            }
            slot = slot + 1 & mask;
            ++dist;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndPut(key, value, slot);
        } else {
            ++this.assigned;
            cached[slot] = initial_slot;
            keys[slot] = key;
            values[slot] = value;
        }
        return this.defaultValue;
    }

    @Override
    public int putAll(ObjectFloatAssociativeContainer<? extends KType> container) {
        return this.putAll((Iterable<? extends ObjectFloatCursor<? extends KType>>)container);
    }

    @Override
    public int putAll(Iterable<? extends ObjectFloatCursor<? extends KType>> iterable) {
        int count = this.size();
        for (ObjectFloatCursor<KType> objectFloatCursor : iterable) {
            this.put(objectFloatCursor.key, objectFloatCursor.value);
        }
        return this.size() - count;
    }

    @Override
    public boolean putIfAbsent(KType key, float value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    @Override
    public float putOrAdd(KType key, float putValue, float incrementValue) {
        if (this.containsKey(key)) {
            putValue = this.get(key);
            putValue += incrementValue;
        }
        this.put(key, putValue);
        return putValue;
    }

    @Override
    public float addTo(KType key, float incrementValue) {
        return this.putOrAdd(key, incrementValue, incrementValue);
    }

    private void expandAndPut(KType pendingKey, float pendingValue, int freeSlot) {
        assert (this.assigned == this.resizeAt);
        assert (pendingKey != null);
        Object[] oldKeys = this.keys;
        float[] oldValues = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.keys.length, this.assigned, this.loadFactor));
        ++this.assigned;
        oldKeys[freeSlot] = pendingKey;
        oldValues[freeSlot] = pendingValue;
        int mask = this.keys.length - 1;
        Object key = null;
        float value = 0.0f;
        int slot = -1;
        Object[] keys = this.keys;
        float[] values = this.values;
        int[] cached = this.hash_cache;
        Object tmpKey = null;
        float tmpValue = 0.0f;
        int tmpAllocated = -1;
        int initial_slot = -1;
        int dist = -1;
        int existing_distance = -1;
        int perturb = this.perturbation;
        int i = oldKeys.length;
        while (--i >= 0) {
            key = oldKeys[i];
            if (key == null) continue;
            value = oldValues[i];
            initial_slot = slot = BitMixer.mix(this.hashKey(key), perturb) & mask;
            dist = 0;
            while (keys[slot] != null) {
                existing_distance = this.probe_distance(slot, cached);
                if (dist > existing_distance) {
                    tmpKey = keys[slot];
                    keys[slot] = key;
                    key = tmpKey;
                    tmpAllocated = cached[slot];
                    cached[slot] = initial_slot;
                    initial_slot = tmpAllocated;
                    tmpValue = values[slot];
                    values[slot] = value;
                    value = tmpValue;
                    dist = existing_distance;
                }
                slot = slot + 1 & mask;
                ++dist;
            }
            cached[slot] = initial_slot;
            keys[slot] = key;
            values[slot] = value;
        }
    }

    private void allocateBuffers(int capacity) {
        try {
            Object[] keys = new Object[capacity];
            float[] values = new float[capacity];
            int[] cached = new int[capacity];
            this.keys = keys;
            this.values = values;
            this.hash_cache = cached;
            this.resizeAt = HashContainers.expandAtCount(capacity, this.loadFactor);
        }
        catch (OutOfMemoryError e) {
            throw new BufferAllocationException("Not enough memory to allocate buffers to grow from %d -> %d elements", (Throwable)e, this.keys == null ? 0 : this.keys.length, capacity);
        }
    }

    @Override
    public float remove(KType key) {
        Object existing;
        if (key == null) {
            if (this.allocatedDefaultKey) {
                float previousValue = this.allocatedDefaultKeyValue;
                this.allocatedDefaultKey = false;
                return previousValue;
            }
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        Object[] keys = this.keys;
        int slot = BitMixer.mix(this.hashKey(key), this.perturbation) & mask;
        int[] cached = this.hash_cache;
        for (int dist = 0; (existing = keys[slot]) != null && dist <= this.probe_distance(slot, cached); ++dist) {
            if (this.equalKeys(key, existing)) {
                float value = this.values[slot];
                this.shiftConflictingKeys(slot);
                return value;
            }
            slot = slot + 1 & mask;
        }
        return this.defaultValue;
    }

    private void shiftConflictingKeys(int gapSlot) {
        int mask = this.keys.length - 1;
        Object[] keys = this.keys;
        float[] values = this.values;
        int[] cached = this.hash_cache;
        int distance = 0;
        while (true) {
            int slot = gapSlot + ++distance & mask;
            Object existing = keys[slot];
            float existingValue = values[slot];
            if (existing == null) break;
            int idealSlotModMask = cached[slot];
            int shift = slot - idealSlotModMask & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            values[gapSlot] = existingValue;
            cached[gapSlot] = idealSlotModMask;
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = null;
        --this.assigned;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int removeAll(ObjectContainer<? super KType> other) {
        int before = this.size();
        if (other.size() >= before && other instanceof ObjectLookupContainer) {
            void var4_6;
            if (this.allocatedDefaultKey && other.contains(null)) {
                this.allocatedDefaultKey = false;
            }
            Object[] keys = this.keys;
            boolean bl = false;
            while (var4_6 < keys.length) {
                Object existing = keys[var4_6];
                if (existing != null && other.contains(existing)) {
                    this.shiftConflictingKeys((int)var4_6);
                    continue;
                }
                ++var4_6;
            }
        } else {
            for (ObjectCursor<Object> objectCursor : other) {
                this.remove(objectCursor.value);
            }
        }
        return before - this.size();
    }

    @Override
    public int removeAll(ObjectPredicate<? super KType> predicate) {
        int before = this.size();
        if (this.allocatedDefaultKey && predicate.apply(null)) {
            this.allocatedDefaultKey = false;
        }
        Object[] keys = this.keys;
        int i = 0;
        while (i < keys.length) {
            Object existing = keys[i];
            if (existing != null && predicate.apply(existing)) {
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.size();
    }

    @Override
    public int removeAll(ObjectFloatPredicate<? super KType> predicate) {
        int before = this.size();
        if (this.allocatedDefaultKey && predicate.apply(null, this.allocatedDefaultKeyValue)) {
            this.allocatedDefaultKey = false;
        }
        Object[] keys = this.keys;
        float[] values = this.values;
        int i = 0;
        while (i < keys.length) {
            Object existing = keys[i];
            if (existing != null && predicate.apply(existing, values[i])) {
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.size();
    }

    @Override
    public float get(KType key) {
        Object existing;
        if (key == null) {
            if (this.allocatedDefaultKey) {
                return this.allocatedDefaultKeyValue;
            }
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        Object[] keys = this.keys;
        int slot = BitMixer.mix(this.hashKey(key), this.perturbation) & mask;
        int[] cached = this.hash_cache;
        for (int dist = 0; (existing = keys[slot]) != null && dist <= this.probe_distance(slot, cached); ++dist) {
            if (this.equalKeys(key, existing)) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return this.defaultValue;
    }

    @Override
    public boolean containsKey(KType key) {
        Object existing;
        if (key == null) {
            return this.allocatedDefaultKey;
        }
        int mask = this.keys.length - 1;
        Object[] keys = this.keys;
        int slot = BitMixer.mix(this.hashKey(key), this.perturbation) & mask;
        int[] cached = this.hash_cache;
        for (int dist = 0; (existing = keys[slot]) != null && dist <= this.probe_distance(slot, cached); ++dist) {
            if (this.equalKeys(key, existing)) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.allocatedDefaultKey = false;
        ObjectArrays.blankArray(this.keys, 0, this.keys.length);
    }

    @Override
    public int size() {
        return this.assigned + (this.allocatedDefaultKey ? 1 : 0);
    }

    @Override
    public int capacity() {
        return this.resizeAt;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int hashCode() {
        int h = 0;
        if (this.allocatedDefaultKey) {
            h += BitMixer.mix(this.allocatedDefaultKeyValue);
        }
        Object[] keys = this.keys;
        float[] values = this.values;
        int i = keys.length;
        while (--i >= 0) {
            Object existing = keys[i];
            if (existing == null) continue;
            h += BitMixer.mix(existing) ^ BitMixer.mix(values[i]);
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            ObjectFloatHashMap other = (ObjectFloatHashMap)obj;
            if (other.size() != this.size()) {
                return false;
            }
            EntryIterator it = this.iterator();
            while (it.hasNext()) {
                ObjectFloatCursor c = (ObjectFloatCursor)it.next();
                if (!other.containsKey(c.key)) {
                    it.release();
                    return false;
                }
                float otherValue = other.get(c.key);
                if (Float.floatToIntBits(c.value) == Float.floatToIntBits(otherValue)) continue;
                it.release();
                return false;
            }
            return true;
        }
        return false;
    }

    public EntryIterator iterator() {
        return (EntryIterator)this.entryIteratorPool.borrow();
    }

    @Override
    public <T extends ObjectFloatProcedure<? super KType>> T forEach(T procedure) {
        if (this.allocatedDefaultKey) {
            procedure.apply(null, this.allocatedDefaultKeyValue);
        }
        Object[] keys = this.keys;
        float[] values = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object existing = keys[i];
            if (existing == null) continue;
            procedure.apply((Object)existing, values[i]);
        }
        return procedure;
    }

    @Override
    public <T extends ObjectFloatPredicate<? super KType>> T forEach(T predicate) {
        Object existing;
        if (this.allocatedDefaultKey && !predicate.apply(null, this.allocatedDefaultKeyValue)) {
            return predicate;
        }
        Object[] keys = this.keys;
        float[] values = this.values;
        for (int i = keys.length - 1; i >= 0 && ((existing = keys[i]) == null || predicate.apply((Object)existing, values[i])); --i) {
        }
        return predicate;
    }

    public KeysCollection keys() {
        return new KeysCollection();
    }

    @Override
    public ValuesCollection values() {
        return new ValuesCollection();
    }

    public ObjectFloatHashMap<KType> clone() {
        ObjectFloatHashMap<KType> cloned = new ObjectFloatHashMap<KType>(this.size(), this.loadFactor);
        cloned.putAll(this);
        return cloned;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (ObjectFloatCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static <KType> ObjectFloatHashMap<KType> from(KType[] keys, float[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ObjectFloatHashMap<KType> map = new ObjectFloatHashMap<KType>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static <KType> ObjectFloatHashMap<KType> from(ObjectFloatAssociativeContainer<KType> container) {
        return new ObjectFloatHashMap<KType>(container);
    }

    public static <KType> ObjectFloatHashMap<KType> newInstance() {
        return new ObjectFloatHashMap<KType>();
    }

    public static <KType> ObjectFloatHashMap<KType> newInstance(int initialCapacity, double loadFactor) {
        return new ObjectFloatHashMap<KType>(initialCapacity, loadFactor);
    }

    @Override
    public float getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(float defaultValue) {
        this.defaultValue = defaultValue;
    }

    private int probe_distance(int slot, int[] cache) {
        int rh = cache[slot];
        if (slot < rh) {
            return slot - rh + cache.length;
        }
        return slot - rh;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValuesIterator
    extends AbstractIterator<FloatCursor> {
        public final FloatCursor cursor = new FloatCursor();

        public ValuesIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected FloatCursor fetch() {
            int i;
            if (this.cursor.index == ObjectFloatHashMap.this.values.length + 1) {
                if (ObjectFloatHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = ObjectFloatHashMap.this.values.length;
                    this.cursor.value = ObjectFloatHashMap.this.allocatedDefaultKeyValue;
                    return this.cursor;
                }
                this.cursor.index = ObjectFloatHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && ObjectFloatHashMap.this.keys[i] == null; --i) {
            }
            if (i == -1) {
                return (FloatCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = ObjectFloatHashMap.this.values[i];
            return this.cursor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValuesCollection
    extends AbstractFloatCollection {
        private final ObjectFloatHashMap<KType> owner;
        protected final IteratorPool<FloatCursor, ValuesIterator> valuesIteratorPool;

        public ValuesCollection() {
            this.owner = ObjectFloatHashMap.this;
            this.valuesIteratorPool = new IteratorPool(new ObjectFactory<ValuesIterator>(){

                @Override
                public ValuesIterator create() {
                    return new ValuesIterator();
                }

                @Override
                public void initialize(ValuesIterator obj) {
                    obj.cursor.index = ObjectFloatHashMap.this.keys.length + 1;
                }

                @Override
                public void reset(ValuesIterator obj) {
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public int capacity() {
            return this.owner.capacity();
        }

        @Override
        public boolean contains(float value) {
            if (this.owner.allocatedDefaultKey && Float.floatToIntBits(value) == Float.floatToIntBits(this.owner.allocatedDefaultKeyValue)) {
                return true;
            }
            Object[] keys = this.owner.keys;
            float[] values = this.owner.values;
            for (int slot = 0; slot < keys.length; ++slot) {
                if (keys[slot] == null || Float.floatToIntBits(value) != Float.floatToIntBits(values[slot])) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends FloatProcedure> T forEach(T procedure) {
            if (this.owner.allocatedDefaultKey) {
                procedure.apply(this.owner.allocatedDefaultKeyValue);
            }
            Object[] keys = this.owner.keys;
            float[] values = this.owner.values;
            for (int slot = 0; slot < keys.length; ++slot) {
                if (keys[slot] == null) continue;
                procedure.apply(values[slot]);
            }
            return procedure;
        }

        @Override
        public <T extends FloatPredicate> T forEach(T predicate) {
            if (this.owner.allocatedDefaultKey && !predicate.apply(this.owner.allocatedDefaultKeyValue)) {
                return predicate;
            }
            Object[] keys = this.owner.keys;
            float[] values = this.owner.values;
            for (int slot = 0; slot < keys.length && (keys[slot] == null || predicate.apply(values[slot])); ++slot) {
            }
            return predicate;
        }

        public ValuesIterator iterator() {
            return (ValuesIterator)this.valuesIteratorPool.borrow();
        }

        @Override
        public int removeAll(float e) {
            int before = this.owner.size();
            if (this.owner.allocatedDefaultKey && Float.floatToIntBits(e) == Float.floatToIntBits(this.owner.allocatedDefaultKeyValue)) {
                this.owner.allocatedDefaultKey = false;
            }
            Object[] keys = this.owner.keys;
            float[] values = this.owner.values;
            int slot = 0;
            while (slot < keys.length) {
                if (keys[slot] != null && Float.floatToIntBits(e) == Float.floatToIntBits(values[slot])) {
                    ObjectFloatHashMap.this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
            return before - this.owner.size();
        }

        @Override
        public int removeAll(FloatPredicate predicate) {
            int before = this.owner.size();
            if (this.owner.allocatedDefaultKey && predicate.apply(this.owner.allocatedDefaultKeyValue)) {
                this.owner.allocatedDefaultKey = false;
            }
            Object[] keys = this.owner.keys;
            float[] values = this.owner.values;
            int slot = 0;
            while (slot < keys.length) {
                if (keys[slot] != null && predicate.apply(values[slot])) {
                    ObjectFloatHashMap.this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
            return before - this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public float[] toArray(float[] target) {
            int count = 0;
            if (this.owner.allocatedDefaultKey) {
                target[count++] = this.owner.allocatedDefaultKeyValue;
            }
            Object[] keys = this.owner.keys;
            float[] values = this.owner.values;
            for (int i = 0; i < values.length; ++i) {
                if (keys[i] == null) continue;
                target[count++] = values[i];
            }
            assert (count == this.owner.size());
            return target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class KeysIterator
    extends AbstractIterator<ObjectCursor<KType>> {
        public final ObjectCursor<KType> cursor = new ObjectCursor();

        public KeysIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected ObjectCursor<KType> fetch() {
            int i;
            if (this.cursor.index == ObjectFloatHashMap.this.keys.length + 1) {
                if (ObjectFloatHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = ObjectFloatHashMap.this.keys.length;
                    this.cursor.value = null;
                    return this.cursor;
                }
                this.cursor.index = ObjectFloatHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && ObjectFloatHashMap.this.keys[i] == null; --i) {
            }
            if (i == -1) {
                return (ObjectCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = ObjectFloatHashMap.this.keys[i];
            return this.cursor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class KeysCollection
    extends AbstractObjectCollection<KType>
    implements ObjectLookupContainer<KType> {
        private final ObjectFloatHashMap<KType> owner;
        protected final IteratorPool<ObjectCursor<KType>, KeysIterator> keyIteratorPool;

        public KeysCollection() {
            this.owner = ObjectFloatHashMap.this;
            this.keyIteratorPool = new IteratorPool(new ObjectFactory<KeysIterator>(){

                @Override
                public KeysIterator create() {
                    return new KeysIterator();
                }

                @Override
                public void initialize(KeysIterator obj) {
                    obj.cursor.index = ObjectFloatHashMap.this.keys.length + 1;
                }

                @Override
                public void reset(KeysIterator obj) {
                    obj.cursor.value = null;
                }
            });
        }

        @Override
        public boolean contains(KType e) {
            return ObjectFloatHashMap.this.containsKey(e);
        }

        @Override
        public <T extends ObjectProcedure<? super KType>> T forEach(T procedure) {
            if (this.owner.allocatedDefaultKey) {
                procedure.apply(null);
            }
            Object[] keys = this.owner.keys;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object existing = keys[i];
                if (existing == null) continue;
                procedure.apply((Object)existing);
            }
            return procedure;
        }

        @Override
        public <T extends ObjectPredicate<? super KType>> T forEach(T predicate) {
            Object existing;
            if (this.owner.allocatedDefaultKey && !predicate.apply(null)) {
                return predicate;
            }
            Object[] keys = this.owner.keys;
            for (int i = keys.length - 1; i >= 0 && ((existing = keys[i]) == null || predicate.apply((Object)existing)); --i) {
            }
            return predicate;
        }

        public KeysIterator iterator() {
            return (KeysIterator)this.keyIteratorPool.borrow();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public int capacity() {
            return this.owner.capacity();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public int removeAll(ObjectPredicate<? super KType> predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAll(KType e) {
            boolean hasKey = this.owner.containsKey(e);
            int result = 0;
            if (hasKey) {
                this.owner.remove(e);
                result = 1;
            }
            return result;
        }

        @Override
        public KType[] toArray(KType[] target) {
            int count = 0;
            if (this.owner.allocatedDefaultKey) {
                target[count++] = null;
            }
            Object[] keys = this.owner.keys;
            for (int i = 0; i < keys.length; ++i) {
                Object existing = keys[i];
                if (existing == null) continue;
                target[count++] = existing;
            }
            assert (count == this.owner.size());
            return target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class EntryIterator
    extends AbstractIterator<ObjectFloatCursor<KType>> {
        public final ObjectFloatCursor<KType> cursor = new ObjectFloatCursor();

        public EntryIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected ObjectFloatCursor<KType> fetch() {
            int i;
            if (this.cursor.index == ObjectFloatHashMap.this.keys.length + 1) {
                if (ObjectFloatHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = ObjectFloatHashMap.this.keys.length;
                    this.cursor.key = null;
                    this.cursor.value = ObjectFloatHashMap.this.allocatedDefaultKeyValue;
                    return this.cursor;
                }
                this.cursor.index = ObjectFloatHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && ObjectFloatHashMap.this.keys[i] == null; --i) {
            }
            if (i == -1) {
                return (ObjectFloatCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.key = ObjectFloatHashMap.this.keys[i];
            this.cursor.value = ObjectFloatHashMap.this.values[i];
            return this.cursor;
        }
    }
}

