/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt;

import com.carrotsearch.hppcrt.IntIndexedContainer;
import java.util.Arrays;

public final class IntArrays {
    public static final int[] EMPTY = new int[0];
    private static final int BLANK_ARRAY_SIZE_IN_BIT_SHIFT = 10;
    private static final int BLANK_ARRAY_SIZE = 1024;
    private static final int[] BLANKING_OBJECT_ARRAY = new int[1024];

    private IntArrays() {
    }

    public static void rotate(int[] table, int from, int mid, int to) {
        IntArrays.reverse(table, from, mid);
        IntArrays.reverse(table, mid, to);
        IntArrays.reverse(table, from, to);
    }

    public static void rotate(IntIndexedContainer table, int from, int mid, int to) {
        IntArrays.reverse(table, from, mid);
        IntArrays.reverse(table, mid, to);
        IntArrays.reverse(table, from, to);
    }

    public static void reverse(int[] table, int from, int to) {
        int halfSize = to - from >>> 1;
        for (int i = 0; i < halfSize; ++i) {
            int tmpValue = table[i + from];
            table[i + from] = table[to - i - 1];
            table[to - i - 1] = tmpValue;
        }
    }

    public static void reverse(IntIndexedContainer table, int from, int to) {
        int halfSize = to - from >>> 1;
        for (int i = 0; i < halfSize; ++i) {
            int tmpValue = table.get(i + from);
            table.set(i + from, table.get(to - i - 1));
            table.set(to - i - 1, tmpValue);
        }
    }

    public static void blankArray(int[] objectArray, int startIndex, int endIndex) {
        assert (startIndex <= endIndex);
        int size = endIndex - startIndex;
        int nbChunks = size >> 10;
        int rem = size & 0x3FF;
        for (int i = 0; i < nbChunks; ++i) {
            System.arraycopy(BLANKING_OBJECT_ARRAY, 0, objectArray, startIndex + (i << 10), 1024);
        }
        if (rem > 0) {
            Arrays.fill(objectArray, startIndex + (nbChunks << 10), startIndex + (nbChunks << 10) + rem, 0);
        }
    }
}

