/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl.kafka;

import com.google.common.annotations.VisibleForTesting;
import com.ontotext.trree.plugin.externalsync.config.DynamicSettings;
import com.ontotext.trree.plugin.externalsync.impl.Property;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.json.simple.JSONObject;

class KafkaMappingGenerator
implements DynamicSettings {
    private Map<String, String> knownFieldMappings = new HashMap<String, String>();
    private boolean mappingChanged;
    static final Map<IRI, String> XML_TYPE_TO_KAFKA_TYPE = new HashMap<IRI, String>(){
        {
            this.put(XSD.BOOLEAN, "boolean");
            this.put(XSD.DOUBLE, "double");
            this.put(XSD.FLOAT, "float");
            this.put(XSD.LONG, "long");
            this.put(XSD.INT, "integer");
            this.put(XSD.DATETIME, "dateTime");
            this.put(XSD.DATE, "date");
            this.put(XSD.TIME, "time");
            this.put(XSD.GYEAR, "gYear");
            this.put(XSD.GYEARMONTH, "gYearMonth");
        }
    };

    KafkaMappingGenerator() {
    }

    @VisibleForTesting
    KafkaMappingGenerator(@Nullable Map<String, String> mapping) {
        if (mapping != null) {
            this.knownFieldMappings.putAll(mapping);
        }
    }

    @VisibleForTesting
    Map<String, String> getKnownFieldMappings() {
        return this.knownFieldMappings;
    }

    Set<String> getExistingFields() throws IOException {
        return this.knownFieldMappings.keySet();
    }

    private String getTypeForValue(Value value, Property property) {
        String type = null;
        if (value instanceof Literal && property.isIndexed() && property.isAnalyzed()) {
            IRI datatype;
            Literal literalValue = (Literal)value;
            type = property.getNativeType();
            if (type == null && (datatype = literalValue.getDatatype()) != null && datatype.getNamespace().equals("http://www.w3.org/2001/XMLSchema#")) {
                type = KafkaMappingGenerator.getTypeFromDatatype(datatype);
            }
        }
        if (type == null) {
            type = "string";
        }
        return type;
    }

    String computeType(String fieldName, @Nullable Value value, Property property) throws IOException {
        String type;
        Object fqn = fieldName;
        Property parentProperty = property.getParentProperty();
        if (parentProperty != null) {
            String parentFqn = parentProperty.getFieldName().fullyQualifiedNameWithoutSuffix;
            fqn = parentFqn + "." + fieldName;
        }
        if ((type = this.knownFieldMappings.get(fqn)) == null) {
            this.mappingChanged = true;
            assert (value != null);
            type = this.getTypeForValue(value, property);
            this.knownFieldMappings.put((String)fqn, type);
        }
        return type;
    }

    @VisibleForTesting
    void setMappingChanged(boolean mappingChanged) {
        this.mappingChanged = mappingChanged;
    }

    static String getTypeFromDatatype(IRI datatype) {
        if (datatype.getNamespace().equals("native:")) {
            return datatype.getLocalName();
        }
        String type = XML_TYPE_TO_KAFKA_TYPE.get(datatype);
        return type != null ? type.split(":", 2)[0] : null;
    }

    static String getFormatFromDatatype(IRI datatype) {
        int indexOfColon;
        String type = XML_TYPE_TO_KAFKA_TYPE.get(datatype);
        if (type != null && (indexOfColon = type.indexOf(58)) > -1) {
            return type.substring(indexOfColon + 1);
        }
        return null;
    }

    public JSONObject getSettingsAsJSON() {
        return new JSONObject(this.knownFieldMappings);
    }

    public void setSettingsFromJSON(JSONObject json) {
        this.knownFieldMappings = new HashMap<String, String>((Map<String, String>)json);
        this.mappingChanged = false;
    }

    public boolean settingsHaveChanged() {
        return this.mappingChanged;
    }
}

