/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.persistence;

import com.ontotext.forest.core.util.ResourceUtils;
import com.ontotext.forest.persistence.JsonDB;
import com.ontotext.forest.persistence.PersistedConfig;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Named;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

@Named
public class UsersConfig
extends PersistedConfig {
    @Autowired
    private ResourceUtils resourceUtils;
    @Autowired
    private PersistedConfig persistedConfig;
    private File storageDirectory;
    protected static String fileName = "users.js";
    private static final String[] LEGACY_MOVE_PROPERTIES = new String[]{"users", "ldap_users", "openid_users", "user_queries", "queries", "graphs", "graphConfigs"};

    public static UsersConfig fromDirectory(File directory, PersistedConfig persistedConfig) {
        UsersConfig usersConfig = new UsersConfig();
        usersConfig.persistedConfig = persistedConfig;
        usersConfig.init(directory);
        return usersConfig;
    }

    @Override
    @PostConstruct
    public void init() {
        this.init(this.resourceUtils.getApplicationDataDir());
    }

    @Override
    protected void init(File storageDirectory) {
        this.storageDirectory = storageDirectory;
        Path path = UsersConfig.getDBFile(storageDirectory, fileName).toPath();
        this.db = new JsonDB(path);
        if (!Files.exists(path, new LinkOption[0])) {
            this.movePropertiesFromSettings();
        }
    }

    UsersConfig() {
    }

    @Override
    public synchronized void backupConfig() {
        this.lock.lock();
        try {
            this.db.backup(UsersConfig.getDBFile(this.storageDirectory, "backup_" + fileName));
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void lockForMaintenance() {
        super.lockForMaintenance();
        this.persistedConfig.lockForMaintenance();
    }

    @Override
    public void unlockAfterMaintenance() {
        try {
            this.persistedConfig.unlockAfterMaintenance();
        }
        finally {
            super.unlockAfterMaintenance();
        }
    }

    private void movePropertiesFromSettings() {
        boolean hasBackUp = false;
        for (String property : LEGACY_MOVE_PROPERTIES) {
            Map<String, Object> persistedAccounts = this.persistedConfig.getMap(property, Object.class);
            if (persistedAccounts.isEmpty()) continue;
            if (!hasBackUp) {
                this.persistedConfig.backupConfig();
                hasBackUp = true;
            }
            this.updateMapEntries(property, Object.class, persistedAccounts);
            this.persistedConfig.deleteMapEntries(property);
        }
    }
}

