/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.persistence;

import com.ontotext.forest.core.semantic.SemanticLocationManagement;
import com.ontotext.forest.core.semantic.SemanticLocationPersisted;
import com.ontotext.forest.core.semantic.location.SemanticLocationAuth;
import com.ontotext.forest.core.util.PropertyChangedEvent;
import com.ontotext.forest.persistence.PersistedConfig;
import jakarta.inject.Named;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;

@Named
public class LocationPropertyChangedListener
implements ApplicationListener<PropertyChangedEvent> {
    private static final String PERSISTENCE_PROPERTY = "locations";
    @Autowired
    private SemanticLocationManagement semanticLocationManagement;
    @Autowired
    private PersistedConfig persistedConfig;
    private final Logger logger = LoggerFactory.getLogger(LocationPropertyChangedListener.class);

    public void onApplicationEvent(PropertyChangedEvent event) {
        String key = event.getKey();
        if (!(key.equals("semantic.location.removed") || key.equals("semantic.location.changed") || key.equals("semantic.locations.recovery") || key.equals("semantic.locations.initialized"))) {
            return;
        }
        if (key.equals("semantic.locations.initialized") || key.equals("semantic.locations.recovery")) {
            try {
                Map<String, SemanticLocationPersisted> semanticLocations = this.persistedConfig.getMap(PERSISTENCE_PROPERTY, SemanticLocationPersisted.class);
                for (SemanticLocationPersisted savedLocation : semanticLocations.values()) {
                    try {
                        SemanticLocationAuth semanticLocationAuth = this.semanticLocationManagement.getExistingLocation(savedLocation.getLocation());
                        if (semanticLocationAuth == null) {
                            this.semanticLocationManagement.addLocation(savedLocation.getLocation(), savedLocation.getAuthType(), savedLocation.getLocationType(), savedLocation.getUsername(), savedLocation.getPassword(), savedLocation.getDefaultRepository());
                            continue;
                        }
                        semanticLocationAuth.setUsername(savedLocation.getUsername());
                        semanticLocationAuth.setPassword(savedLocation.getPassword());
                        semanticLocationAuth.setAuthType(savedLocation.getAuthType());
                        semanticLocationAuth.setLocationType(savedLocation.getLocationType());
                        semanticLocationAuth.setDefaultRepository(savedLocation.getDefaultRepository());
                    }
                    catch (Exception e) {
                        this.logger.error("Cannot initialized saved location '" + savedLocation.getLocation() + "'. Cause: " + e.getMessage());
                    }
                }
                this.removeObsoleteLocationsFromCacheOnRecovery(key, semanticLocations);
            }
            catch (Exception e) {
                this.logger.error("Cannot initialized saved locations. Cause: " + e.getMessage());
            }
        } else {
            SemanticLocationAuth existingLocation = this.semanticLocationManagement.getExistingLocation(event.getValue());
            if (existingLocation != null) {
                if (key.equals("semantic.location.removed")) {
                    this.persistedConfig.deleteMapEntry(PERSISTENCE_PROPERTY, SemanticLocationPersisted.class, existingLocation.getLocation());
                }
                if (key.equals("semantic.location.changed")) {
                    this.persistedConfig.updateMapEntry(PERSISTENCE_PROPERTY, SemanticLocationPersisted.class, existingLocation.getLocation(), existingLocation);
                }
            }
        }
    }

    private void removeObsoleteLocationsFromCacheOnRecovery(String key, Map<String, SemanticLocationPersisted> semanticLocations) {
        if (key.equals("semantic.locations.recovery")) {
            for (String locationUrl : this.semanticLocationManagement.getLocationURIs()) {
                if (!StringUtils.isNotBlank((CharSequence)locationUrl) || semanticLocations.containsKey(locationUrl)) continue;
                this.semanticLocationManagement.removeLocation(locationUrl);
            }
        }
    }
}

