/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.core.util;

import com.ontotext.forest.core.error.GraphDBWorkbenchException;
import com.ontotext.forest.core.semantic.SemanticDataManagement;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Named
public class QueryUtils {
    private static final Pattern prefixPattern = Pattern.compile("\\b([\\w-_]+:)(?!//)");
    private static final Pattern queryBeginPattern = Pattern.compile("\\b(select|construct|ask|insert|delete|load|clear|drop|copy|move|add|describe)\\b", 2);
    @Autowired
    private SemanticDataManagement dataManagement;

    public static String decorate(String str, Map<String, String> values) {
        Matcher m = Pattern.compile("\\$\\{[^}]*\\}").matcher(str);
        while (m.find()) {
            String key = m.group().replaceAll("^\\$\\{|\\}$", "");
            String value = values.get(key);
            if (value == null) {
                value = "";
            }
            str = str.replaceAll("\\$\\{" + key + "\\}", Matcher.quoteReplacement(value));
        }
        return str;
    }

    public static LinkedHashMap<String, String> getQueryMap(String[] queryPairs) {
        LinkedHashMap<String, String> queryMap = new LinkedHashMap<String, String>();
        ArrayList<String> queryPairsList = new ArrayList<String>(queryPairs.length);
        for (String queryVal : queryPairs) {
            if (org.springframework.util.StringUtils.isEmpty((Object)queryVal)) continue;
            queryPairsList.add(queryVal);
        }
        if (queryPairsList.size() % 2 == 0) {
            for (int i = 0; i < queryPairsList.size(); i += 2) {
                String[] lines = ((String)queryPairsList.get(i + 1)).split("\\n");
                int indent = Integer.MAX_VALUE;
                for (int j = 1; j < lines.length; ++j) {
                    indent = Math.min(indent, lines[j].length() - org.springframework.util.StringUtils.trimLeadingWhitespace((String)lines[j]).length());
                }
                queryMap.put(((String)queryPairsList.get(i)).trim(), Pattern.compile("^\\s{" + indent + "}", 8).matcher((CharSequence)queryPairsList.get(i + 1)).replaceAll("").trim());
            }
        }
        return queryMap;
    }

    public String completeQueryWithNamespaces(String queryString) throws GraphDBWorkbenchException {
        String query = queryString;
        StringBuilder namespaces = new StringBuilder();
        HashSet<String> added = new HashSet<String>();
        Matcher preQueryMatcher = queryBeginPattern.matcher(query);
        if (preQueryMatcher.find()) {
            namespaces.append(query.substring(0, preQueryMatcher.start()));
            Matcher matcher = prefixPattern.matcher(namespaces);
            while (matcher.find()) {
                added.add(matcher.group());
            }
            query = query.substring(preQueryMatcher.start());
            matcher = prefixPattern.matcher(query);
            while (matcher.find()) {
                String match = matcher.group();
                if (added.contains(match)) continue;
                String ns = this.dataManagement.getCurrentRepositoryOrThrow().getNamespace(match.substring(0, match.length() - 1));
                if (ns == null && match.equals("onto:")) {
                    ns = "http://www.ontotext.com/";
                }
                if (ns != null) {
                    StringBuilder missingNamespaces = new StringBuilder();
                    missingNamespaces.append("PREFIX ");
                    missingNamespaces.append(match);
                    missingNamespaces.append(" <");
                    missingNamespaces.append(ns);
                    missingNamespaces.append(">\n");
                    namespaces.insert(0, missingNamespaces);
                }
                added.add(match);
            }
        }
        return String.valueOf(namespaces) + query;
    }

    public static String generateLangMatchesIfs(String variable, Collection<String> languages) {
        LinkedHashSet<String> languageList;
        LinkedHashSet<String> linkedHashSet = languageList = languages == null || languages.isEmpty() ? new LinkedHashSet<String>() : new LinkedHashSet<String>(languages);
        if (!languageList.contains("en")) {
            languageList.add("en");
        }
        languageList.add("");
        int[] count = new int[]{0};
        return Stream.concat(languageList.stream(), Stream.of("")).map(l -> {
            int n = count[0];
            count[0] = n + 1;
            return "IF(langMatches(" + variable + ", '" + l + "'), " + n + ", ";
        }).reduce(String::concat).get() + "1000" + StringUtils.repeat((char)')', (int)count[0]);
    }
}

