/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.core.util;

import com.ontotext.graphdb.ServerMaintenanceListener;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;

public class BeanServerRecoveryListener
implements ServerMaintenanceListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final List<ServerMaintenanceListener> listeners = new ArrayList<ServerMaintenanceListener>();

    public BeanServerRecoveryListener(Iterable<ServerMaintenanceListener> serverRecoveryListeners) {
        if (serverRecoveryListeners != null) {
            serverRecoveryListeners.forEach(this.listeners::add);
        }
        this.listeners.sort(Comparator.comparing(ServerMaintenanceListener::getOrderIndex));
    }

    public BeanServerRecoveryListener(BeanFactory beanFactory) {
        beanFactory.getBeanProvider(ServerMaintenanceListener.class).forEach(this.listeners::add);
        this.listeners.sort(Comparator.comparing(ServerMaintenanceListener::getOrderIndex));
    }

    public void lockForMaintenance() {
        for (ServerMaintenanceListener listener : this.listeners) {
            try {
                LOGGER.debug("prepareForRecovery on {}", (Object)listener.getClass().getSimpleName());
                listener.lockForMaintenance();
            }
            catch (RuntimeException re) {
                LOGGER.warn("Server state listener {} failed to prepare for recovery", (Object)listener.getClass().getSimpleName(), (Object)re);
            }
        }
    }

    public void unlockAfterMaintenance() {
        if (this.listeners.isEmpty()) {
            return;
        }
        ListIterator<ServerMaintenanceListener> iterator = this.listeners.listIterator(this.listeners.size());
        while (iterator.hasPrevious()) {
            ServerMaintenanceListener listener = iterator.previous();
            try {
                LOGGER.debug("afterRecovery on {}", (Object)listener.getClass().getSimpleName());
                listener.unlockAfterMaintenance();
            }
            catch (RuntimeException re) {
                LOGGER.warn("Server state listener {} failed to prepare for recovery", (Object)listener.getClass().getSimpleName(), (Object)re);
            }
        }
    }
}

