/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.core.test;

import jakarta.servlet.ServletContext;
import org.springframework.beans.factory.support.BeanDefinitionReader;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigUtils;
import org.springframework.core.io.FileSystemResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.mock.web.MockServletContext;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.support.AbstractContextLoader;
import org.springframework.web.context.support.StaticWebApplicationContext;

public class MockServletContextWebContextLoader
extends AbstractContextLoader {
    public final ConfigurableApplicationContext loadContext(String ... locations) throws Exception {
        StaticWebApplicationContext context = new StaticWebApplicationContext();
        this.prepareContext(context);
        this.customizeBeanFactory(context.getDefaultListableBeanFactory());
        this.createBeanDefinitionReader(context).loadBeanDefinitions(locations);
        AnnotationConfigUtils.registerAnnotationConfigProcessors((BeanDefinitionRegistry)context);
        this.customizeContext(context);
        context.refresh();
        context.registerShutdownHook();
        return context;
    }

    protected void prepareContext(StaticWebApplicationContext context) {
        MockServletContext servletContext = new MockServletContext((ResourceLoader)new FileSystemResourceLoader());
        servletContext.setAttribute(StaticWebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)context);
        context.setServletContext((ServletContext)servletContext);
    }

    protected void customizeBeanFactory(DefaultListableBeanFactory beanFactory) {
    }

    protected BeanDefinitionReader createBeanDefinitionReader(StaticWebApplicationContext context) {
        return new XmlBeanDefinitionReader((BeanDefinitionRegistry)context);
    }

    protected void customizeContext(StaticWebApplicationContext context) {
    }

    protected String getResourceSuffix() {
        return "-context.xml";
    }

    public ApplicationContext loadContext(MergedContextConfiguration mergedConfig) throws Exception {
        return this.loadContext(mergedConfig.getLocations());
    }
}

