/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.core.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.model.Namespace;
import org.springframework.stereotype.Service;

@Service
public class URIPrefixService {
    public List<String> resolveNamespaces(Collection<Namespace> namespaces, List<String> values) {
        LinkedList valuesWithPrefix = Lists.newLinkedList();
        valuesWithPrefix.addAll(values.stream().map(valueStr -> this.resolveNamespaces(namespaces, (String)valueStr)).collect(Collectors.toList()));
        return valuesWithPrefix;
    }

    public final String resolveNamespaces(Collection<Namespace> namespaces, String valueStr) {
        if (valueStr != null) {
            for (Namespace n : namespaces) {
                String absNamespaceStr = n.getName();
                String prefix = n.getPrefix();
                if (!valueStr.startsWith(absNamespaceStr)) continue;
                return valueStr.replace(absNamespaceStr, prefix + ":");
            }
        }
        return valueStr;
    }

    public final String resolveChangedOrDeletedNamespaces(Collection<Namespace> namespaces, String valueStr, String absUri, boolean areNamespacesAdded) {
        block6: {
            if (valueStr == null) break block6;
            if (areNamespacesAdded) {
                for (Namespace n : namespaces) {
                    String absNamespaceStr = n.getName();
                    String prefix = n.getPrefix();
                    String prefixWithColon = prefix + ":";
                    if (absUri.startsWith(absNamespaceStr)) {
                        if (valueStr.startsWith(absNamespaceStr)) {
                            return valueStr.replace(absNamespaceStr, prefixWithColon);
                        }
                        return valueStr.replace(StringUtils.substringBefore((String)valueStr, (String)":"), prefix);
                    }
                    if (!valueStr.startsWith(prefix) || absUri.contains(absNamespaceStr)) continue;
                    return absUri;
                }
            } else {
                for (Namespace n : namespaces) {
                    String prefix = n.getPrefix();
                    if (!valueStr.startsWith(prefix)) continue;
                    return absUri;
                }
            }
        }
        return valueStr;
    }

    public final String prefixToFullURI(Collection<Namespace> namespaces, String valueStr) {
        if (valueStr != null) {
            for (Namespace n : namespaces) {
                String absNamespaceStr = n.getName();
                String prefix = n.getPrefix();
                if (!valueStr.startsWith(prefix + ":")) continue;
                valueStr = valueStr.replace(prefix + ":", absNamespaceStr);
            }
        }
        return valueStr;
    }

    public final Map<String, List<String>> resolveNamespacesForMultipleBindings(Map<String, List<String>> queryResults, List<Namespace> namespaces, String ... ignoredResultBindings) {
        LinkedHashMap resultMap = Maps.newLinkedHashMap();
        for (Map.Entry<String, List<String>> resEntry : queryResults.entrySet()) {
            String key = resEntry.getKey();
            boolean isIgnoredKey = Arrays.stream(ignoredResultBindings).anyMatch(input -> input.equals(key));
            if (isIgnoredKey) continue;
            List<String> valuesWithPrefix = this.resolveNamespaces(namespaces, resEntry.getValue());
            resultMap.put(key, valuesWithPrefix);
        }
        return resultMap;
    }

    public Map.Entry<Set<Namespace>, Boolean> findNamespacesDiff(Set<Namespace> currentNamespaces, Set<Namespace> newestNamespaces) {
        if (!currentNamespaces.isEmpty()) {
            Sets.SetView current2NewDiff = Sets.difference(currentNamespaces, newestNamespaces);
            if (current2NewDiff.size() <= 1 && currentNamespaces.size() <= newestNamespaces.size()) {
                Sets.SetView new2CurrentDiff = Sets.difference(newestNamespaces, currentNamespaces);
                return new AbstractMap.SimpleEntry<Sets.SetView, Boolean>(new2CurrentDiff, true);
            }
            return new AbstractMap.SimpleEntry<Sets.SetView, Boolean>(current2NewDiff, false);
        }
        return new AbstractMap.SimpleEntry<HashSet, Object>(Sets.newHashSet(), null);
    }
}

