/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.core.semantic.rpc;

import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.raft.grpc.RpcServer;
import com.ontotext.graphdb.raft.node.ClusterFactory;
import io.grpc.BindableService;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class GraphDBRpcServer {
    public static final String ENABLE_RPC_SERVER = "graphdb.enable.rpc.server";
    private static final Logger logger = LoggerFactory.getLogger(GraphDBRpcServer.class);
    private final boolean enableRpc = Config.getPropertyAsBoolean((String)"graphdb.enable.rpc.server", (boolean)true);
    private RpcServer rpcServer;
    @Autowired
    private ApplicationContext applicationContext;
    private Exception rpcException;

    @PostConstruct
    private void init() {
        try {
            if (this.enableRpc) {
                int port = this.fetchRPCPort();
                List<BindableService> services = this.loadServices();
                this.rpcServer = ClusterFactory.createRpcServer(services, (String)Config.getProperty((String)"graphdb.connector.address"), (int)port);
                this.rpcServer.start();
                logger.info("Started gRPC server on port {} successfully", (Object)port);
            }
        }
        catch (Exception e) {
            logger.error("Could not start gRPC server due to: ", (Throwable)e);
            this.rpcException = e;
            this.rpcServer = null;
        }
    }

    protected List<BindableService> loadServices() {
        Map beansOfType = this.applicationContext.getBeansOfType(BindableService.class);
        return new LinkedList<BindableService>(beansOfType.values());
    }

    @PreDestroy
    private void shutdownRpcServer() throws RepositoryException {
        if (this.enableRpc) {
            try {
                if (this.rpcServer != null && !this.rpcServer.isStopped()) {
                    this.rpcServer.stop();
                    logger.debug("Shutdown gRPC server successfully");
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error("Did not wait for gRPC server to shutdown due to: ", (Throwable)e);
            }
        }
    }

    public RpcServer getRpcServer() {
        if (this.rpcServer == null && this.enableRpc) {
            throw new IllegalStateException("Could not enable cluster replication as gRPC server is not running", this.rpcException);
        }
        return this.rpcServer;
    }

    private int fetchRPCPort() {
        int port = Config.getRPCPort();
        if (!GraphDBRpcServer.portIsAvailable(port)) {
            throw new IllegalStateException("RPC Port " + port + " is not available.");
        }
        return port;
    }

    private static boolean portIsAvailable(int port) {
        boolean bl;
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("Invalid port: " + port);
        }
        ServerSocket ss = new ServerSocket(port);
        try {
            ss.setReuseAddress(true);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ss.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        ss.close();
        return bl;
    }
}

