/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.core.semantic.remote;

import java.util.regex.Pattern;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.Query;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.base.RepositoryConnectionWrapper;

public class CustomHTTPRepositoryConnection
extends RepositoryConnectionWrapper {
    private static Pattern PROLOG_PATTERN = Pattern.compile("(\\s*(prefix[^:]+:\\s*<[^>]*>\\s*|base\\s+<[^>]*>\\s*|#.*$))*\\s*", 10);

    public CustomHTTPRepositoryConnection(Repository repository, RepositoryConnection delegate) {
        super(repository, delegate);
    }

    public Query prepareQuery(QueryLanguage ql, String query, String baseURI) throws MalformedQueryException, RepositoryException {
        if (QueryLanguage.SPARQL.equals((Object)ql)) {
            String strippedQuery = CustomHTTPRepositoryConnection.removeSPARQLQueryProlog(query).toUpperCase();
            if (strippedQuery.startsWith("SELECT")) {
                return this.prepareTupleQuery(ql, query, baseURI);
            }
            if (strippedQuery.startsWith("ASK")) {
                return this.prepareBooleanQuery(ql, query, baseURI);
            }
            return this.prepareGraphQuery(ql, query, baseURI);
        }
        return super.prepareQuery(ql, query, baseURI);
    }

    static String removeSPARQLQueryProlog(String queryString) {
        return PROLOG_PATTERN.matcher(queryString).replaceFirst("");
    }
}

