/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.core.semantic.location;

import com.google.common.annotations.VisibleForTesting;
import com.ontotext.forest.core.semantic.LocationType;
import com.ontotext.forest.core.semantic.location.SemanticLocationAuth;
import com.ontotext.graphdb.GraphDBHTTPContext;
import com.ontotext.graphdb.security.AuthType;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import javax.crypto.spec.SecretKeySpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OntopicSemanticRepositoryLocation
extends SemanticLocationAuth {
    public OntopicSemanticRepositoryLocation(String location, @Nullable String username, @Nullable String password) {
        super(location, AuthType.BASIC, LocationType.ONTOPIC, username, password, null);
        this.updateRequestAuthenticator();
    }

    @Override
    public void updateRequestAuthenticator() {
        Key generatedSecretKey = this.generateSecretKey();
        this.requestAuthenticator = (httpRequest, httpContext) -> {
            GraphDBHTTPContext.User loggedUser = GraphDBHTTPContext.getAuthenticatedUser();
            HashMap<String, A[]> claims = new HashMap<String, A[]>();
            claims.put("roles", loggedUser.getRoles().toArray(String[]::new));
            long now = System.currentTimeMillis();
            String jwt = Jwts.builder().setHeaderParam("typ", (Object)"JWT").setSubject(loggedUser.getUsername()).setIssuedAt(new Date(now)).setExpiration(new Date(now + 3600000L)).setId(UUID.randomUUID().toString()).addClaims(claims).setIssuer(this.getUsername()).signWith(generatedSecretKey, SignatureAlgorithm.HS256).compact();
            httpRequest.setHeader("Authorization", "Bearer " + jwt);
        };
    }

    @VisibleForTesting
    @NotNull
    public Key generateSecretKey() {
        byte[] bytes = this.getPassword().getBytes(StandardCharsets.UTF_8);
        if (bytes.length < 32) {
            byte[] paddedBytes = new byte[32];
            System.arraycopy(bytes, 0, paddedBytes, 0, bytes.length);
            bytes = paddedBytes;
        }
        return new SecretKeySpec(bytes, SignatureAlgorithm.HS256.getJcaName());
    }
}

