/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.core.request;

import com.ontotext.graphdb.GraphDBHTTPContext;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.core.NamedInheritableThreadLocal;
import org.springframework.web.filter.OncePerRequestFilter;

public class RequestFilter
extends OncePerRequestFilter {
    private static final InheritableThreadLocal<HttpServletRequest> requestHolder = new NamedInheritableThreadLocal("request");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        requestHolder.set(request);
        try {
            GraphDBHTTPContext.setTrackAlias((String)request.getHeader("X-GraphDB-Track-Alias"));
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            requestHolder.set(null);
        }
    }

    protected boolean shouldNotFilterErrorDispatch() {
        return false;
    }

    public static HttpServletRequest getRequest() {
        return (HttpServletRequest)requestHolder.get();
    }

    public static String getRequestURI() {
        return ((HttpServletRequest)requestHolder.get()).getRequestURI();
    }
}

