/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.core.properties.reload;

import com.ontotext.forest.core.properties.PropertyResource;
import com.ontotext.forest.core.properties.reload.FileChangedReloadingStrategy;
import com.ontotext.forest.core.properties.reload.ReloadingStrategy;
import com.ontotext.graphdb.ServerMaintenanceListener;

public class ReloadingPropertyResource
extends PropertyResource
implements ServerMaintenanceListener {
    private ReloadingStrategy reloadingStrategy = new FileChangedReloadingStrategy();

    public ReloadingPropertyResource() {
        this.reloadingStrategy.setPropertyResource(this);
    }

    @Override
    public Object getProperty(String key) {
        if (this.reloadingStrategy != null && this.reloadingStrategy.reloadingRequired()) {
            this.performReload();
        }
        return super.getProperty(key);
    }

    public ReloadingStrategy getReloadingStrategy() {
        return this.reloadingStrategy;
    }

    public void setReloadingStrategy(ReloadingStrategy reloadingStrategy) {
        this.reloadingStrategy = reloadingStrategy;
        this.reloadingStrategy.setPropertyResource(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performReload() {
        ReloadingStrategy reloadingStrategy = this.reloadingStrategy;
        synchronized (reloadingStrategy) {
            super.reloadPropertyPlaceholderConfigurer();
            this.reloadingStrategy.reloadingPerformed();
        }
    }

    public void unlockAfterMaintenance() {
        this.performReload();
    }

    public int getOrderIndex() {
        return 100;
    }
}

