/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.core.properties.reload;

import com.ontotext.forest.core.properties.PropertyResource;
import com.ontotext.forest.core.properties.reload.ReloadingStrategy;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;

public class FileChangedReloadingStrategy
implements ReloadingStrategy {
    private final Log logger = LogFactory.getLog(this.getClass());
    private static final String JAR_PROTOCOL = "jar";
    private static final String PROTOCOL_FILE = "file";
    private static final int DEFAULT_REFRESH_DELAY = 5000;
    protected PropertyResource resource;
    protected long lastModified;
    protected long lastChecked = -1L;
    protected long refreshDelay = 5000L;
    private boolean reloading = false;
    private File[] files;

    @Override
    public void setPropertyResource(PropertyResource configuration) {
        this.resource = configuration;
    }

    @Override
    public void init() {
        this.updateLastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean reloadingRequired() {
        FileChangedReloadingStrategy fileChangedReloadingStrategy = this;
        synchronized (fileChangedReloadingStrategy) {
            if (!this.reloading) {
                if (this.lastChecked > 0L) {
                    long now = System.currentTimeMillis();
                    if (now > this.lastChecked + this.refreshDelay) {
                        this.lastChecked = now;
                        if (this.hasChanged()) {
                            this.reloading = true;
                        }
                    }
                } else {
                    this.lastChecked = System.currentTimeMillis();
                }
            }
            return this.reloading;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reloadingPerformed() {
        FileChangedReloadingStrategy fileChangedReloadingStrategy = this;
        synchronized (fileChangedReloadingStrategy) {
            this.updateLastModified();
            this.logger.info((Object)"Reloaded properties files.");
        }
    }

    public long getRefreshDelay() {
        return this.refreshDelay;
    }

    public void setRefreshDelay(long refreshDelay) {
        this.refreshDelay = refreshDelay;
    }

    protected void updateLastModified() {
        for (File file : this.getFiles()) {
            long fModified;
            if (file == null || (fModified = file.lastModified()) <= this.lastModified) continue;
            this.lastModified = fModified;
        }
        this.reloading = false;
    }

    protected boolean hasChanged() {
        boolean hasChanged = false;
        for (File file : this.getFiles()) {
            if (file == null || !file.exists() || file.lastModified() <= this.lastModified) continue;
            hasChanged = true;
            break;
        }
        return hasChanged;
    }

    protected File[] getFiles() {
        if (this.files == null) {
            ArrayList<File> filesList = new ArrayList<File>(this.resource.getResources().length);
            for (int i = 0; i < this.resource.getResources().length; ++i) {
                Resource location = this.resource.getResources()[i];
                try {
                    filesList.add(this.fileFromURL(location.getURL()));
                    continue;
                }
                catch (IOException e) {
                    this.logger.warn((Object)("Missing file or invalid URL: " + String.valueOf(location)));
                }
            }
            this.files = filesList.toArray(new File[filesList.size()]);
        }
        return this.files;
    }

    private File fileFromURL(URL url) {
        if (JAR_PROTOCOL.equals(url.getProtocol())) {
            String path = url.getPath();
            try {
                url = new URL(path.substring(0, path.indexOf(33)));
            }
            catch (MalformedURLException mex) {
                return null;
            }
        }
        if (PROTOCOL_FILE.equals(url.getProtocol())) {
            return new File(URLDecoder.decode(url.getPath()));
        }
        return null;
    }
}

