/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.core.properties;

import com.ontotext.forest.core.properties.AskablePropertyPlaceholderConfigurer;
import com.ontotext.forest.core.properties.PropertyResource;
import com.ontotext.forest.core.properties.reload.ReloadingPropertyResource;
import com.ontotext.forest.core.util.ResourceUtils;
import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.ServerMaintenanceListener;
import jakarta.inject.Named;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.OrderComparator;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.CollectionUtils;

@Named
public class ExtendedPropertyPlaceholderConfigurer
extends AskablePropertyPlaceholderConfigurer
implements ServerMaintenanceListener {
    private Properties properties = new Properties();
    private List<PropertyResource> propertyResources = new LinkedList<PropertyResource>();
    private Map<Resource, PropertyResource> locationsToPropertyResources = new HashMap<Resource, PropertyResource>();
    private Map<String, Resource> propertyKeyToLocation = new HashMap<String, Resource>();
    private String stringArraySeparator;
    private static final String ARRAY_SEPARATOR_KEY = "app.stringArraySeparator";
    private List<String> processedPropertyResourceBeans = new LinkedList<String>();
    private List<Resource> locations;
    private Map<String, String> configProperties;

    public ExtendedPropertyPlaceholderConfigurer() {
        this.setIgnoreResourceNotFound(true);
        this.setSystemPropertiesModeName("SYSTEM_PROPERTIES_MODE_OVERRIDE");
    }

    protected void processProperties(ConfigurableListableBeanFactory beanFactoryToProcess, Properties properties) throws BeansException {
        this.properties = properties;
        super.processProperties(beanFactoryToProcess, properties);
        this.configProperties = Config.getProperties();
    }

    public void addPropertyResource(PropertyResource propertyResource) {
        this.propertyResources.add(propertyResource);
        this.updateLocations();
        this.loadProperties();
    }

    @Override
    public Object getProperty(String key) {
        String value = super.resolvePlaceholder(key, this.properties, 2);
        if (value != null) {
            if (this.stringArraySeparator == null) {
                this.stringArraySeparator = super.resolvePlaceholder(ARRAY_SEPARATOR_KEY, this.properties, 2);
            }
            if (this.stringArraySeparator != null && value.indexOf(this.stringArraySeparator) != -1 && !value.equals(this.stringArraySeparator)) {
                String[] arr = value.split(this.stringArraySeparator);
                for (int i = 0; i < arr.length; ++i) {
                    arr[i] = ResourceUtils.decorate(arr[i].trim(), this.configProperties);
                }
                return arr;
            }
            return ResourceUtils.decorate(value.trim(), this.configProperties);
        }
        return null;
    }

    private void updateLocations() {
        Collections.sort(this.propertyResources, Collections.reverseOrder(OrderComparator.INSTANCE));
        LinkedList<Resource> locations = new LinkedList<Resource>();
        for (PropertyResource propertyResource : this.propertyResources) {
            for (Resource location : propertyResource.getResources()) {
                locations.add(location);
                this.locationsToPropertyResources.put(location, propertyResource);
            }
        }
        this.locations = locations;
    }

    public void loadProperties() {
        try {
            this.properties = this.mergeProperties();
            this.convertProperties(this.properties);
        }
        catch (IOException ex) {
            throw new BeanInitializationException("Could not load properties", (Throwable)ex);
        }
    }

    public void refresh() {
        this.updateLocations();
        this.loadProperties();
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.initPropertyResources(beanFactory);
        this.processProperties(beanFactory, this.properties);
    }

    private void initPropertyResources(ConfigurableListableBeanFactory beanFactory) {
        String[] postProcessorNames = beanFactory.getBeanNamesForType(PropertyResource.class, true, false);
        ArrayList<PropertyResource> priorityOrderedPropertyResources = new ArrayList<PropertyResource>(postProcessorNames.length);
        for (String ppName : postProcessorNames) {
            if (this.processedPropertyResourceBeans.contains(ppName)) continue;
            priorityOrderedPropertyResources.add((PropertyResource)beanFactory.getBean(ppName, PropertyResource.class));
            this.processedPropertyResourceBeans.add(ppName);
        }
        OrderComparator.sort(priorityOrderedPropertyResources);
        for (PropertyResource propertyResource : priorityOrderedPropertyResources) {
            this.addPropertyResource(propertyResource);
            propertyResource.setEppc(this);
        }
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public String getPropertySource(String key) {
        Resource location = this.propertyKeyToLocation.get(key);
        if (location != null) {
            try {
                return location.getURI().toString();
            }
            catch (IOException e) {
                this.logger.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    protected Properties mergeProperties() throws IOException {
        Properties result = new Properties();
        if (this.localOverride) {
            this.loadProperties(result);
        }
        if (this.localProperties != null) {
            for (Properties localProp : this.localProperties) {
                CollectionUtils.mergePropertiesIntoMap((Properties)localProp, (Map)result);
            }
        }
        if (!this.localOverride) {
            this.loadProperties(result);
        }
        return result;
    }

    protected void loadProperties(Properties props) throws IOException {
        if (this.locations != null) {
            for (Resource location : this.locations) {
                Properties intermediate = new Properties();
                this.logger.debug((Object)("Loading properties file from " + String.valueOf(location)));
                try {
                    PropertiesLoaderUtils.fillProperties((Properties)intermediate, (EncodedResource)new EncodedResource(location));
                    for (Object key : intermediate.keySet()) {
                        this.propertyKeyToLocation.put(key.toString(), location);
                    }
                    CollectionUtils.mergePropertiesIntoMap((Properties)intermediate, (Map)props);
                }
                catch (IOException ex) {
                    if (!this.logger.isWarnEnabled()) continue;
                    this.logger.warn((Object)("Could not load properties from " + String.valueOf(location) + ": " + ex.getMessage()));
                }
            }
        }
    }

    public void unlockAfterMaintenance() {
        for (PropertyResource resource : this.propertyResources) {
            if (!(resource instanceof ReloadingPropertyResource)) continue;
            ((ReloadingPropertyResource)resource).getReloadingStrategy().reloadingPerformed();
        }
        this.refresh();
    }

    public int getOrderIndex() {
        return 50;
    }
}

