/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.core.guides;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ontotext.forest.core.error.GraphDBWorkbenchException;
import com.ontotext.graphdb.Config;
import io.swagger.v3.oas.annotations.Hidden;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/guides"})
@Hidden
public class GuidesController {
    private static final Logger LOG = LoggerFactory.getLogger(GuidesController.class);
    private static final String GUIDES_DIRECTORY_PROPERTY = "graphdb.workbench.guides";
    private final Path guidesDirectory;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public GuidesController() {
        String userPath = Config.getProperty((String)GUIDES_DIRECTORY_PROPERTY);
        this.guidesDirectory = userPath != null ? Paths.get(userPath, new String[0]).toAbsolutePath() : Paths.get(Config.getDistDirectory(), "examples", "workbench-guides");
    }

    @RequestMapping
    public List<JsonNode> getGuides() {
        ArrayList<JsonNode> result = new ArrayList<JsonNode>();
        try (Stream<Path> walk = Files.walk(this.guidesDirectory, new FileVisitOption[0]);){
            walk.filter(path -> Files.isRegularFile(path, new LinkOption[0]) && path.getFileName().toString().endsWith(".json")).forEach(path -> {
                try {
                    result.add(this.objectMapper.readTree(path.toFile()));
                }
                catch (IOException e) {
                    LOG.warn("Could not process guide in {}, ignoring it: {}", path, (Object)e.getMessage());
                }
            });
        }
        catch (IOException e) {
            LOG.error("Could not load workbench guides", (Throwable)e);
            throw new GraphDBWorkbenchException("Could not load workbench guides", e);
        }
        return result;
    }

    @RequestMapping(value={"/download/**"})
    public void downloadGuideFile(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String filename = this.getFilenameFromRequest(request);
        Path localFile = this.guidesDirectory.resolve(filename);
        String contentType = Files.probeContentType(localFile);
        response.setContentType(contentType);
        ContentDisposition contentDisposition = ContentDisposition.builder((String)"attachment").filename(localFile.getFileName().toString()).build();
        response.setHeader("Content-Disposition", contentDisposition.toString());
        try {
            Files.copy(localFile, (OutputStream)response.getOutputStream());
        }
        catch (NoSuchFileException e) {
            response.setStatus(HttpStatus.NOT_FOUND.value());
            response.setContentType("text/plain");
            response.setCharacterEncoding(StandardCharsets.UTF_8.name());
            response.setHeader("Content-Disposition", "inline");
            String message = "No such file: " + filename;
            response.getOutputStream().write(message.getBytes(StandardCharsets.UTF_8));
        }
    }

    private String getFilenameFromRequest(HttpServletRequest request) {
        String requestURI = URLDecoder.decode(request.getRequestURI(), StandardCharsets.UTF_8);
        String prefix = "/rest/guides/download/";
        return requestURI.substring(requestURI.indexOf(prefix) + prefix.length());
    }
}

