/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.core.graphdb;

import com.ontotext.forest.core.error.GraphDBWorkbenchException;
import com.ontotext.forest.core.graphdb.ErrorLicense;
import com.ontotext.forest.core.graphdb.ExtendedLicense;
import com.ontotext.forest.core.graphdb.InvalidLicense;
import com.ontotext.forest.core.graphdb.ValidLicense;
import com.ontotext.license.License;
import com.ontotext.license.LicenseRegistry;
import com.ontotext.license.LicenseValidationException;
import io.swagger.v3.oas.annotations.Hidden;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.eclipse.rdf4j.http.server.HTTPException;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@RequestMapping(value={"/rest/info"})
@Controller
public class GraphDBInfoController {
    public static final String MAPPING = "/rest/info";

    @RequestMapping(value={"/license/validate"}, method={RequestMethod.POST})
    public ResponseEntity<ExtendedLicense> getValidLicense(@RequestBody String licenseCode) {
        byte[] licenseBytes = Base64.getDecoder().decode(licenseCode.replaceAll("\\s", ""));
        try {
            License license = LicenseRegistry.getInstance().loadLicenseFromBytes(licenseBytes);
            try {
                LicenseRegistry.getInstance().validateLicenseBasic(license);
            }
            catch (LicenseValidationException e) {
                return ResponseEntity.ok((Object)new InvalidLicense(license, (Exception)((Object)e)));
            }
            return ResponseEntity.ok((Object)new ValidLicense(license));
        }
        catch (IOException e) {
            return ResponseEntity.ok((Object)new ErrorLicense(e));
        }
    }

    @RequestMapping(value={"/license/to-base-64"}, method={RequestMethod.POST})
    public ResponseEntity<String> readLicenseFile(@RequestParam(value="file") MultipartFile licenseFile) {
        try {
            String licenseString = Base64.getEncoder().encodeToString(licenseFile.getBytes());
            return new ResponseEntity((Object)licenseString, (HttpStatusCode)HttpStatus.OK);
        }
        catch (IOException e) {
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @Hidden
    @RequestMapping(value={"/test-error"})
    public void testError(@RequestParam(value="err") String err, HttpServletResponse response) throws Throwable {
        int pos = 0;
        for (char e : err.toCharArray()) {
            switch (e) {
                case '1': {
                    throw new GraphDBWorkbenchException("GraphDBWorkbenchException at " + pos);
                }
                case '2': {
                    throw new HTTPException(500, "HTTPException at " + pos);
                }
                case '3': {
                    response.sendError(400, "sendError at " + pos);
                    break;
                }
                case '4': {
                    response.setContentType("text/plain");
                    for (int i = 0; i < 1000; ++i) {
                        String line = "This is line " + i + " at " + pos + "\n";
                        response.getOutputStream().write(line.getBytes(StandardCharsets.UTF_8));
                    }
                    response.setStatus(200);
                    break;
                }
                case '5': {
                    throw new OutOfMemoryError("Simulated out of memory");
                }
                case '6': {
                    throw new Throwable("Simulated out of memory");
                }
                default: {
                    throw new RuntimeException("Unknown error code at " + pos + ": " + e);
                }
            }
            ++pos;
        }
    }
}

