/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.core.error;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.ontotext.trree.util.ErrorUtil;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ErrorMessage {
    private final String message;
    private final Map<String, ?> details;

    public ErrorMessage(String message, Map<String, ?> details) {
        assert (message != null);
        this.message = ErrorUtil.getSimpleMessage((String)message);
        this.details = details;
    }

    public ErrorMessage(String message) {
        this(message, null);
    }

    public String getMessage() {
        return this.message;
    }

    public Map<String, ?> getDetails() {
        return this.details;
    }

    @JsonIgnore
    public String toPlainText() {
        StringBuilder msg = new StringBuilder();
        msg.append(this.message);
        if (this.details != null && !this.details.isEmpty()) {
            msg.append("\nDetails:");
            for (Map.Entry<String, ?> entry : this.details.entrySet()) {
                msg.append("\n  ");
                msg.append(entry.getKey());
                msg.append(": ");
                msg.append(entry.getValue());
            }
            msg.append("\n");
        }
        return msg.toString();
    }
}

