/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.core.convert;

import com.ontotext.forest.core.convert.RDFStarToReificationWriterFactory;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.eclipse.rdf4j.rio.RDFWriterFactory;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class ReificationConvertingInterceptor
implements HandlerInterceptor {
    private static String CONVERT_HEADER = "X-GraphDB-Convert";
    private static String CONVERT_RDF_STAR_TO_REIFICATION = "rdf*2reification";

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        Object factory;
        String convert = request.getHeader(CONVERT_HEADER);
        if (convert != null && (factory = modelAndView.getModel().get("factory")) instanceof RDFWriterFactory && CONVERT_RDF_STAR_TO_REIFICATION.equalsIgnoreCase(convert)) {
            modelAndView.getModel().put("factory", new RDFStarToReificationWriterFactory((RDFWriterFactory)factory));
        }
        super.postHandle(request, response, handler, modelAndView);
    }
}

