/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.core.convert;

import com.ontotext.forest.core.convert.RDFSPARQLStarResultsJSONWriterFactory;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.impl.ListBindingSet;
import org.eclipse.rdf4j.query.resultio.sparqljson.SPARQLStarResultsJSONWriter;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.WriterConfig;
import org.eclipse.rdf4j.rio.helpers.BooleanRioSetting;

public class RDFSPARQLStarResultsJSONWriter
implements RDFWriter {
    public static final RioSetting<Boolean> INCLUDE_CONTEXT = new BooleanRioSetting("graphdb.table_format.include_context", "Include context", Boolean.FALSE);
    private static final List<String> BINDING_NAMES = Arrays.asList("subject", "predicate", "object");
    private static final List<String> BINDING_NAMES_WITH_CONTEXT = Arrays.asList("subject", "predicate", "object", "context");
    private SPARQLStarResultsJSONWriter sparqlStarResultsJSONWriter;
    private OutputStream outputStream;
    private boolean includeContext;

    public RDFSPARQLStarResultsJSONWriter(OutputStream outputStream) {
        this.outputStream = outputStream;
        this.sparqlStarResultsJSONWriter = new SPARQLStarResultsJSONWriter(outputStream);
    }

    public RDFFormat getRDFFormat() {
        return RDFSPARQLStarResultsJSONWriterFactory.GRAPH_JSON_STAR;
    }

    public RDFWriter setWriterConfig(WriterConfig writerConfig) {
        this.sparqlStarResultsJSONWriter.setWriterConfig(writerConfig);
        return this;
    }

    public WriterConfig getWriterConfig() {
        return this.sparqlStarResultsJSONWriter.getWriterConfig();
    }

    public Collection<RioSetting<?>> getSupportedSettings() {
        return this.sparqlStarResultsJSONWriter.getSupportedSettings();
    }

    public <T> RDFWriter set(RioSetting<T> rioSetting, T t) {
        throw new UnsupportedOperationException(String.format("Cannot set rio settings on %s", this.getClass().getName()));
    }

    public void startRDF() throws RDFHandlerException {
        this.includeContext = (Boolean)this.getWriterConfig().get(INCLUDE_CONTEXT);
        this.sparqlStarResultsJSONWriter.startDocument();
        this.sparqlStarResultsJSONWriter.startQueryResult(this.includeContext ? BINDING_NAMES_WITH_CONTEXT : BINDING_NAMES);
    }

    public void endRDF() throws RDFHandlerException {
        this.sparqlStarResultsJSONWriter.endQueryResult();
    }

    public void handleNamespace(String s, String s1) throws RDFHandlerException {
        this.sparqlStarResultsJSONWriter.handleNamespace(s, s1);
    }

    public void handleStatement(Statement statement) throws RDFHandlerException {
        if (this.includeContext) {
            this.sparqlStarResultsJSONWriter.handleSolution((BindingSet)new ListBindingSet(BINDING_NAMES_WITH_CONTEXT, Arrays.asList(statement.getSubject(), statement.getPredicate(), statement.getObject(), statement.getContext())));
        } else {
            this.sparqlStarResultsJSONWriter.handleSolution((BindingSet)new ListBindingSet(BINDING_NAMES, Arrays.asList(statement.getSubject(), statement.getPredicate(), statement.getObject())));
        }
    }

    public void handleComment(String s) throws RDFHandlerException {
    }
}

