/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.core;

import com.ontotext.forest.core.util.ResourceUtils;
import java.util.Arrays;
import java.util.Collections;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;

@Component(value="graphdbCorsConfigurationSource")
public class GraphDBCorsConfigurationSource
extends UrlBasedCorsConfigurationSource {
    private static final String CORS_ENABLE_PROPERTY = "graphdb.workbench.cors.enable";
    private static final String CORS_ORIGIN_PATTERNS_PROPERTY = "graphdb.workbench.cors.origin";
    private static final String CORS_EXPOSE_HEADERS_PROPERTY = "graphdb.workbench.cors.expose-headers";
    private final ResourceUtils resourceUtils;

    public GraphDBCorsConfigurationSource(ResourceUtils resourceUtils) {
        this.resourceUtils = resourceUtils;
        boolean corsEnabled = Boolean.parseBoolean(String.valueOf(resourceUtils.getProperty(CORS_ENABLE_PROPERTY)));
        if (corsEnabled) {
            this.registerCorsConfiguration("/**", this.getCorsConfiguration());
        }
    }

    private CorsConfiguration getCorsConfiguration() {
        CorsConfiguration config = new CorsConfiguration();
        String originPatternsValue = (String)this.resourceUtils.getProperty(CORS_ORIGIN_PATTERNS_PROPERTY);
        if (StringUtils.hasText((String)originPatternsValue)) {
            config.setAllowedOriginPatterns(Arrays.asList(originPatternsValue.split(",\\s*")));
        } else {
            config.setAllowedOriginPatterns(Collections.emptyList());
        }
        String exposeHeadersValue = (String)this.resourceUtils.getProperty(CORS_EXPOSE_HEADERS_PROPERTY);
        if (StringUtils.hasText((String)exposeHeadersValue)) {
            config.setExposedHeaders(Arrays.asList(exposeHeadersValue.split(",\\s*")));
        }
        config.setAllowedMethods(Arrays.asList("GET", "POST", "PUT", "DELETE", "OPTIONS", "PATCH"));
        config.setAllowedHeaders(Collections.singletonList("*"));
        config.setAllowCredentials(Boolean.valueOf(true));
        config.setMaxAge(Long.valueOf(86400L));
        return config;
    }
}

