/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.resource.serialize;

import com.ontotext.forest.core.convert.RDFSPARQLStarResultsJSONWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.function.Supplier;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFWriterRegistry;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.WriterConfig;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;

public class ResourceMessageConverter
extends AbstractHttpMessageConverter<Model> {
    public ResourceMessageConverter() {
        ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>();
        for (RDFFormat format : RDFWriterRegistry.getInstance().getKeys()) {
            Charset charset = format.getCharset();
            if (charset == null) {
                charset = StandardCharsets.UTF_8;
            }
            for (String type : format.getMIMETypes()) {
                MimeType mimeType = MimeTypeUtils.parseMimeType((String)type);
                mediaTypes.add(new MediaType(mimeType.getType(), mimeType.getSubtype(), charset));
            }
        }
        this.setSupportedMediaTypes(mediaTypes);
    }

    protected boolean supports(Class<?> clazz) {
        return Model.class.isAssignableFrom(clazz);
    }

    protected Model readInternal(Class<? extends Model> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        Supplier<RuntimeException> errorSupplier = () -> new HttpMessageNotReadableException("Unsupported content type " + String.valueOf(inputMessage.getHeaders().getContentType()), inputMessage);
        RDFFormat format = (RDFFormat)Rio.getWriterFormatForMIMEType((String)inputMessage.getHeaders().getContentType().toString()).orElseThrow(errorSupplier);
        try {
            return Rio.parse((InputStream)inputMessage.getBody(), (String)"urn:base:", (RDFFormat)format, (Resource[])new Resource[0]);
        }
        catch (RDFParseException e) {
            throw new HttpMessageNotReadableException(e.getMessage(), (Throwable)e, inputMessage);
        }
    }

    protected void writeInternal(Model t, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        Supplier<RuntimeException> errorSupplier = () -> new HttpMessageNotWritableException("Unsupported content type " + String.valueOf(outputMessage.getHeaders().getContentType()));
        RDFFormat format = (RDFFormat)Rio.getWriterFormatForMIMEType((String)outputMessage.getHeaders().getContentType().toString()).orElseThrow(errorSupplier);
        try {
            WriterConfig config = new WriterConfig();
            config.set(RDFSPARQLStarResultsJSONWriter.INCLUDE_CONTEXT, (Object)true);
            Rio.write((Iterable)t, (OutputStream)outputMessage.getBody(), (RDFFormat)format, (WriterConfig)config);
        }
        catch (RDFHandlerException e) {
            throw new HttpMessageNotWritableException(e.getMessage(), (Throwable)e);
        }
    }
}

