/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.metamodel.storage;

import com.ontotext.metamodel.storage.MalformedSomlException;
import com.ontotext.metamodel.storage.SchemaBindingChanged;
import com.ontotext.metamodel.storage.SchemaEntity;
import com.ontotext.metamodel.storage.SomlAlreadyExistsException;
import com.ontotext.metamodel.storage.SomlNotFoundException;
import com.ontotext.metamodel.storage.SomlSchemaStorageUpdate;
import com.ontotext.metamodel.storage.SomlStoreException;
import com.ontotext.metamodel.storage.UnreachableStoreException;
import com.ontotext.models.SomlSchema;
import com.ontotext.soaas.common.HealthCheckable;
import java.io.Closeable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;

public interface SomlSchemaStorage
extends HealthCheckable,
Closeable {
    public String store(SchemaEntity var1) throws SomlStoreException;

    public String update(String var1, SchemaEntity var2) throws SomlStoreException;

    public Optional<String> get(String var1) throws UnreachableStoreException;

    public Optional<SchemaEntity> getEntity(String var1) throws UnreachableStoreException;

    public Optional<SomlSchema> getParsed(String var1) throws UnreachableStoreException, MalformedSomlException;

    default public Collection<SchemaEntity> getAll() throws UnreachableStoreException {
        return this.getAll(0, 0, null, false, true);
    }

    public Collection<SchemaEntity> getAll(int var1, int var2, Date var3, boolean var4, boolean var5) throws UnreachableStoreException;

    public boolean remove(String var1) throws UnreachableStoreException;

    public boolean delete(String var1) throws UnreachableStoreException;

    public long clear() throws UnreachableStoreException;

    public int size() throws UnreachableStoreException;

    public void registerListener(Consumer<SomlSchemaStorageUpdate> var1);

    public void registerBindListener(Consumer<SchemaBindingChanged> var1);

    public void unregisterListener(Consumer<SomlSchemaStorageUpdate> var1);

    public void unregisterBindListener(Consumer<SchemaBindingChanged> var1);

    public void registerSchemaService(String var1, String var2) throws UnreachableStoreException, SomlNotFoundException;

    public void deregisterSchemaService(String var1, String var2) throws UnreachableStoreException;

    public List<String> getRegisteredSchemaServices(String var1) throws UnreachableStoreException, SomlNotFoundException;

    public void setSchemaExistsStrategy(SchemaExistsStrategy var1);

    public SchemaExistsStrategy getSchemaExistsStrategy();

    public boolean contains(String var1) throws UnreachableStoreException;

    public static class AllowUpsertSchemaStrategy
    implements SchemaExistsStrategy {
        public static final SchemaExistsStrategy INSTANCE = new AllowUpsertSchemaStrategy();

        @Override
        public void existsOnStore(SchemaEntity entity) {
        }

        @Override
        public void notExistsOnUpdate(String id, SchemaEntity entity) {
        }
    }

    public static class DefaultSchemaExistsStrategy
    implements SchemaExistsStrategy {
        public static final SchemaExistsStrategy INSTANCE = new DefaultSchemaExistsStrategy();

        @Override
        public void existsOnStore(SchemaEntity entity) throws SomlStoreException {
            throw new SomlAlreadyExistsException(String.format("Schema with id: %s already exists!", entity.getSchemaId()));
        }

        @Override
        public void notExistsOnUpdate(String id, SchemaEntity entity) throws SomlStoreException {
            throw new SomlNotFoundException(String.format("SOML schema with id: %s is not present in the store", id));
        }
    }

    public static interface SchemaExistsStrategy {
        public void existsOnStore(SchemaEntity var1) throws SomlStoreException;

        public void notExistsOnUpdate(String var1, SchemaEntity var2) throws SomlStoreException;
    }
}

