/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.metamodel.storage;

import com.ontotext.metamodel.storage.AbstractNotificationService;
import com.ontotext.metamodel.storage.AsyncSchemaNotificationStrategy;
import com.ontotext.metamodel.storage.ImmediateSchemaNotificationStrategy;
import com.ontotext.metamodel.storage.SchemaBindingChanged;
import com.ontotext.metamodel.storage.SchemaEntity;
import com.ontotext.metamodel.storage.SchemaEvent;
import com.ontotext.metamodel.storage.SchemaNotificationStrategy;
import com.ontotext.metamodel.storage.SomlSchemaIdStorage;
import com.ontotext.metamodel.storage.SomlSchemaStorage;
import com.ontotext.metamodel.storage.SomlSchemaStorageUpdate;
import com.ontotext.models.SomlSchemaParser;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollingSchemaNotificationService
extends AbstractNotificationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final SomlSchemaStorage schemaStorage;
    private final SomlSchemaIdStorage schemaIdStorage;
    private final int pollIntervalMillis;
    private final boolean async;
    private ScheduledExecutorService service;
    private Poller poller;
    private final SchemaNotificationStrategy manualNotificationStrategy = new ImmediateSchemaNotificationStrategy();

    public PollingSchemaNotificationService(SomlSchemaStorage schemaStorage, SomlSchemaIdStorage schemaIdStorage, int pollIntervalMillis, boolean async) {
        this.schemaStorage = schemaStorage;
        this.schemaIdStorage = schemaIdStorage;
        this.pollIntervalMillis = pollIntervalMillis;
        this.async = async;
    }

    @Override
    public void start() {
        if (this.service != null) {
            throw new IllegalStateException("Notification service already started!");
        }
        LOGGER.info("Starting schema polling at {} ms intervals with {} notifications", (Object)this.pollIntervalMillis, (Object)(this.async ? "async" : "sync"));
        this.service = this.createServiceExecutor();
        this.poller = new Poller(this.schemaStorage, this.schemaIdStorage, this);
        this.service.scheduleAtFixedRate(this.poller, this.pollIntervalMillis, this.pollIntervalMillis, TimeUnit.MILLISECONDS);
    }

    @NotNull
    protected ScheduledExecutorService createServiceExecutor() {
        return Executors.newSingleThreadScheduledExecutor(runnable -> {
            Thread thread = new Thread(runnable, "schema-poller");
            thread.setDaemon(true);
            thread.setPriority(5);
            return thread;
        });
    }

    @Override
    public void stop() {
        try {
            this.getStrategy().stop();
        }
        finally {
            this.poller = null;
            if (this.service != null) {
                this.service.shutdown();
            }
        }
    }

    @Override
    public void notifyListeners(SchemaEvent event) {
        this.updatePoller(event);
        this.manualNotificationStrategy.notifyListeners(event, this.listeners);
    }

    private void updatePoller(SchemaEvent event) {
        if (this.poller != null) {
            if (event instanceof SomlSchemaStorageUpdate) {
                SomlSchemaStorageUpdate updateEvent = (SomlSchemaStorageUpdate)event;
                this.poller.onManualEvent(updateEvent);
            } else if (event instanceof SchemaBindingChanged) {
                SchemaBindingChanged bindingEvent = (SchemaBindingChanged)event;
                this.poller.onManualEvent(bindingEvent);
            }
        }
    }

    void checkForChangesNow() {
        if (this.poller != null) {
            this.poller.checkForChanges();
        }
    }

    private void notifyListenersFromPoller(SchemaEvent event) {
        super.notifyListeners(event);
    }

    @Override
    @NotNull
    protected SchemaNotificationStrategy getDefaultStrategy() {
        if (this.async) {
            return new AsyncSchemaNotificationStrategy();
        }
        return new ImmediateSchemaNotificationStrategy();
    }

    static String eventToString(SomlSchemaStorageUpdate event) {
        String soml = event.getSoml();
        String id = null;
        String checkSum = null;
        if (soml != null) {
            id = SomlSchemaParser.getId((String)soml);
            checkSum = DigestUtils.sha1Hex((String)soml);
        }
        return String.format("%s: %s [%s]", new Object[]{event.getType(), id, checkSum});
    }

    private static class Poller
    implements Runnable {
        private static final String INITIAL = "%initial%";
        private static final String NOT_BOUND = "%not_bound%";
        private final SomlSchemaStorage schemaStorage;
        private final PollerState state = new PollerState();
        private boolean initialized;
        private final SomlSchemaIdStorage schemaIdStorage;
        private final PollingSchemaNotificationService notificationService;
        private Long lastChecked;
        private final AtomicBoolean active = new AtomicBoolean(false);
        private int failureCount = 0;
        private int bindFailureCount = 0;
        private String lastBoundSchema = "%initial%";
        private final Set<SomlSchemaStorageUpdate> manualEvents = new CopyOnWriteArraySet<SomlSchemaStorageUpdate>();

        private Poller(SomlSchemaStorage schemaStorage, SomlSchemaIdStorage schemaIdStorage, PollingSchemaNotificationService notificationService) {
            this.schemaStorage = schemaStorage;
            this.schemaIdStorage = schemaIdStorage;
            this.notificationService = notificationService;
        }

        @Override
        public void run() {
            this.checkForChanges();
        }

        private void checkForChanges() {
            if (!this.active.compareAndSet(false, true)) {
                LOGGER.debug("Schema poll skipped due to already active task");
                return;
            }
            try {
                try {
                    Collection<SchemaEntity> allSchemas = this.getSchemaChanges();
                    if (allSchemas.isEmpty()) {
                        return;
                    }
                    this.processChanges(allSchemas);
                }
                finally {
                    this.processBoundSchema();
                }
            }
            finally {
                this.initialized = true;
                this.active.compareAndSet(true, false);
            }
        }

        private void processBoundSchema() {
            String currentState;
            block5: {
                currentState = this.lastBoundSchema;
                try {
                    Optional<String> id = this.schemaIdStorage.getId();
                    this.lastBoundSchema = id.orElse(NOT_BOUND);
                    if (this.bindFailureCount > 0) {
                        LOGGER.info("Connection to the schema store has been restored");
                    }
                    this.bindFailureCount = 0;
                }
                catch (Exception ex) {
                    this.bindFailureCount = this.bindFailureCount > 5 ? 1 : ++this.bindFailureCount;
                    if (this.bindFailureCount != 1) break block5;
                    LOGGER.warn("Could not retrieve the bound schema id: {}", (Object)ex.getMessage());
                }
            }
            if (Objects.equals(currentState, this.lastBoundSchema)) {
                return;
            }
            boolean eventAccepted = NOT_BOUND.equals(this.lastBoundSchema) ? this.sendEvent(new SchemaBindingChanged(null, false)) : this.sendEvent(new SchemaBindingChanged(this.lastBoundSchema, false));
            if (!eventAccepted) {
                this.lastBoundSchema = currentState;
            }
        }

        private Collection<SchemaEntity> getSchemaChanges() {
            try {
                Date lastNownTime = null;
                if (this.lastChecked != null) {
                    lastNownTime = new Date(this.lastChecked);
                }
                Collection<SchemaEntity> allSchemas = this.schemaStorage.getAll(0, 0, lastNownTime, true, true);
                this.lastChecked = allSchemas.stream().map(SchemaEntity::getLastModified).filter(Objects::nonNull).max(Long::compareTo).orElse(this.lastChecked);
                if (this.failureCount > 0) {
                    LOGGER.info("Connection to the schema store has been restored");
                }
                this.failureCount = 0;
                return allSchemas;
            }
            catch (Exception ex) {
                this.failureCount = this.failureCount > 5 ? 1 : ++this.failureCount;
                if (this.failureCount == 1) {
                    LOGGER.warn("Could not retrieve the stored schemas..: {}", (Object)ex.getMessage());
                }
                return Collections.emptyList();
            }
        }

        private void processChanges(Collection<SchemaEntity> allSchemas) {
            this.state.prepareForProcessing();
            for (SchemaEntity schema : allSchemas) {
                this.state.computeOperation(schema);
            }
            List<SomlSchemaStorageUpdate> updates = this.state.completeProcessing();
            if (this.initialized) {
                boolean removed;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Events to distribute: \n{}", (Object)updates.stream().map(PollingSchemaNotificationService::eventToString).collect(Collectors.joining(",\n\t", "[\n\t", "\n]")));
                }
                if (removed = updates.removeAll(this.manualEvents)) {
                    this.manualEvents.clear();
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Events to distribute after removing manual events: \n{}", (Object)updates.stream().map(PollingSchemaNotificationService::eventToString).collect(Collectors.joining(",\n\t", "[\n\t", "\n]")));
                    }
                }
                updates.sort(Comparator.comparing(SomlSchemaStorageUpdate::getType));
                updates.forEach(this::sendEvent);
            }
        }

        private void sendEvent(SomlSchemaStorageUpdate event) {
            try {
                this.notificationService.notifyListenersFromPoller(event);
            }
            catch (Exception ex) {
                LOGGER.warn("Schema observer failed during operation handling of {} with: {}", new Object[]{event.getType(), ex.getMessage(), ex});
            }
        }

        private boolean sendEvent(SchemaBindingChanged event) {
            try {
                this.notificationService.notifyListenersFromPoller(event);
                return true;
            }
            catch (Exception ex) {
                LOGGER.warn("Schema observer failed during operation handling of {} with: {}", new Object[]{event.getClass(), ex.getMessage(), ex});
                return false;
            }
        }

        public void onManualEvent(SomlSchemaStorageUpdate event) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Registered manual event: \n{}", (Object)PollingSchemaNotificationService.eventToString(event));
            }
            this.manualEvents.add(event);
        }

        public void onManualEvent(SchemaBindingChanged event) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Registered manual bind event: \n{}", (Object)event.getSchemaId());
            }
            this.lastBoundSchema = Objects.requireNonNullElse(event.getSchemaId(), NOT_BOUND);
        }
    }

    private static class StateEntry {
        private String id;
        private String schemaId;
        private String schema;
        private Set<String> activeServices = new HashSet<String>(8);

        private StateEntry() {
        }

        public StateEntry copy() {
            StateEntry copy = new StateEntry();
            copy.id = this.id;
            copy.schemaId = this.schemaId;
            copy.schema = this.schema;
            copy.activeServices = new HashSet<String>(this.activeServices);
            return copy;
        }
    }

    private static class PollerState {
        private final Map<String, StateEntry> schemas = new HashMap<String, StateEntry>();
        private Map<String, StateEntry> workingSchemaState;
        List<SomlSchemaStorageUpdate> updates;

        private PollerState() {
        }

        public void prepareForProcessing() {
            this.workingSchemaState = new HashMap<String, StateEntry>(Math.min(16, this.schemas.size()));
            this.schemas.forEach((key, stateEntry) -> this.workingSchemaState.put((String)key, stateEntry.copy()));
            this.updates = new LinkedList<SomlSchemaStorageUpdate>();
        }

        public void computeOperation(SchemaEntity entity) {
            StateEntry entry = this.workingSchemaState.remove(entity.getId());
            LOGGER.debug("Processing entity: {}-{}", (Object)entity.getId(), (Object)entity.getSchemaId());
            if (entry == null) {
                if (entity.getOriginalDefinition() != null) {
                    this.onSchemaAdded(entity);
                }
            } else if (entity.getOriginalDefinition() == null) {
                this.onDeletedSchema(entity, entry);
            } else {
                this.onSchemaChanged(entity, entry);
            }
        }

        private void onDeletedSchema(SchemaEntity entity, StateEntry entry) {
            LOGGER.debug("Detected schema has been deleted: {}-{}", (Object)entity.getId(), (Object)entity.getSchemaId());
            this.schemas.remove(entity.getId());
            if (!entry.activeServices.isEmpty()) {
                this.addNotification(entry.schema, SomlSchemaStorageUpdate.Type.REMOVE_SERVICE);
            }
            this.addDeleteNotification(entry.schemaId);
        }

        private void onSchemaAdded(SchemaEntity entity) {
            LOGGER.debug("Detected new schema has been added: {}-{}", (Object)entity.getId(), (Object)entity.getSchemaId());
            StateEntry entry = new StateEntry();
            entry.schema = entity.getOriginalDefinition();
            entry.id = entity.getId();
            entry.schemaId = entity.getSchemaId();
            entry.activeServices = new HashSet<String>(entity.getServiceAddresses());
            this.schemas.put(entity.getId(), entry);
            this.addNotification(entity.getOriginalDefinition(), SomlSchemaStorageUpdate.Type.INSERT);
            if (!entry.activeServices.isEmpty()) {
                this.addNotification(entity.getOriginalDefinition(), SomlSchemaStorageUpdate.Type.ADD_SERVICE);
            }
        }

        private void onSchemaChanged(SchemaEntity entity, StateEntry entry) {
            LOGGER.debug("Detected new schema has been updated: {}-{}", (Object)entity.getId(), (Object)entity.getSchemaId());
            String schema = entity.getOriginalDefinition();
            if (!Objects.equals(schema, entry.schema)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Schema changed from: {} to {}", (Object)DigestUtils.sha1Hex((String)entry.schema), (Object)DigestUtils.sha1Hex((String)schema));
                }
                entry.schema = schema;
                this.addNotification(schema, SomlSchemaStorageUpdate.Type.UPDATE);
            }
            HashSet<String> newServices = new HashSet<String>(entity.getServiceAddresses());
            if (entry.activeServices.isEmpty()) {
                if (!newServices.isEmpty()) {
                    entry.activeServices.addAll(newServices);
                    LOGGER.debug("Detected new service has been bound: {}-{}:{}", new Object[]{entity.getId(), entity.getSchemaId(), newServices});
                    this.addNotification(schema, SomlSchemaStorageUpdate.Type.ADD_SERVICE);
                }
            } else if (!newServices.isEmpty()) {
                HashSet<String> copy = new HashSet<String>(entry.activeServices);
                copy.removeAll(newServices);
                if (!copy.isEmpty()) {
                    LOGGER.debug("Detected service has been removed: {}-{}:{}", new Object[]{entity.getId(), entity.getSchemaId(), copy});
                    this.addNotification(schema, SomlSchemaStorageUpdate.Type.REMOVE_SERVICE);
                }
                newServices.removeAll(entry.activeServices);
                if (!newServices.isEmpty()) {
                    LOGGER.debug("Detected new service has been added: {}-{}:{}", new Object[]{entity.getId(), entity.getSchemaId(), newServices});
                    this.addNotification(schema, SomlSchemaStorageUpdate.Type.ADD_SERVICE);
                }
                entry.activeServices.removeAll(copy);
                entry.activeServices.addAll(newServices);
            } else {
                LOGGER.debug("Detected service has been removed: {}-{}:{}", new Object[]{entity.getId(), entity.getSchemaId(), newServices});
                this.addNotification(schema, SomlSchemaStorageUpdate.Type.REMOVE_SERVICE);
                entry.activeServices.clear();
            }
            this.schemas.put(entity.getId(), entry);
        }

        private void addNotification(String schema, SomlSchemaStorageUpdate.Type type) {
            this.updates.add(new SomlSchemaStorageUpdate(SomlSchemaParser.getId((String)schema), schema, type));
        }

        private void addDeleteNotification(String id) {
            this.updates.add(new SomlSchemaStorageUpdate(id, null, SomlSchemaStorageUpdate.Type.DELETE));
        }

        public List<SomlSchemaStorageUpdate> completeProcessing() {
            this.workingSchemaState.clear();
            this.workingSchemaState = null;
            return this.updates;
        }
    }
}

