/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.metamodel.storage;

import com.ontotext.metamodel.storage.ImmediateSchemaNotificationStrategy;
import com.ontotext.metamodel.storage.SchemaEvent;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;

public class AsyncSchemaNotificationStrategy
extends ImmediateSchemaNotificationStrategy {
    private ExecutorService executorService;

    @Override
    public void notifyListeners(SchemaEvent event, Collection<Consumer<SchemaEvent>> listeners) {
        this.getExecutor().submit(() -> super.notifyListeners(event, listeners));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutorService getExecutor() {
        if (this.executorService == null) {
            AsyncSchemaNotificationStrategy asyncSchemaNotificationStrategy = this;
            synchronized (asyncSchemaNotificationStrategy) {
                if (this.executorService != null) {
                    return this.executorService;
                }
                this.executorService = Executors.newSingleThreadExecutor(runnable -> {
                    Thread thread = new Thread(runnable, "schema-notifications");
                    thread.setDaemon(true);
                    thread.setPriority(5);
                    return thread;
                });
            }
        }
        return this.executorService;
    }

    @Override
    public void stop() {
        if (this.executorService != null) {
            this.executorService.shutdown();
            this.executorService = null;
        }
    }
}

