/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.metamodel.storage;

import com.ontotext.metamodel.storage.ImmediateSchemaNotificationStrategy;
import com.ontotext.metamodel.storage.SchemaBindingChanged;
import com.ontotext.metamodel.storage.SchemaEvent;
import com.ontotext.metamodel.storage.SchemaNotificationService;
import com.ontotext.metamodel.storage.SchemaNotificationStrategy;
import com.ontotext.metamodel.storage.SomlSchemaStorageUpdate;
import com.ontotext.soaas.common.Resettable;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractNotificationService
implements SchemaNotificationService,
Resettable {
    protected final Set<Consumer<SchemaEvent>> listeners = new CopyOnWriteArraySet<Consumer<SchemaEvent>>();
    private SchemaNotificationStrategy strategy;

    @Override
    public void setNotificationStrategy(SchemaNotificationStrategy strategy) {
        this.strategy = strategy;
    }

    @Override
    public SchemaNotificationStrategy getStrategy() {
        if (this.strategy == null) {
            this.strategy = this.getDefaultStrategy();
        }
        return this.strategy;
    }

    @NotNull
    protected SchemaNotificationStrategy getDefaultStrategy() {
        return new ImmediateSchemaNotificationStrategy();
    }

    @Override
    public void registerListener(Consumer<SomlSchemaStorageUpdate> consumer) {
        this.listeners.add(new SchemaEventListenerDelegate(consumer, null));
    }

    @Override
    public void registerBindListener(Consumer<SchemaBindingChanged> consumer) {
        this.listeners.add(new SchemaEventListenerDelegate(null, consumer));
    }

    @Override
    public void unregisterListener(Consumer<SomlSchemaStorageUpdate> consumer) {
        this.listeners.remove(new SchemaEventListenerDelegate(consumer, null));
    }

    @Override
    public void unregisterBindListener(Consumer<SchemaBindingChanged> consumer) {
        this.listeners.remove(new SchemaEventListenerDelegate(null, consumer));
    }

    @Override
    public void notifyListeners(SchemaEvent event) {
        this.getStrategy().notifyListeners(event, this.listeners);
    }

    public void reset() {
        this.listeners.clear();
    }

    private static class SchemaEventListenerDelegate
    implements Consumer<SchemaEvent> {
        private final Consumer<SomlSchemaStorageUpdate> storageUpdateConsumer;
        private final Consumer<SchemaBindingChanged> bindingChangedConsumer;

        SchemaEventListenerDelegate(Consumer<SomlSchemaStorageUpdate> storageUpdateConsumer, Consumer<SchemaBindingChanged> bindingChangedConsumer) {
            this.storageUpdateConsumer = storageUpdateConsumer;
            this.bindingChangedConsumer = bindingChangedConsumer;
        }

        @Override
        public void accept(SchemaEvent event) {
            if (this.storageUpdateConsumer != null && event instanceof SomlSchemaStorageUpdate) {
                this.storageUpdateConsumer.accept((SomlSchemaStorageUpdate)event);
            }
            if (this.bindingChangedConsumer != null && event instanceof SchemaBindingChanged) {
                this.bindingChangedConsumer.accept((SchemaBindingChanged)event);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof SchemaEventListenerDelegate)) {
                return false;
            }
            SchemaEventListenerDelegate that = (SchemaEventListenerDelegate)obj;
            return Objects.equals(this.storageUpdateConsumer, that.storageUpdateConsumer) && Objects.equals(this.bindingChangedConsumer, that.bindingChangedConsumer);
        }

        public int hashCode() {
            return Objects.hash(this.storageUpdateConsumer, this.bindingChangedConsumer);
        }
    }
}

