/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.metamodel;

import com.ontotext.metamodel.BoundServiceState;
import com.ontotext.metamodel.SchemaUpdateConsumer;
import com.ontotext.metamodel.storage.SomlStoreException;
import com.ontotext.metamodel.storage.UnreachableStoreException;
import com.ontotext.models.ShaclSchema;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.soaas.common.HealthCheckable;
import graphql.schema.GraphQLSchema;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;

public interface SomlSchemaManager
extends HealthCheckable,
BoundServiceState {
    public SchemaInfo create(String var1) throws SomlStoreException;

    public SchemaInfo update(String var1, String var2) throws SomlStoreException;

    public boolean bind(String var1) throws SomlStoreException;

    public Collection<String> getAll() throws UnreachableStoreException;

    public Collection<String> getAll(int var1, int var2) throws UnreachableStoreException;

    public Optional<String> get(String var1) throws UnreachableStoreException;

    public boolean contains(String var1) throws UnreachableStoreException;

    public boolean remove(String var1) throws UnreachableStoreException;

    public void clearShaclSchema();

    public void setShaclTransactionMode(Boolean var1);

    public boolean getShaclTransactionMode();

    public int size() throws UnreachableStoreException;

    @Override
    public GraphQLSchema getGraphQlSchema();

    @Override
    public SomlSchema getSomlSchema();

    @Override
    public ShaclSchema getShaclSchema();

    @Deprecated
    public Object getJsonLdFrame(String var1);

    @Deprecated
    public Map<String, Object> getJsonLdContext();

    public void reload();

    public void registerSchemaCreateListener(SchemaUpdateConsumer var1);

    public void registerSchemaChangeListener(SchemaUpdateConsumer var1);

    public void registerSchemaBindListener(SchemaUpdateConsumer var1);

    public void registerSchemaRemovedListener(SchemaUpdateConsumer var1);

    public Pair<OperationResponse, SomlSchema> validateSchema(String var1);

    public Pair<OperationResponse, SomlSchema> validateSchema(String var1, boolean var2);

    public void validateSchemaBinding(SomlSchema var1);

    public boolean hasBoundSchema() throws UnreachableStoreException;

    public ShaclSchema revalidateShacl();

    public ShaclSchema rebindShacl();

    public SomlSchemaManager useUnrestricted();

    public boolean rebindService() throws UnreachableStoreException;

    public static class SchemaInfo {
        private final String schemaId;
        private Collection<Serializable> messages = Collections.emptyList();
        private String previousSchema;

        private SchemaInfo(String schemaId) {
            this.schemaId = schemaId;
        }

        static SchemaInfo create(String schemaId) {
            return new SchemaInfo(schemaId);
        }

        public String getSchemaId() {
            return this.schemaId;
        }

        public SchemaInfo setMessages(Collection<Serializable> messages) {
            this.messages = messages;
            return this;
        }

        public Collection<Serializable> getMessages() {
            return this.messages;
        }

        public SchemaInfo setPreviousSchema(String previousSchema) {
            this.previousSchema = previousSchema;
            return this;
        }

        public String getPreviousSchema() {
            return this.previousSchema;
        }
    }
}

