/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.metamodel;

import com.ontotext.metamodel.storage.SomlSchemaIdStorage;
import com.ontotext.metamodel.storage.UnreachableStoreException;
import com.ontotext.models.ErrorMessages;
import com.ontotext.soaas.common.HealthCheckable;
import com.ontotext.soaas.common.HealthResult;
import com.ontotext.soaas.common.Resettable;
import com.ontotext.soaas.common.logging.Loggers;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;

public class SomlSchemaIdManager
implements Resettable,
HealthCheckable {
    private static final Logger LOGGER = Loggers.getSomlLogger();
    private final SomlSchemaIdStorage idStorage;
    private AtomicReference<String> currentId = new AtomicReference();
    private Lock lock = new ReentrantLock();

    public SomlSchemaIdManager(SomlSchemaIdStorage idStorage) {
        this.idStorage = idStorage;
    }

    public Optional<String> getId() throws UnreachableStoreException {
        return Optional.ofNullable(this.getInternal());
    }

    public boolean setId(String id) throws UnreachableStoreException {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException(ErrorMessages.get((String)"schema.id.empty.null"));
        }
        Optional<String> current = this.getId();
        if (current.isPresent() && current.get().equals(id)) {
            LOGGER.trace("Setting id: {}, already set", (Object)id);
            return false;
        }
        this.lock.lock();
        try {
            LOGGER.trace("Setting id: {}, to storage", (Object)id);
            this.idStorage.setId(id);
            this.currentId.set(id);
            LOGGER.trace("Setting id: {}, to storage completed", (Object)id);
        }
        finally {
            this.lock.unlock();
        }
        return true;
    }

    private String getInternal() throws UnreachableStoreException {
        if (this.currentId.get() == null) {
            LOGGER.trace("Getting id from storage");
            this.lockOrFail();
            try {
                this.currentId.set(this.idStorage.getId().orElse(null));
                LOGGER.trace("Getting id from storage {}", (Object)this.currentId.get());
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.currentId.get();
    }

    private void lockOrFail() throws UnreachableStoreException {
        try {
            if (!this.lock.tryLock(5L, TimeUnit.SECONDS)) {
                throw new UnreachableStoreException("Could not load bound id schema in time");
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
    }

    public void clear() throws UnreachableStoreException {
        this.lock.lock();
        try {
            LOGGER.trace("Clearing bound schema {}", (Object)this.currentId.get());
            this.currentId.set(null);
            this.idStorage.setId(null);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void reset() {
        this.lock.lock();
        try {
            this.currentId.set(null);
        }
        finally {
            this.lock.unlock();
        }
    }

    public HealthResult runHealthCheck() {
        HealthResult result = this.idStorage.runHealthCheck();
        if (!result.isHealth() && this.currentId.get() != null) {
            result.setStatus(HealthResult.Status.YELLOW);
            result.setMessage("Bound schema id loaded, but found store problems: " + result.getMessage());
        }
        return result;
    }
}

