/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.metamodel;

import com.ontotext.metamodel.MinimalSomlSchemaManagerMonitor;
import com.ontotext.metamodel.SomlSchemaManager;
import com.ontotext.metamodel.storage.UnreachableStoreException;
import com.ontotext.models.ShaclSchema;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.soaas.common.HealthResult;
import graphql.schema.GraphQLSchema;
import org.apache.commons.lang3.tuple.Pair;

public class FullSomlSchemaManagerMonitor
extends MinimalSomlSchemaManagerMonitor {
    public FullSomlSchemaManagerMonitor(SomlSchemaManager delegate) {
        super(delegate);
    }

    @Override
    public boolean contains(String id) throws UnreachableStoreException {
        return this.monitorWithEx(id, MinimalSomlSchemaManagerMonitor.Operations.CONTAINS, () -> this.delegate.contains(id));
    }

    @Override
    public void clearShaclSchema() {
        this.monitor(null, MinimalSomlSchemaManagerMonitor.Operations.CLEAR_SHACL, this.delegate::clearShaclSchema);
    }

    @Override
    public GraphQLSchema getGraphQlSchema() {
        return this.monitor(null, MinimalSomlSchemaManagerMonitor.Operations.GET_GRAPHQL, this.delegate::getGraphQlSchema);
    }

    @Override
    public SomlSchema getSomlSchema() {
        return this.monitor(null, MinimalSomlSchemaManagerMonitor.Operations.GET_SOML, this.delegate::getSomlSchema);
    }

    @Override
    public ShaclSchema getShaclSchema() {
        return this.monitor(null, MinimalSomlSchemaManagerMonitor.Operations.GET_SHACL, this.delegate::getShaclSchema);
    }

    @Override
    public void reload() {
        this.monitor(null, MinimalSomlSchemaManagerMonitor.Operations.RELOAD, this.delegate::reload);
    }

    @Override
    public Pair<OperationResponse, SomlSchema> validateSchema(String schema) {
        return this.monitor(this.extractId(schema), MinimalSomlSchemaManagerMonitor.Operations.VALIDATE, () -> this.delegate.validateSchema(schema));
    }

    @Override
    public Pair<OperationResponse, SomlSchema> validateSchema(String schema, boolean strict) {
        return this.monitor(this.extractId(schema), MinimalSomlSchemaManagerMonitor.Operations.VALIDATE_STRICT, () -> this.delegate.validateSchema(schema, strict));
    }

    @Override
    public void validateSchemaBinding(SomlSchema somlSchema) {
        this.monitor(somlSchema.getId(), MinimalSomlSchemaManagerMonitor.Operations.VALIDATE_GRAPHQL, () -> this.delegate.validateSchemaBinding(somlSchema));
    }

    @Override
    public ShaclSchema revalidateShacl() {
        return this.monitor(null, MinimalSomlSchemaManagerMonitor.Operations.VALIDATE_SHACL, this.delegate::revalidateShacl);
    }

    @Override
    public ShaclSchema rebindShacl() {
        return this.monitor(null, MinimalSomlSchemaManagerMonitor.Operations.REBIND_SHACL, this.delegate::rebindShacl);
    }

    @Override
    public HealthResult runHealthCheck() {
        return this.monitor(null, MinimalSomlSchemaManagerMonitor.Operations.HEALTH, () -> ((SomlSchemaManager)this.delegate).runHealthCheck());
    }

    @Override
    public boolean rebindService() throws UnreachableStoreException {
        return this.monitorWithEx(null, MinimalSomlSchemaManagerMonitor.Operations.REBIND_SERVICE, this.delegate::rebindService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void monitor(String id, MinimalSomlSchemaManagerMonitor.Operations op, Runnable actualOp) {
        String key = this.operationBegin(id, op);
        try {
            actualOp.run();
        }
        finally {
            this.operationEnd(key);
        }
    }
}

