/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform.owl2soml;

import com.ontotext.platform.owl2soml.BaseDataAccess;
import com.ontotext.platform.owl2soml.Namespaces;
import com.ontotext.platform.owl2soml.Properties;
import com.ontotext.platform.owl2soml.SomlOntology;
import com.ontotext.platform.owl2soml.Utils;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.model.vocabulary.XSD;

public abstract class ShaclPathResolver {
    protected final Namespaces namespaces;
    protected boolean complexPath;
    protected boolean inversePath;
    protected boolean restrictivePath;
    protected boolean templatePath;
    protected String inverseAlias;

    protected ShaclPathResolver(Namespaces namespaces) {
        this.namespaces = namespaces;
    }

    public void resolve(Properties.Property property, Resource shaclId) {
        this.resolve(shaclId, property::setRdfPropIri).ifPresent(property::setRdfProp);
        property.setComplexPath(this.complexPath);
        property.setInversePath(this.inversePath);
        property.setInverseAlias(this.inverseAlias);
        property.setRestrictive(this.restrictivePath);
        property.setSparqlTemplate(this.templatePath);
    }

    private Optional<String> resolve(Resource shaclId, Consumer<IRI> fixedIriSetter) {
        Value path = this.getPath(shaclId);
        if (path != null) {
            String pathValue = this.resolveShaclPathInt(path, fixedIriSetter);
            if (this.isComplexPath(pathValue)) {
                if (this.isInversePath(pathValue)) {
                    this.inversePath = true;
                    this.inverseAlias = pathValue.substring(1);
                    pathValue = null;
                } else if (this.templatePath) {
                    this.complexPath = true;
                } else {
                    pathValue = this.toSparqlTemplate(pathValue);
                    this.complexPath = true;
                }
            }
            return Optional.ofNullable(pathValue);
        }
        return Optional.empty();
    }

    protected abstract Value getPath(Resource var1);

    private String resolveShaclPathInt(Value path) {
        return this.resolveShaclPathInt(path, notNeeded -> {});
    }

    private String resolveShaclPathInt(Value path, Consumer<IRI> fixedIriSetter) {
        Literal literal;
        if (path instanceof IRI) {
            IRI iri = (IRI)path;
            fixedIriSetter.accept(iri);
            return this.namespaces.shortIri(path.stringValue());
        }
        if (path instanceof BNode) {
            BNode bnode = (BNode)path;
            List<Value> values = this.expandList(path);
            if (values.isEmpty()) {
                return "";
            }
            if (values.size() == 1 && values.getFirst().equals((Object)path)) {
                return this.getInversePath(bnode).or(() -> this.checkForSparqlTemplate(bnode)).or(() -> this.getAlternativePath(bnode)).or(() -> this.getVariableLenthPath(bnode, SHACL.ZERO_OR_MORE_PATH, "*")).or(() -> this.getVariableLenthPath(bnode, SHACL.ONE_OR_MORE_PATH, "+")).or(() -> this.getVariableLenthPath(bnode, SHACL.ZERO_OR_ONE_PATH, "?")).orElseThrow();
            }
            return values.stream().map(this::resolveShaclPathInt).filter(StringUtils::isNotEmpty).collect(Collectors.joining("/"));
        }
        if (path instanceof Literal && XSD.STRING.equals((Object)(literal = (Literal)path).getDatatype())) {
            this.templatePath = true;
            return literal.stringValue();
        }
        throw new IllegalArgumentException("Property path should be an IRI, String Literal or BNode: " + String.valueOf(path));
    }

    private Optional<String> checkForSparqlTemplate(BNode bnode) {
        Optional<Value> template = this.getFirstObject((Resource)bnode, SomlOntology.SPARQL_TEMPLATE);
        if (template.isPresent()) {
            this.restrictivePath = this.getFirstObject((Resource)bnode, SomlOntology.RESTRICTIVE).filter(Literal.class::isInstance).map(Literal.class::cast).filter(Literal::booleanValue).isPresent();
            this.templatePath = true;
            return template.map(Value::stringValue);
        }
        return Optional.empty();
    }

    protected List<Value> expandList(Value path) {
        return Utils.expandList(path, this::getFirstObject);
    }

    private String toSparqlTemplate(String pathValue) {
        if (pathValue.startsWith("<") && pathValue.endsWith(">") && !pathValue.contains(" ")) {
            return pathValue;
        }
        return "?_subject " + pathValue + " ?_value";
    }

    private Optional<String> getVariableLenthPath(BNode path, IRI zeroOrMorePath, String suffix) {
        return this.getFirstObject((Resource)path, zeroOrMorePath).map(this::resolveShaclPathInt).filter(StringUtils::isNotEmpty).map(value -> value + suffix);
    }

    protected abstract Optional<Value> getFirstObject(Resource var1, IRI var2);

    private Optional<String> getAlternativePath(BNode path) {
        return this.getFirstObject((Resource)path, SHACL.ALTERNATIVE_PATH).map(listStart -> this.expandList((Value)listStart).stream().map(this::resolveShaclPathInt).filter(StringUtils::isNotEmpty).collect(Collectors.joining("|")));
    }

    private Optional<String> getInversePath(BNode path) {
        return this.getFirstObject((Resource)path, SHACL.INVERSE_PATH).map(this::resolveShaclPathInt).filter(StringUtils::isNotEmpty).map(value -> "^" + value);
    }

    private boolean isComplexPath(String pathValue) {
        return BaseDataAccess.IRI_PATH_SEPARATOR_PATTERN.matcher(pathValue).find();
    }

    private boolean isInversePath(String pathValue) {
        return pathValue.startsWith("^") && !this.isComplexPath(pathValue.substring(1));
    }
}

