/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform.owl2soml;

import com.ontotext.models.Prefixes;
import com.ontotext.models.ScalarType;
import com.ontotext.models.ScalarTypes;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.SomlSchemaParser;
import com.ontotext.platform.owl2soml.Utils;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;

public class Scalars {
    private SomlSchema baseSchema;
    private Map<Set<IRI>, String> defaultUnionTypes;
    private Map<Set<IRI>, ScalarType> customUnionTypes = new LinkedHashMap<Set<IRI>, ScalarType>();
    private Map<IRI, ScalarType> scalarTypeMapping;

    public Map<Set<IRI>, ScalarType> getCustomUnionTypes() {
        return this.customUnionTypes;
    }

    public String getOrCreateDataTypeUnion(Set<IRI> ranges) {
        String unionType = this.getDefaultUnionTypes().get(Set.copyOf(ranges));
        if (unionType != null) {
            return unionType;
        }
        if (ranges.size() == 1) {
            return this.resolveScalarTypeName(ranges.iterator().next());
        }
        return this.customUnionTypes.computeIfAbsent(Set.copyOf(ranges), this::createUnionTypeFor).getName();
    }

    private ScalarType createUnionTypeFor(Set<IRI> ranges) {
        ScalarType newUnionType = new ScalarType();
        List<String> union = ranges.stream().map(this::resolveScalarTypeName).sorted().toList();
        newUnionType.setUnion(union);
        String unionName = StringUtils.uncapitalize((String)union.stream().map(StringUtils::capitalize).collect(Collectors.joining("Or")));
        newUnionType.setName(unionName);
        newUnionType.setGraphql("Literal");
        newUnionType.setDescr(String.join((CharSequence)" or ", union));
        return newUnionType;
    }

    private String resolveScalarTypeName(IRI range) {
        ScalarType scalarType = this.getScalarTypeMapping().get(range);
        if (scalarType != null) {
            return scalarType.getName();
        }
        String type = Utils.getDataTypeForIri(range);
        if (type != null) {
            scalarType = (ScalarType)this.getBaseSchema().getTypes().get((Object)type);
            if (scalarType != null) {
                return scalarType.getName();
            }
            throw new IllegalStateException("The type definition " + type + " does not point to a valid scalar type!");
        }
        throw new IllegalArgumentException("Unsupported datatype " + String.valueOf(range));
    }

    private SomlSchema getBaseSchema() {
        if (this.baseSchema == null) {
            this.baseSchema = SomlSchemaParser.newEmptySchema();
        }
        return this.baseSchema;
    }

    private Map<IRI, ScalarType> getScalarTypeMapping() {
        if (this.scalarTypeMapping == null) {
            SomlSchema schema = this.getBaseSchema();
            ScalarTypes types = schema.getTypes();
            Prefixes prefixes = schema.getPrefixes();
            SimpleValueFactory vf = SimpleValueFactory.getInstance();
            HashSet uniqueTypes = new HashSet();
            this.scalarTypeMapping = types.values().stream().filter(type -> !type.isUnionType() && !type.isEnum()).filter(type -> uniqueTypes.add(type.getRdf())).collect(Collectors.toMap(type -> vf.createIRI(prefixes.toIri(type.getRdf())), Function.identity()));
        }
        return this.scalarTypeMapping;
    }

    private Map<Set<IRI>, String> getDefaultUnionTypes() {
        if (this.defaultUnionTypes == null) {
            SomlSchema schema = this.getBaseSchema();
            ScalarTypes types = schema.getTypes();
            Prefixes prefixes = schema.getPrefixes();
            SimpleValueFactory vf = SimpleValueFactory.getInstance();
            this.defaultUnionTypes = types.values().stream().filter(ScalarType::isUnionType).collect(Collectors.toMap(type -> Set.copyOf(type.getUnionTypes().stream().map(ScalarType::getRdf).map(arg_0 -> ((Prefixes)prefixes).toIri(arg_0)).map(arg_0 -> ((SimpleValueFactory)vf).createIRI(arg_0)).collect(Collectors.toSet())), ScalarType::getName));
        }
        return this.defaultUnionTypes;
    }

    public ScalarType resolveBaseType(String type) {
        return (ScalarType)this.getBaseSchema().getTypes().get((Object)type);
    }

    Optional<Map<String, Object>> toSomlTypes(Set<String> usedRanges) {
        Map<Set<IRI>, ScalarType> customTypes = this.getCustomUnionTypes();
        if (customTypes.isEmpty()) {
            return Optional.empty();
        }
        Map<String, Object> types = this.convertScalarTypeToSoml(customTypes.values(), usedRanges);
        if (types.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(types);
    }

    Map<String, Object> convertScalarTypeToSoml(Collection<ScalarType> scalarTypes, Set<String> usedRanges) {
        List referencedTypes = scalarTypes.stream().filter(sct -> usedRanges == null || usedRanges.contains(sct.getName())).flatMap(type -> type.getUnion().stream()).distinct().toList();
        Map<String, Map> unionTypes = scalarTypes.stream().filter(sct -> usedRanges == null || usedRanges.contains(sct.getName())).collect(Collectors.toMap(ScalarType::getName, this::scalarTypeToMap));
        Map<String, Map> defaultTypes = referencedTypes.stream().map(this::resolveBaseType).collect(Collectors.toMap(ScalarType::getName, this::scalarTypeToMap));
        LinkedHashMap<String, Object> resultScalarTypes = new LinkedHashMap<String, Object>();
        resultScalarTypes.putAll(defaultTypes);
        resultScalarTypes.putAll(unionTypes);
        return resultScalarTypes;
    }

    private Map<String, Object> scalarTypeToMap(ScalarType type) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        Utils.putIfNotNull(result, "rdf", type.getRdf());
        Utils.putIfNotNull(result, "union", type.getUnion());
        Utils.putIfNotNull(result, "graphql", type.getGraphql());
        Utils.putIfNotNull(result, "descr", type.getDescr());
        Utils.putIfNotNull(result, "graphqlExtension", type.isGraphqlExtension());
        return result;
    }

    public boolean isScalarType(String typeName) {
        return this.getBaseSchema().getTypes().isScalarType(typeName);
    }
}

