/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform.owl2soml;

import com.ontotext.models.InvalidSchemaException;
import com.ontotext.models.Prefixes;
import com.ontotext.models.Properties;
import com.ontotext.models.Shapes;
import com.ontotext.models.SomlSchemaParser;
import com.ontotext.models.SpecialPrefixes;
import com.ontotext.platform.owl2soml.Constants;
import com.ontotext.platform.owl2soml.Scalars;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HexFormat;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;

public class Namespaces {
    private static final Pattern SEPARATOR = Pattern.compile("[\\W]+");
    private static final Pattern LAST_SEPARATOR = Pattern.compile("[\\W_]+$");
    private static final Pattern RDF_PREFIX_SEPARATOR_PATTERN = Pattern.compile(":");
    private static final Set<String> FULL_NAME_PROPS = Stream.of("name", "type").collect(Collectors.toSet());
    private static final ValueFactory vf = SimpleValueFactory.getInstance();
    private Map<String, IRI> iriCache = new HashMap<String, IRI>();
    private Scalars scalars;
    private Prefixes prefixes = new Prefixes();
    private SpecialPrefixes specialPrefixes = new SpecialPrefixes();
    private String vocabIri;
    private Pattern vocWithUnderscore;
    private String randomVocPrefix;

    Namespaces(Scalars scalars) {
        this.scalars = scalars;
        this.prefixes.putAll(Constants.PREFIXES);
        this.prefixes.putAll((Map)new SomlSchemaParser().getBaseSchema().getPrefixes());
    }

    public void addNamespace(String prefix, String namespace) {
        if (prefix == null || namespace == null) {
            return;
        }
        this.prefixes.put(prefix, namespace);
    }

    public SpecialPrefixes getSpecialPrefixes() {
        return this.specialPrefixes;
    }

    public Scalars getScalars() {
        return this.scalars;
    }

    String getVocabIri() {
        if (this.vocabIri == null) {
            this.vocabIri = (String)this.prefixes.get(this.prefixes.getVocabPrefix().orElse(null));
        }
        return this.vocabIri;
    }

    Pattern vocPrefixPattern() {
        if (this.vocWithUnderscore == null) {
            this.vocWithUnderscore = Pattern.compile(this.prefixes.getVocabPrefix().orElse("") + ":");
        }
        return this.vocWithUnderscore;
    }

    public IRI iri(String iri) {
        return this.iriCache.computeIfAbsent(iri, key -> vf.createIRI(this.prefixes.toIri(key)));
    }

    public Optional<String> getNamespace(String prefix) {
        return Optional.ofNullable((String)this.prefixes.get((Object)prefix));
    }

    public Optional<String> getPrefix(String namespace) {
        return this.prefixes.resolvePrefix(namespace);
    }

    public String shortIri(String iri) {
        try {
            return this.prefixes.toShortIri(iri);
        }
        catch (InvalidSchemaException ise) {
            return "<" + iri + ">";
        }
    }

    public String propertyLabelToName(String label) {
        return this.modelSafeProperty(StringUtils.uncapitalize((String)label.replaceAll("[\\W]+", "_")));
    }

    public String gqlName(String iriString) {
        String[] split;
        String className;
        if (iriString == null) {
            return null;
        }
        try {
            className = this.prefixes.toModelShortIri(iriString);
            if (className.equals(iriString)) {
                className = this.createGqlNameFromUri(iriString);
            }
        }
        catch (InvalidSchemaException ise) {
            className = this.createGqlNameFromUri(iriString);
        }
        Optional vocabPrefix = this.prefixes.getVocabPrefix();
        if (vocabPrefix.isPresent() && (split = RDF_PREFIX_SEPARATOR_PATTERN.split(className)).length > 1 && !FULL_NAME_PROPS.contains(split[1])) {
            className = this.vocPrefixPattern().matcher(className).replaceFirst("");
        }
        className = Constants.ESCAPE_CHARS.matcher(className).replaceAll("");
        return className;
    }

    public String convertShaclPropertyName(Resource propertyIri, Resource domainIri) {
        if (!(propertyIri instanceof IRI)) {
            return null;
        }
        String propIriString = propertyIri.stringValue();
        String replace = propIriString.replace(domainIri.stringValue(), "");
        if (replace.isEmpty() || replace.length() == propIriString.length()) {
            return null;
        }
        if (!Character.isAlphabetic(replace.charAt(0))) {
            replace = replace.substring(1);
        }
        return this.modelSafeProperty(replace);
    }

    public String modelSafeProperty(String propName, Resource iri) {
        if (propName == null) {
            return null;
        }
        String prop = propName;
        if (!prop.contains(":")) {
            prop = StringUtils.uncapitalize((String)prop);
        }
        if (Properties.PROPS_THAT_USE_VOCAB_PREFIX.contains(prop)) {
            return this.prefixes.getVocabPrefix().orElseGet(() -> (String)this.prefixes.resolvePrefix(iri.stringValue()).orElseThrow()) + ":" + prop;
        }
        if (propName.contains(":")) {
            int idx = propName.indexOf(":");
            String label = propName.substring(idx + 1);
            return propName.substring(0, idx) + ":" + StringUtils.uncapitalize((String)label);
        }
        propName = this.toSafeGqlName(propName);
        return StringUtils.uncapitalize((String)propName);
    }

    public String modelSafeProperty(String propName) {
        if (propName == null) {
            return null;
        }
        if (Properties.PROPS_THAT_USE_VOCAB_PREFIX.contains(propName)) {
            return (String)this.prefixes.getVocabPrefix().orElseThrow() + ":" + propName;
        }
        if (propName.contains(":")) {
            int idx = propName.indexOf(":");
            String label = propName.substring(idx);
            return propName.substring(0, idx) + StringUtils.uncapitalize((String)label);
        }
        propName = this.toSafeGqlName(propName);
        return StringUtils.uncapitalize((String)propName);
    }

    public String modelSafeType(String typeName, Resource iri) {
        if (this.scalars.isScalarType(typeName) || Shapes.isSystemShapeOrInterface((String)typeName)) {
            return this.prefixes.getVocabPrefix().orElseGet(() -> (String)this.prefixes.resolvePrefix(iri.stringValue()).orElseThrow()) + ":" + typeName;
        }
        if (!typeName.contains(":")) {
            return this.toSafeGqlName(typeName);
        }
        return typeName;
    }

    private String createGqlNameFromUri(String iriString) {
        try {
            URI url = new URI(iriString);
            String path = Objects.requireNonNullElseGet(url.getPath(), url::getSchemeSpecificPart);
            path = LAST_SEPARATOR.matcher(path).replaceFirst("");
            String[] split = SEPARATOR.split(path);
            return split[split.length - 1];
        }
        catch (URISyntaxException use) {
            return this.toSafeGqlName(iriString);
        }
    }

    private String toSafeGqlName(String iriString) {
        String gqlName = Arrays.stream(SEPARATOR.split(iriString)).map(StringUtils::capitalize).collect(Collectors.joining());
        while (gqlName.startsWith("_") && gqlName.length() > 1) {
            gqlName = gqlName.substring(1);
        }
        return gqlName;
    }

    void loadNamespaces(Map<String, String> explicitPrefixes) {
        this.prefixes.entrySet().removeIf(entry -> explicitPrefixes.containsValue(entry.getValue()));
        this.prefixes.putAll(explicitPrefixes);
    }

    void expandPrefixes() {
        this.prefixes.expand(SomlSchemaParser.newEmptySchema(), this.specialPrefixes);
    }

    public Prefixes getPrefixes() {
        return this.prefixes;
    }

    public boolean isNoVocabularyOption() {
        return this.randomVocPrefix != null;
    }

    public boolean setVocabularyPrefix(String prefix) {
        String namespace = (String)this.getPrefixes().get((Object)prefix);
        this.setVocabularyPrefix(prefix, namespace);
        return namespace != null;
    }

    public void setVocabularyPrefix(String prefix, String namespace) {
        if (this.randomVocPrefix != null) {
            this.prefixes.remove((Object)this.randomVocPrefix);
            this.randomVocPrefix = null;
        }
        this.getSpecialPrefixes().put("vocab_prefix", prefix);
        this.getSpecialPrefixes().put("vocab_iri", namespace);
    }

    public void setRandomVocabularyPrefix(String id) {
        String pfx = Stream.of("example", "test", "dummy").filter(prefix -> !this.getPrefixes().containsKey(prefix)).findFirst().orElseGet(() -> Namespaces.getRandomSuffix(id));
        String iri = "http://example.com/" + Namespaces.getRandomSuffix(id) + "#";
        this.setVocabularyPrefix(pfx, iri);
        this.addNamespace(pfx, iri);
        this.randomVocPrefix = pfx;
    }

    private static String getRandomSuffix(String identifier) {
        try {
            MessageDigest digest = MessageDigest.getInstance("sha1");
            String hex = HexFormat.of().formatHex(digest.digest(Objects.toString(identifier).getBytes(StandardCharsets.UTF_8)));
            return StringUtils.truncate((String)hex, (int)6);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new IllegalStateException(nsae);
        }
    }

    public boolean isVocabularySet() {
        return this.specialPrefixes.getVocabPrefix().isPresent() && this.specialPrefixes.getVocabIri().isPresent();
    }
}

