/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform.owl2soml;

import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;

public class MultiTypeDef {
    private Set<IRI> dataTypes;
    private Set<IRI> classes;
    private Set<Resource> nodes;

    public boolean isValid() {
        return this.getDataTypes().size() + Objects.requireNonNullElse(this.getClasses(), Set.of()).size() + Objects.requireNonNullElse(this.getNodes(), Set.of()).size() >= 2;
    }

    public Set<IRI> getDataTypes() {
        return Objects.requireNonNullElse(this.dataTypes, Set.of());
    }

    public void addDataType(IRI datatype) {
        if (this.dataTypes == null) {
            this.dataTypes = new LinkedHashSet<IRI>();
        }
        this.dataTypes.add(datatype);
    }

    public Set<IRI> getClasses() {
        return Objects.requireNonNullElse(this.classes, Set.of());
    }

    public void addClass(IRI clazz) {
        if (this.classes == null) {
            this.classes = new LinkedHashSet<IRI>();
        }
        this.classes.add(clazz);
    }

    public Set<Resource> getNodes() {
        return Objects.requireNonNullElse(this.nodes, Set.of());
    }

    public void addNode(Resource clazz) {
        if (this.nodes == null) {
            this.nodes = new LinkedHashSet<Resource>();
        }
        this.nodes.add(clazz);
    }

    public void copyFrom(MultiTypeDef other) {
        other.getNodes().forEach(this::addNode);
        other.getDataTypes().forEach(this::addDataType);
        other.getClasses().forEach(this::addClass);
    }
}

