/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform.owl2soml;

import com.google.common.collect.ImmutableMap;
import com.ontotext.models.Prefixes;
import com.ontotext.models.SpecialPrefixes;
import com.ontotext.platform.owl2soml.SomlOntology;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.DC;
import org.eclipse.rdf4j.model.vocabulary.DCTERMS;
import org.eclipse.rdf4j.model.vocabulary.OWL;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Constants {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"owl2soml");
    private static final ValueFactory vf = SimpleValueFactory.getInstance();
    public static final String STRING = "string";
    public static final String STRING_OR_LANG_STRING = "stringOrLangString";
    public static final String LANG_STRING = "langString";
    public static final String DATE_TIME = "dateTime";
    public static final String DOUBLE = "double";
    public static final String OBJECT = "object";
    public static final String LITERAL = "literal";
    public static final String IRI = "iri";
    public static final String UBOUND_SCHEMA_KEY = "unbound";
    public static final String ROLE_ACTION_WILDCARD = "*";
    public static final String SCALAR_PREFIX = "http://www.ontotext.com/semantic-object/scalars/";
    public static final Set<String> STRING_TYPES = Set.of("string", "langString", "stringOrLangString");
    public static final Map<String, String> PREFIXES = Map.ofEntries(Map.entry("so", "http://www.ontotext.com/semantic-object/"), Map.entry("soScalars", "http://www.ontotext.com/semantic-object/scalars/"), Map.entry("dc", "http://purl.org/dc/elements/1.1/"), Map.entry("dct", "http://purl.org/dc/terms/"), Map.entry("owl", "http://www.w3.org/2002/07/owl#"), Map.entry("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#"), Map.entry("rdfs", "http://www.w3.org/2000/01/rdf-schema#"), Map.entry("schema", "http://schema.org/"), Map.entry("skos", "http://www.w3.org/2004/02/skos/core#"), Map.entry("swc", "http://schema.semantic-web.at/ppt/"), Map.entry("vann", "http://purl.org/vocab/vann/"), Map.entry("xsd", "http://www.w3.org/2001/XMLSchema#"), Map.entry("sh", "http://www.w3.org/ns/shacl#"), Map.entry("graphql", "http://datashapes.org/graphql#"), Map.entry("gala", "http://www.gala-global.org/ontologies/gala#"), Map.entry("dbp", "http://dbpedia.org/ontology/"), Map.entry("m-led", "http://www.m-led.org/ontologies/m-led#"), Map.entry("ma", "http://www.w3.org/ns/ma-ont#"), Map.entry("dash", "http://datashapes.org/dash#"), Map.entry("geo", "http://www.opengis.net/ont/geosparql#"));
    public static final Prefixes DEFAULT_PREFIXES = new Prefixes();
    public static final Map<String, String> IRI_BASED_TYPES;
    public static final Map<String, String> DATATYPES_ONLY;
    public static final Map<String, String> DATATYPES;
    public static final Set<IRI> NO_DATATYPES;
    public static final Set<IRI> CLASSES;
    public static final Set<IRI> NO_CLASSES;
    public static final Set<IRI> PROP_CLASSES;
    public static final Set<IRI> NO_PROPS;
    public static final Set<IRI> LABEL_PROPS;
    public static final Set<IRI> DESCR_PROPS;
    public static final Set<IRI> LANG_PROPS;
    public static final Set<IRI> CREATOR_PROPS;
    public static final Set<IRI> CREATED_PROPS;
    public static final Set<IRI> MODIFIED_PROPS;
    public static final Set<IRI> VERSION_PROPS;
    public static final Pattern VERSION_PATTERN;
    public static final Pattern ESCAPE_CHARS;
    public static final IRI SCHEMA_INVERSE_OF;
    public static final IRI SCHEMA_DOMAIN_INCLUDES;
    public static final IRI SCHEMA_RANGE_INCLUDES;
    public static final IRI SCHEMA_DATA_TYPE;
    public static final IRI SWC_BASE_URL;
    public static final IRI SWC_IDENTIFIER;
    public static final IRI GRAPHQL_SCHEMA;
    public static final IRI GRAPHQL_PUBLIC_CLASS;
    public static final IRI GRAPHQL_PROTECTED_CLASS;
    public static final IRI GRAPHQL_PUBLIC_SHAPE;
    public static final IRI GRAPHQL_PROTECTED_SHAPE;
    public static final IRI GRAPHQL_PUBLIC_NAMESPACE;
    public static final IRI GRAPHQL_PRIVATE_SHAPE;
    public static final IRI GRAPHQL_DEFAULT_PREFIX;
    public static final IRI GRAPHQL_NAME;
    public static final IRI GRAPHQL_IS_INTERFACE;
    public static final IRI GRAPHQL_URI_TEMPLATE;
    public static final IRI DASH_APPLICABLE_TO_CLASS;
    public static final IRI DASH_DATE_OR_DATE_TIME;
    public static final IRI DASH_STRING_OR_LANG_STRING;
    public static final IRI DASH_ABSTRACT;

    private static Set<IRI> setOfIris(String ... args) {
        Set collect = Arrays.stream(args).map(Constants::toIri).collect(Collectors.toCollection(LinkedHashSet::new));
        return Collections.unmodifiableSet(collect);
    }

    private static IRI toIri(String string) {
        return vf.createIRI(DEFAULT_PREFIXES.toIri(string));
    }

    private Constants() {
    }

    static {
        DEFAULT_PREFIXES.putAll(PREFIXES);
        DEFAULT_PREFIXES.expand(null, new SpecialPrefixes());
        IRI_BASED_TYPES = Map.of("schema:URL", IRI, "rdfs:Resource", IRI, "xsd:anyURI", IRI);
        DATATYPES_ONLY = ImmutableMap.builder().put((Object)"xsd:string", (Object)STRING).put((Object)"xsd:double", (Object)DOUBLE).put((Object)"xsd:float", (Object)"float").put((Object)"xsd:boolean", (Object)"boolean").put((Object)"xsd:byte", (Object)"byte").put((Object)"xsd:short", (Object)"short").put((Object)"xsd:int", (Object)"int").put((Object)"xsd:long", (Object)"long").put((Object)"xsd:unsignedLong", (Object)"unsignedLong").put((Object)"xsd:unsignedInt", (Object)"unsignedInt").put((Object)"xsd:unsignedShort", (Object)"unsignedShort").put((Object)"xsd:unsignedByte", (Object)"unsignedByte").put((Object)"xsd:decimal", (Object)"decimal").put((Object)"xsd:integer", (Object)"integer").put((Object)"xsd:positiveInteger", (Object)"positiveInteger").put((Object)"xsd:nonPositiveInteger", (Object)"nonPositiveInteger").put((Object)"xsd:negativeInteger", (Object)"negativeInteger").put((Object)"xsd:nonNegativeInteger", (Object)"nonNegativeInteger").put((Object)"xsd:dateTime", (Object)DATE_TIME).put((Object)"xsd:dateTimeStamp", (Object)"dateTimeStamp").put((Object)"xsd:time", (Object)"time").put((Object)"xsd:date", (Object)"date").put((Object)"xsd:gYear", (Object)"year").put((Object)"xsd:gYearMonth", (Object)"yearMonth").put((Object)"rdfs:Literal", (Object)STRING).put((Object)"rdf:langString", (Object)LANG_STRING).put((Object)"rdf:PlainLiteral", (Object)STRING).put((Object)"schema:Boolean", (Object)"boolean").put((Object)"schema:Date", (Object)"date").put((Object)"schema:DateTime", (Object)DATE_TIME).put((Object)"schema:Float", (Object)DOUBLE).put((Object)"schema:Integer", (Object)"integer").put((Object)"schema:Number", (Object)"decimal").put((Object)"schema:Text", (Object)STRING).put((Object)"schema:Time", (Object)"time").put((Object)"fibo-fnd-dt-fd:CombinedDateTime", (Object)"dateOrYearOrMonth").put((Object)"xsd:duration", (Object)"duration").put((Object)"schema:Duration", (Object)"duration").put((Object)"xsd:dayTimeDuration", (Object)"dayTimeDuration").put((Object)"xsd:yearMonthDuration", (Object)"yearMonthDuration").put((Object)"rdf:HTML", (Object)STRING).put((Object)"rdf:XMLLiteral", (Object)STRING).put((Object)"xsd:anySimpleType", (Object)STRING).put((Object)"dash:DateOrDateTime", (Object)"dateOrDateTime").put((Object)"dash:StringOrLangString", (Object)STRING_OR_LANG_STRING).put((Object)"geo:gmlLiteral", (Object)STRING).put((Object)"geo:wktLiteral", (Object)STRING).put((Object)"geo:geoJSONLiteral", (Object)STRING).put((Object)"geo:kmlLiteral", (Object)STRING).put((Object)"geo:dggsLiteral", (Object)STRING).build();
        DATATYPES = ImmutableMap.builder().putAll(DATATYPES_ONLY).putAll(IRI_BASED_TYPES).build();
        NO_DATATYPES = Constants.setOfIris("xsd:gMonthDay", "xsd:gDay", "xsd:gMonth", "xsd:base64Binary", "xsd:hexBinary", "xsd:QName", "xsd:NOTATION", "xsd:normalizedString", "xsd:token", "xsd:language", "xsd:Name", "xsd:NCName", "xsd:ID", "xsd:IDREF", "xsd:IDREFS", "xsd:ENTITY", "xsd:ENTITIES", "xsd:NMTOKEN", "xsd:NMTOKENS", "owl:rational", "owl:real");
        CLASSES = Set.of(RDFS.CLASS, OWL.CLASS, SHACL.NODE_SHAPE, SomlOntology.TYPE_CLASS);
        NO_CLASSES = Constants.setOfIris("schema:DataType", "owl:Nothing", "owl:Thing", "rdf:List");
        PROP_CLASSES = Constants.setOfIris("rdf:Property", "owl:AnnotationProperty", "owl:DatatypeProperty", "owl:ObjectProperty", "owl:FunctionalProperty", "owl:InverseFunctionalProperty", "owl:ReflexiveProperty", "owl:IrreflexiveProperty", "owl:SymmetricProperty", "owl:AsymmetricProperty", "owl:TransitiveProperty", "so:" + SomlOntology.PROPERTY_CLASS.getLocalName());
        NO_PROPS = Constants.setOfIris("owl:topObjectProperty", "owl:bottomObjectProperty", "owl:topDataProperty", "owl:bottomDataProperty");
        LABEL_PROPS = Constants.setOfIris("rdfs:label", "skos:prefLabel", "dc:title", "dct:title");
        DESCR_PROPS = Constants.setOfIris("rdfs:comment", "skos:definition", "skos:description", "skos:scopeNote", "dc:description", "dct:description", "dbp:abstract", "sh:description", "so:description");
        LANG_PROPS = Set.of(SomlOntology.LANG, DC.LANGUAGE, Constants.toIri("schema:inLanguage"), Constants.toIri("gala:language"), Constants.toIri("m-led:hasLanguage"), Constants.toIri("ma:language"));
        CREATOR_PROPS = Set.of(DC.CREATOR, DCTERMS.CREATOR, SomlOntology.CREATOR);
        CREATED_PROPS = Set.of(DCTERMS.CREATED, SomlOntology.CREATED);
        MODIFIED_PROPS = Set.of(DCTERMS.MODIFIED, SomlOntology.UPDATED);
        VERSION_PROPS = Set.of(OWL.VERSIONINFO, SomlOntology.VERSION_INFO);
        VERSION_PATTERN = Pattern.compile("\\d+(?:\\.\\d+){0,2}(?:-\\w+)?");
        ESCAPE_CHARS = Pattern.compile("[.]");
        SCHEMA_INVERSE_OF = Constants.toIri("schema:inverseOf");
        SCHEMA_DOMAIN_INCLUDES = Constants.toIri("schema:domainIncludes");
        SCHEMA_RANGE_INCLUDES = Constants.toIri("schema:rangeIncludes");
        SCHEMA_DATA_TYPE = Constants.toIri("schema:DataType");
        SWC_BASE_URL = Constants.toIri("swc:BaseUrl");
        SWC_IDENTIFIER = Constants.toIri("swc:identifier");
        GRAPHQL_SCHEMA = Constants.toIri("graphql:Schema");
        GRAPHQL_PUBLIC_CLASS = Constants.toIri("graphql:publicClass");
        GRAPHQL_PROTECTED_CLASS = Constants.toIri("graphql:protectedClass");
        GRAPHQL_PUBLIC_SHAPE = Constants.toIri("graphql:publicShape");
        GRAPHQL_PROTECTED_SHAPE = Constants.toIri("graphql:protectedShape");
        GRAPHQL_PUBLIC_NAMESPACE = Constants.toIri("graphql:publicNamespace");
        GRAPHQL_PRIVATE_SHAPE = Constants.toIri("graphql:privateShape");
        GRAPHQL_DEFAULT_PREFIX = Constants.toIri("graphql:defaultPrefix");
        GRAPHQL_NAME = Constants.toIri("graphql:name");
        GRAPHQL_IS_INTERFACE = Constants.toIri("graphql:isInterface");
        GRAPHQL_URI_TEMPLATE = Constants.toIri("graphql:uriTemplate");
        DASH_APPLICABLE_TO_CLASS = Constants.toIri("dash:applicableToClass");
        DASH_DATE_OR_DATE_TIME = Constants.toIri("dash:DateOrDateTime");
        DASH_STRING_OR_LANG_STRING = Constants.toIri("dash:StringOrLangString");
        DASH_ABSTRACT = Constants.toIri("dash:abstract");
    }
}

