/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.platform.owl2soml;

import com.ontotext.models.ConfigInfo;
import com.ontotext.platform.owl2soml.Constants;
import com.ontotext.platform.owl2soml.DataAccess;
import com.ontotext.platform.owl2soml.SomlOntology;
import com.ontotext.platform.owl2soml.Utils;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.OWL;
import org.jetbrains.annotations.Nullable;

public class Config {
    private final DataAccess data;
    private Set<IRI> names = new LinkedHashSet<IRI>(Set.of(Constants.GRAPHQL_NAME));
    private Set<IRI> labelProps = new LinkedHashSet<IRI>(Constants.LABEL_PROPS);
    private Set<IRI> descriptionProps = new LinkedHashSet<IRI>(Constants.DESCR_PROPS);
    private Set<IRI> ignoredTypes = new LinkedHashSet<IRI>(Constants.NO_DATATYPES);
    private Set<IRI> classes = new LinkedHashSet<IRI>(Constants.CLASSES);
    private Set<IRI> isInterface = new LinkedHashSet<IRI>(Set.of(Constants.GRAPHQL_IS_INTERFACE, Constants.DASH_ABSTRACT));
    private Set<IRI> ignoredClasses = new LinkedHashSet<IRI>(Constants.NO_CLASSES);
    private Set<IRI> propertyClasses = new LinkedHashSet<IRI>(Constants.PROP_CLASSES);
    private Set<IRI> objectPropertyClasses = new LinkedHashSet<IRI>(Set.of(OWL.OBJECTPROPERTY));
    private Set<IRI> dataPropertyClasses = new LinkedHashSet<IRI>(Set.of(OWL.DATATYPEPROPERTY, OWL.ANNOTATIONPROPERTY));
    private Set<IRI> ignoredProperties = new LinkedHashSet<IRI>(Constants.NO_PROPS);
    private Set<IRI> creator = new LinkedHashSet<IRI>(Constants.CREATOR_PROPS);
    private Set<IRI> created = new LinkedHashSet<IRI>(Constants.CREATED_PROPS);
    private Set<IRI> modified = new LinkedHashSet<IRI>(Constants.MODIFIED_PROPS);
    private Set<IRI> version = new LinkedHashSet<IRI>(Constants.VERSION_PROPS);
    private Set<IRI> language = new LinkedHashSet<IRI>(Constants.LANG_PROPS);
    private Set<IRI> dataTypes;
    private Set<IRI> privatePropertiesConfig = new LinkedHashSet<IRI>(Set.of(SomlOntology.PRIVATE_PROPERTY));
    private Set<IRI> protectedPropertiesConfig = new LinkedHashSet<IRI>(Set.of(SomlOntology.PROTECTED_PROPERTY));
    private Boolean readShaclPropertiesLabels;
    private Boolean includeDeactivatedShapes;
    private Boolean cleanInvalidInverseOf;
    private Boolean useUnions;
    private Integer defaultMaxCardinality;
    private Boolean forceInterfaceTypes;
    private Boolean removeUnknownRanges;
    private Boolean readRbacRules;
    private static final Map<String, ConfigInfo> CONFIG_INFO_MAP;

    public Config(DataAccess data) {
        this.data = data;
    }

    public void loadConfigurations(@Nullable IRI modelId) {
        this.loadConfig(modelId, this.classes, "class");
        this.loadConfig(modelId, this.isInterface, "is interface");
        this.loadConfig(modelId, this.names, "name");
        this.loadConfig(modelId, this.labelProps, "label");
        this.loadConfig(modelId, this.descriptionProps, "description");
        this.loadConfig(modelId, this.propertyClasses, "property");
        this.loadConfig(modelId, this.dataPropertyClasses, "data type properties");
        this.loadConfig(modelId, this.objectPropertyClasses, "object type properties");
        this.loadConfig(modelId, this.privatePropertiesConfig, "private properties");
        this.loadConfig(modelId, this.protectedPropertiesConfig, "protected properties");
        this.loadConfig(modelId, this.creator, "creator");
        this.loadConfig(modelId, this.created, "created");
        this.loadConfig(modelId, this.modified, "modified");
        this.loadConfig(modelId, this.version, "version");
        this.loadConfig(modelId, this.language, "language");
        this.readShaclPropertiesLabels = this.isConfigurationEnabled((Boolean)this.getConfigDefaultValue(SomlOntology.READ_SHACL_PROPERTY_LABELS), modelId, SomlOntology.READ_SHACL_PROPERTY_LABELS);
        this.includeDeactivatedShapes = this.isConfigurationEnabled((Boolean)this.getConfigDefaultValue(SomlOntology.INCLUDE_DEACTIVATED_SHAPES), modelId, SomlOntology.INCLUDE_DEACTIVATED_SHAPES);
        this.cleanInvalidInverseOf = this.isConfigurationEnabled((Boolean)this.getConfigDefaultValue(SomlOntology.CLEAN_INVALID_INVERSE_OF), modelId, SomlOntology.CLEAN_INVALID_INVERSE_OF);
        this.useUnions = this.isConfigurationEnabled((Boolean)this.getConfigDefaultValue(SomlOntology.USE_UNIONS), modelId, SomlOntology.USE_UNIONS);
        this.forceInterfaceTypes = this.isConfigurationEnabled((Boolean)this.getConfigDefaultValue(SomlOntology.FORCE_INTERFACE_TYPES), modelId, SomlOntology.FORCE_INTERFACE_TYPES);
        this.removeUnknownRanges = this.isConfigurationEnabled((Boolean)this.getConfigDefaultValue(SomlOntology.REMOVE_UNKNOWN_RANGES), modelId, SomlOntology.REMOVE_UNKNOWN_RANGES);
        this.readRbacRules = this.isConfigurationEnabled((Boolean)this.getConfigDefaultValue(SomlOntology.READ_RBAC_RULES), modelId, SomlOntology.READ_RBAC_RULES);
        this.defaultMaxCardinality = this.data.getConfiguration(modelId, SomlOntology.DEFAULT_MAX_CARDINALITY).filter(Literal.class::isInstance).map(Literal.class::cast).map(literal -> {
            if (literal.stringValue().equalsIgnoreCase("inf")) {
                return Integer.MAX_VALUE;
            }
            return literal.integerValue().intValue();
        }).or(() -> Optional.ofNullable(this.defaultMaxCardinality)).orElse(Integer.MAX_VALUE);
    }

    private boolean isConfigurationEnabled(boolean defaultValue, @Nullable IRI modelId, IRI configPredicate) {
        Optional<Object> optValue = Optional.empty();
        if (Objects.nonNull(modelId)) {
            optValue = this.data.getConfiguration(modelId, configPredicate);
        }
        if (optValue.isEmpty()) {
            optValue = this.data.getConfiguration(null, configPredicate);
        }
        if (optValue.filter(Value::isLiteral).isPresent()) {
            return ((Literal)optValue.get()).booleanValue();
        }
        return defaultValue;
    }

    private Object getConfigDefaultValue(IRI configPredicate) {
        String key = configPredicate.getLocalName();
        ConfigInfo info = Config.getConfigInfo().get(key);
        return Objects.isNull(info) ? null : info.defaultValue();
    }

    private void loadConfig(@Nullable IRI modelId, Set<IRI> toConfigure, String label) {
        Set<IRI> alternatives = this.findAlternativesOf(modelId, toConfigure);
        if (!alternatives.isEmpty()) {
            Constants.LOGGER.info("The following additional predicates will be used for {} resolution: {}", (Object)label, alternatives);
            toConfigure.addAll(alternatives);
        }
    }

    public Set<IRI> getNames() {
        return this.names;
    }

    public Set<IRI> getLabelProps() {
        return this.labelProps;
    }

    public Set<IRI> getDescriptionProps() {
        return this.descriptionProps;
    }

    public Set<IRI> getIgnoredTypes() {
        return this.ignoredTypes;
    }

    public Set<IRI> getClasses() {
        return this.classes;
    }

    public Set<IRI> getIgnoredClasses() {
        return this.ignoredClasses;
    }

    public Set<IRI> getPropertyClasses() {
        return this.propertyClasses;
    }

    public Set<IRI> getDataPropertyClasses() {
        return this.dataPropertyClasses;
    }

    public Set<IRI> getObjectPropertyClasses() {
        return this.objectPropertyClasses;
    }

    public Set<IRI> getIgnoredProperties() {
        return this.ignoredProperties;
    }

    public Set<IRI> getCreator() {
        return this.creator;
    }

    public Set<IRI> getCreated() {
        return this.created;
    }

    public Set<IRI> getModified() {
        return this.modified;
    }

    public Set<IRI> getVersion() {
        return this.version;
    }

    public Set<IRI> getIsInterface() {
        return this.isInterface;
    }

    public Set<IRI> getCustomDataTypes() {
        if (this.dataTypes == null) {
            this.dataTypes = this.data.getCustomDataTypes();
        }
        return this.dataTypes;
    }

    public Predicate<Statement> subjectsAreValidClasses() {
        return statement -> this.isValidClass((Value)statement.getSubject());
    }

    public Predicate<Statement> objectsAreValidClasses() {
        return statement -> this.isValidClass(statement.getObject());
    }

    public boolean isValidClass(Value value) {
        IRI iri;
        return value instanceof IRI && this.iriIsNotExcludedClass(iri = (IRI)value) && Utils.iriIsNotDatatype((Resource)iri);
    }

    private boolean iriIsNotExcludedClass(IRI iri) {
        return !this.ignoredClasses.contains(iri);
    }

    public Predicate<Resource> isExcludedProp() {
        return resource -> resource instanceof IRI && this.getIgnoredProperties().contains(resource);
    }

    private Set<IRI> findAlternativesOf(@Nullable IRI modelId, Set<IRI> sourceIri) {
        return this.data.findAlternativeConfigurationsOf(modelId, sourceIri);
    }

    public Set<IRI> getLanguage() {
        return this.language;
    }

    public Set<IRI> getPrivatePropertiesConfig() {
        return this.privatePropertiesConfig;
    }

    public Set<IRI> getProtectedPropertiesConfig() {
        return this.protectedPropertiesConfig;
    }

    public boolean canReadShaclPropertyLabels() {
        return this.readShaclPropertiesLabels;
    }

    public boolean canIncludeDeactivatedShapes() {
        return this.includeDeactivatedShapes;
    }

    public boolean canCleanInvalidInverseOf() {
        return this.cleanInvalidInverseOf;
    }

    public boolean canUseUnions() {
        return this.useUnions;
    }

    public Integer getDefaultMaxCardinality() {
        return this.defaultMaxCardinality;
    }

    public Boolean getForceInterfaceTypes() {
        return this.forceInterfaceTypes;
    }

    public Boolean getRemoveUnknownRanges() {
        return this.removeUnknownRanges;
    }

    public Boolean getReadRbacRules() {
        return this.readRbacRules;
    }

    public static Map<String, ConfigInfo> getConfigInfo() {
        return CONFIG_INFO_MAP;
    }

    static {
        LinkedHashMap<String, ConfigInfo> cfg = new LinkedHashMap<String, ConfigInfo>();
        cfg.put(SomlOntology.READ_SHACL_PROPERTY_LABELS.getLocalName(), new ConfigInfo(SomlOntology.READ_SHACL_PROPERTY_LABELS.getLocalName(), SomlOntology.READ_SHACL_PROPERTY_LABELS, Boolean.class.getSimpleName().toLowerCase(), "If the labels and description for the sh:PropertyShape should be used over the sh:path label and description", (Object)Boolean.TRUE, null, false, null));
        cfg.put(SomlOntology.INCLUDE_DEACTIVATED_SHAPES.getLocalName(), new ConfigInfo(SomlOntology.INCLUDE_DEACTIVATED_SHAPES.getLocalName(), SomlOntology.INCLUDE_DEACTIVATED_SHAPES, Boolean.class.getSimpleName().toLowerCase(), "Include the sh:deactivated shapes in the model", (Object)Boolean.FALSE, null, false, null));
        cfg.put(SomlOntology.CLEAN_INVALID_INVERSE_OF.getLocalName(), new ConfigInfo(SomlOntology.CLEAN_INVALID_INVERSE_OF.getLocalName(), SomlOntology.CLEAN_INVALID_INVERSE_OF, Boolean.class.getSimpleName().toLowerCase(), "Try to fix invalid owl:inverseOf relations", (Object)Boolean.TRUE, null, false, null));
        cfg.put(SomlOntology.USE_UNIONS.getLocalName(), new ConfigInfo(SomlOntology.USE_UNIONS.getLocalName(), SomlOntology.USE_UNIONS, Boolean.class.getSimpleName().toLowerCase(), "Should GraphQL Unions be used in the result model", (Object)Boolean.TRUE, null, false, null));
        cfg.put(SomlOntology.DEFAULT_MAX_CARDINALITY.getLocalName(), new ConfigInfo(SomlOntology.DEFAULT_MAX_CARDINALITY.getLocalName(), SomlOntology.DEFAULT_MAX_CARDINALITY, String.class.getSimpleName().toLowerCase(), "The default maximum cardinality for all values. This defines if properties without explicit cardinality configuration are by default multi or single valued.", (Object)"inf", null, false, "^\\d+|inf$"));
        cfg.put(SomlOntology.FORCE_INTERFACE_TYPES.getLocalName(), new ConfigInfo(SomlOntology.FORCE_INTERFACE_TYPES.getLocalName(), SomlOntology.FORCE_INTERFACE_TYPES, Boolean.class.getSimpleName().toLowerCase(), "Decide if parent types are always interfaces or split with interface and subclass", (Object)Boolean.FALSE, null, false, null));
        cfg.put(SomlOntology.REMOVE_UNKNOWN_RANGES.getLocalName(), new ConfigInfo(SomlOntology.REMOVE_UNKNOWN_RANGES.getLocalName(), SomlOntology.REMOVE_UNKNOWN_RANGES, Boolean.class.getSimpleName().toLowerCase(), "Should remove the invalid and undefined ranges ", (Object)Boolean.TRUE, null, false, null));
        cfg.put(SomlOntology.READ_RBAC_RULES.getLocalName(), new ConfigInfo(SomlOntology.READ_RBAC_RULES.getLocalName(), SomlOntology.READ_RBAC_RULES, Boolean.class.getSimpleName().toLowerCase(), "Should check for RBAC rules", (Object)Boolean.TRUE, null, false, null));
        CONFIG_INFO_MAP = Collections.unmodifiableMap(cfg);
    }
}

